/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.MongoUtils;
import com.mongodb.DBObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bson.BSON;

public class DocumentSerializer {
    Format format;
    OutputStream os;
    boolean first = true;
    String fields;
    String[] filter;
    File file;
    String delimiter = ",";
    String header;

    public DocumentSerializer(Format format, String fields) {
        this.format = format;
        this.fields = fields;
        if (fields != null) {
            this.filter = fields.split(",");
            for (int i = 0; i < this.filter.length; ++i) {
                this.filter[i] = this.filter[i].trim();
            }
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public String getFields() {
        return this.fields;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private Object getFieldValueRecursive(DBObject obj, String field) {
        if (field.indexOf(".") < 0) {
            return obj.get(field);
        }
        String[] tokens = field.split("\\.");
        for (int i = 0; i < tokens.length - 1; ++i) {
            String f = tokens[i];
            if (!obj.containsField(f)) {
                return null;
            }
            Object o = obj.get(f);
            if (!DBObject.class.isInstance(o)) {
                return null;
            }
            obj = (DBObject)o;
        }
        return obj.get(tokens[tokens.length - 1]);
    }

    public void writeObject(DBObject obj) throws IOException {
        if (this.os == null) {
            this.os = new FileOutputStream(this.file);
        }
        if (this.first) {
            this.first = false;
            if (this.format == Format.CSV) {
                if (this.header != null && !this.header.isEmpty()) {
                    this.os.write(this.header.getBytes());
                } else {
                    this.os.write(this.fields.getBytes());
                }
                this.os.write(10);
            } else if (this.format == Format.JSON_ARRAY) {
                this.os.write(91);
            }
        } else if (this.format == Format.JSON_ARRAY) {
            this.os.write(44);
        }
        if (this.format == Format.CSV) {
            for (int i = 0; i < this.filter.length; ++i) {
                if (i != 0) {
                    this.os.write(this.delimiter.getBytes());
                }
                String field = this.filter[i];
                this.os.write(MongoUtils.getJSON(this.getFieldValueRecursive(obj, field)).getBytes());
            }
        } else if (this.format == Format.BSON) {
            this.os.write(BSON.encode(obj));
        } else {
            this.os.write(MongoUtils.getJSON(obj).getBytes());
        }
        if (this.format == Format.JSON || this.format == Format.CSV) {
            this.os.write(10);
        }
    }

    public void close() throws IOException {
        if (!this.first && this.format == Format.JSON_ARRAY) {
            this.os.write(93);
        }
        this.os.close();
    }

    void setDelimiter(String delimiter) {
        if (!delimiter.trim().isEmpty()) {
            this.delimiter = delimiter.substring(0, 1);
        }
    }

    void setHeader(String header) {
        if (!header.trim().isEmpty()) {
            this.header = header;
        }
    }

    public static enum Format {
        JSON,
        JSON_ARRAY,
        CSV,
        BSON;

    }
}

