/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.PopUpMenu;
import com.edgytech.swingfast.Tree;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocView;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.TreeNodeDocument;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

public class DocumentMenu
extends PopUpMenu
implements EnumListener<Item> {
    public DocumentMenu() {
        this.setEnumBinding(Item.values(), this);
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void update(ButtonBase button) {
        final DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocument node = (TreeNodeDocument)dv.getSelectedNode().getUserObject();
        DBObject doc = node.getDBObject();
        ((DocBuilderField)this.getBoundUnit(Item.upUpdate)).setDBObject((BasicDBObject)doc);
        if (!((MenuItem)this.getBoundUnit(Item.update)).getDialog().show()) {
            return;
        }
        final DBObject query = doc.containsField("_id") ? new BasicDBObject("_id", doc.get("_id")) : doc;
        final DBObject update = ((DocBuilderField)this.getBoundUnit(Item.upUpdate)).getDBObject();
        if (dv.getDBCursor() == null) {
            Tree tree = dv.getTree();
            tree.removeChild(node);
            dv.addDocument(update, null);
            tree.structureComponent();
            tree.expandNode(tree.getTreeNode());
            return;
        }
        final DBCollection col = dv.getDBCursor().getCollection();
        new DbJob(){

            @Override
            public Object doRun() {
                return col.update(query, update, false, false);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Update";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                return obj;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                dv.refresh(null);
            }
        }.addJob();
    }

    public void remove(ButtonBase button) {
        final DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocument node = (TreeNodeDocument)dv.getSelectedNode().getUserObject();
        DBObject doc = node.getDBObject();
        if (dv.getDBCursor() == null) {
            Tree tree = dv.getTree();
            tree.removeChild(node);
            tree.structureComponent();
            tree.expandNode(tree.getTreeNode());
            return;
        }
        final DBObject query = doc.containsField("_id") ? new BasicDBObject("_id", doc.get("_id")) : doc;
        final DBCollection col = dv.getDBCursor().getCollection();
        new DbJob(){

            @Override
            public Object doRun() {
                return col.remove(query);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Remove";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                dv.refresh(null);
            }

            @Override
            public DBObject getRoot(Object result) {
                return query;
            }
        }.addJob();
    }

    public void copyValue(ButtonBase button) {
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocument node = (TreeNodeDocument)dv.getSelectedNode().getUserObject();
        DBObject doc = node.getDBObject();
        String selection = MongoUtils.getJSON(doc);
        StringSelection data = new StringSelection(selection);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    static enum Item {
        update,
        upUpdate,
        remove,
        copyValue;

    }
}

