/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FileSelectorField;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.PopUpMenu;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BinaryDecoder;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DocView;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.TreeNodeDocumentField;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.bson.types.Binary;

public class DocumentFieldMenu
extends PopUpMenu
implements EnumListener<Item> {
    public DocumentFieldMenu() {
        this.setEnumBinding(Item.values(), this);
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void setValue(ButtonBase button) {
        final DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        if (dv.getDBCursor() == null) {
            new InfoDialog(null, null, null, "Cannot do in-place update on local data.").show();
            return;
        }
        TreeNodeDocumentField field = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        DBObject doc = dv.getSelectedDocument();
        String path = dv.getSelectedDocumentPath();
        Object newValue = UMongo.instance.getGlobalStore().editValue(field.getKey(), field.getValue());
        if (newValue == null) {
            return;
        }
        final DBObject query = doc.containsField("_id") ? new BasicDBObject("_id", doc.get("_id")) : doc;
        BasicDBObject setValue = new BasicDBObject(path, newValue);
        final BasicDBObject update = new BasicDBObject("$set", setValue);
        final DBCollection col = dv.getDBCursor().getCollection();
        new DbJob(){

            @Override
            public Object doRun() {
                return col.update(query, update, false, false);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Update";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                return obj;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                dv.refresh(null);
            }
        }.addJob();
    }

    public void unsetValue(ButtonBase button) {
        final DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        DBObject doc = dv.getSelectedDocument();
        String path = dv.getSelectedDocumentPath();
        if (dv.getDBCursor() == null) {
            new InfoDialog(null, null, null, "Cannot do in-place update on local data.").show();
            return;
        }
        if (!UMongo.instance.getGlobalStore().confirmDataLossOperation()) {
            return;
        }
        final DBObject query = doc.containsField("_id") ? new BasicDBObject("_id", doc.get("_id")) : doc;
        BasicDBObject setValue = new BasicDBObject(path, (Object)1);
        final BasicDBObject update = new BasicDBObject("$unset", setValue);
        final DBCollection col = dv.getDBCursor().getCollection();
        new DbJob(){

            @Override
            public Object doRun() {
                return col.update(query, update, false, false);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Update";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                return obj;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                dv.refresh(null);
            }
        }.addJob();
    }

    public void copyKey(ButtonBase button) {
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocumentField node = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        StringSelection data = new StringSelection(node.getKey().toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    public void copyValue(ButtonBase button) {
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocumentField node = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        StringSelection data = new StringSelection(MongoUtils.getJSON(node.getValue()));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    public void compressionStats(ButtonBase button) throws IOException {
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocumentField node = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        Object value = node.getValue();
        byte[] bytes = null;
        bytes = value instanceof byte[] ? (byte[])value : (value instanceof Binary ? ((Binary)value).getData() : MongoUtils.getJSON(value).toString().getBytes(Charset.forName("UTF-8")));
        this.setStringFieldValue(Item.compressionStatsOriginal, String.valueOf(bytes.length));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        baos.reset();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        dos.write(bytes);
        dos.close();
        byte[] deflate = baos.toByteArray();
        this.setStringFieldValue(Item.compressionStatsDeflate, String.valueOf(deflate.length));
        baos.reset();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(bytes);
        gos.close();
        byte[] gzip = baos.toByteArray();
        this.setStringFieldValue(Item.compressionStatsGZip, String.valueOf(gzip.length));
        Showable dia = ((MenuItem)this.getBoundComponentUnit(Item.compressionStats)).getDialog();
        dia.show();
    }

    public void saveBinaryToFile(ButtonBase button) throws IOException {
        String path = ((FileSelectorField)this.getBoundComponentUnit(Item.saveBinaryOutputFile)).getPath();
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocumentField node = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        Object value = node.getValue();
        byte[] bytes = null;
        bytes = value instanceof byte[] ? (byte[])value : (value instanceof Binary ? ((Binary)value).getData() : MongoUtils.getJSON(value).toString().getBytes(Charset.forName("UTF-8")));
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(bytes);
        fos.close();
    }

    public void decodeBinary(ButtonBase button) throws IOException {
        DocView dv = (DocView)UMongo.instance.getTabbedResult().getSelectedUnit();
        TreeNodeDocumentField node = (TreeNodeDocumentField)dv.getSelectedNode().getUserObject();
        Object value = node.getValue();
        byte[] bytes = null;
        bytes = value instanceof byte[] ? (byte[])value : (value instanceof Binary ? ((Binary)value).getData() : MongoUtils.getJSON(value).toString().getBytes(Charset.forName("UTF-8")));
        BinaryDecoder dec = UMongo.instance.getBinaryDecoder();
        this.setStringFieldValue(Item.decodeBinaryText, dec.getText(bytes));
        FormDialog dia = (FormDialog)button.getDialog();
        dia.show();
    }

    static enum Item {
        setValue,
        unsetValue,
        compressionStats,
        compressionStatsOriginal,
        compressionStatsDeflate,
        compressionStatsGZip,
        saveBinaryToFile,
        saveBinaryOutputFile,
        decodeBinary,
        decodeBinaryText,
        copyKey,
        copyValue;

    }
}

