/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCallback;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBCallback;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BasicBSONDecoder;

public class DocumentDeserializer {
    Format format;
    boolean first = true;
    String fields;
    String[] filter;
    File file;
    BufferedReader br;
    InputStream is;
    DBCallback callback;
    BSONDecoder decoder;
    Iterator iterator;
    BasicDBObject template;
    String delimiter = ",";
    String quote = "\"";
    Pattern pattern;

    public DocumentDeserializer(Format format, String fields) {
        this.format = format;
        this.fields = fields;
        if (fields != null) {
            this.filter = fields.split(",");
            for (int i = 0; i < this.filter.length; ++i) {
                this.filter[i] = this.filter[i].trim();
            }
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public String getFields() {
        return this.fields;
    }

    void setTemplate(BasicDBObject template) {
        this.template = template;
    }

    public void setInputStream(InputStream is) {
        this.is = is;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public DocumentIterator iterator() {
        return new DocumentIterator();
    }

    private List<String> splitByCommasNotInQuotes(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.pattern == null) {
            this.pattern = Pattern.compile("[" + this.quote + this.delimiter + "]");
        }
        Matcher m = this.pattern.matcher(s);
        int pos = 0;
        boolean quoteMode = false;
        boolean wasQuoted = false;
        while (m.find()) {
            String sep = m.group();
            if (this.quote.equals(sep)) {
                int qpos = m.start();
                if (!quoteMode) {
                    if (qpos != pos) continue;
                    quoteMode = true;
                    wasQuoted = true;
                    continue;
                }
                quoteMode = false;
                continue;
            }
            if (quoteMode || !this.delimiter.equals(sep)) continue;
            int toPos = m.start();
            String token = s.substring(pos, toPos);
            if (wasQuoted) {
                token = token.substring(this.quote.length(), token.length() - this.quote.length());
            }
            list.add(token);
            pos = m.end();
            wasQuoted = false;
        }
        if (pos <= s.length()) {
            list.add(s.substring(pos));
        }
        return list;
    }

    public DBObject readObject() throws IOException {
        if (this.first) {
            if (this.format != Format.BSON) {
                if (this.is == null) {
                    FileReader fr = new FileReader(this.file);
                    this.br = new BufferedReader(fr);
                } else {
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                }
                if (this.format == Format.CSV) {
                    this.fields = this.br.readLine();
                    if (this.fields != null) {
                        this.filter = this.fields.split(this.delimiter);
                        for (int i = 0; i < this.filter.length; ++i) {
                            this.filter[i] = this.filter[i].trim();
                        }
                    }
                }
            } else {
                if (this.is == null) {
                    this.is = new FileInputStream(this.file);
                }
                this.callback = new DefaultDBCallback(null);
                this.decoder = new BasicBSONDecoder();
            }
            if (this.format == Format.JSON_ARRAY) {
                String line = this.br.readLine();
                BasicDBList list = (BasicDBList)JSON.parse(line);
                this.iterator = list.iterator();
            }
            this.first = false;
        }
        if (this.format == Format.JSON_ARRAY) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                return null;
            }
            return (DBObject)this.iterator.next();
        }
        DBObject obj = null;
        if (this.format != Format.BSON) {
            String line = this.br.readLine();
            if (line == null) {
                return null;
            }
            if (this.format == Format.JSON_SINGLE_DOC) {
                String line2 = null;
                while ((line2 = this.br.readLine()) != null) {
                    line = line + line2;
                }
            }
            if (this.format == Format.CSV) {
                List<String> values = this.splitByCommasNotInQuotes(line);
                if (this.template == null) {
                    obj = new BasicDBObject();
                    for (int i = 0; i < this.filter.length; ++i) {
                        String val = values.get(i);
                        obj.put(this.filter[i], JSON.parse(val));
                    }
                } else {
                    obj = (BasicDBObject)this.template.copy();
                    this.fillInTemplate(obj, values);
                }
            } else {
                obj = (DBObject)JSON.parse(line);
            }
        } else {
            this.callback.reset();
            try {
                this.decoder.decode(this.is, (BSONCallback)this.callback);
            }
            catch (IOException e) {
                return null;
            }
            obj = (DBObject)this.callback.get();
        }
        return obj;
    }

    public void close() throws IOException {
        if (this.br != null) {
            this.br.close();
        }
        if (this.is != null) {
            this.is.close();
        }
    }

    private void fillInTemplate(DBObject obj, List<String> values) {
        for (String field : obj.keySet()) {
            Object val = obj.get(field);
            if (val instanceof BasicDBObject) {
                this.fillInTemplate((BasicDBObject)val, values);
                continue;
            }
            if (val instanceof BasicDBList) {
                this.fillInTemplate((BasicDBList)val, values);
                continue;
            }
            if (val instanceof String) {
                String str = (String)val;
                if (str.startsWith("$")) {
                    int index;
                    str = str.substring(1);
                    int slash = str.indexOf("/");
                    String ref = str;
                    String type = null;
                    if (slash > 0) {
                        ref = str.substring(0, slash);
                        type = str.substring(slash + 1);
                    }
                    for (index = 0; index < this.filter.length && !this.filter[index].equals(ref); ++index) {
                    }
                    if (index >= this.filter.length) continue;
                    String value = values.get(index);
                    try {
                        if (type == null || "JSON".equals(type)) {
                            obj.put(field, JSON.parse(value));
                            continue;
                        }
                        if ("String".equals(type)) {
                            obj.put(field, value);
                            continue;
                        }
                        if ("Date".equals(type)) {
                            Long time = Long.valueOf(value);
                            obj.put(field, new Date(time));
                            continue;
                        }
                        if ("Boolean".equals(type)) {
                            obj.put(field, Boolean.valueOf(value));
                            continue;
                        }
                        if ("Integer".equals(type)) {
                            obj.put(field, Integer.valueOf(value));
                            continue;
                        }
                        if ("Long".equals(type)) {
                            obj.put(field, Long.valueOf(value));
                            continue;
                        }
                        if (!"Double".equals(type)) continue;
                        obj.put(field, Double.valueOf(value));
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DocumentDeserializer.class.getName()).log(Level.WARNING, null, ex);
                    }
                    continue;
                }
                obj.put(field, val);
                continue;
            }
            obj.put(field, val);
        }
    }

    void setDelimiter(String delimiter) {
        if (!delimiter.trim().isEmpty()) {
            this.delimiter = delimiter.substring(0, 1);
        }
    }

    void setQuote(String quote) {
        if (!quote.trim().isEmpty()) {
            this.quote = quote.substring(0, 1);
        }
    }

    public class DocumentIterator
    implements Iterator<DBObject> {
        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public DBObject next() {
            try {
                return DocumentDeserializer.this.readObject();
            }
            catch (IOException ex) {
                Logger.getLogger(DocumentDeserializer.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static enum Format {
        JSON,
        JSON_ARRAY,
        JSON_SINGLE_DOC,
        CSV,
        BSON;

    }
}

