/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.TabInterface;
import com.edgytech.swingfast.TabbedDiv;
import com.edgytech.swingfast.Tree;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.Zone;
import com.edgytech.umongo.AutoUpdateDialog;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DocumentSerializer;
import com.edgytech.umongo.ExportDialog;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.TreeNodeDocument;
import com.edgytech.umongo.TreeNodeDocumentField;
import com.edgytech.umongo.UMongo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DocView
extends Zone
implements EnumListener,
TabInterface,
Runnable {
    Iterator<DBObject> iterator;
    DBCursor dbcursor;
    TabbedDiv tabbedDiv;
    Thread updateThread;
    String updateType;
    int updateInterval;
    int updateCount;
    boolean running;
    DbJob job;

    public DocView(String id, String label, DbJob job, Object root) {
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.docView, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.setEnumBinding(Item.values(), this);
        this.setId(id);
        this.setLabel(label);
        this.job = job;
        this.setStringFieldValue(Item.tabTitle, label);
        this.getTree().label = root.toString();
        if (job != null) {
            if (job.getButton() != null) {
                this.getComponentBoundUnit((Enum)Item.spawn).enabled = true;
            }
            ((MenuItem)this.getBoundUnit((Enum)Item.refresh)).enabled = true;
            ((MenuItem)this.getBoundUnit((Enum)Item.append)).enabled = true;
            ((MenuItem)this.getBoundUnit((Enum)Item.startAutoUpdate)).enabled = true;
        }
    }

    public DocView(String id, String label, DbJob job, Object root, DBObject doc) {
        this(id, label, job, root);
        if (doc != null) {
            this.addDocument(doc, job, true);
        }
    }

    public DocView(String id, String label, DbJob job, Object root, Iterator<DBObject> iterator) {
        this(id, label, job, root);
        if (iterator instanceof DBCursor) {
            this.iterator = this.dbcursor = (DBCursor)iterator;
            ((MenuItem)this.getBoundUnit((Enum)Item.refresh)).enabled = true;
            ((MenuItem)this.getBoundUnit((Enum)Item.startAutoUpdate)).enabled = true;
        } else {
            this.iterator = iterator;
        }
        this.getMore(null);
    }

    Tree getTree() {
        return (Tree)this.getBoundUnit(Item.docTree);
    }

    public DBCursor getDBCursor() {
        return this.dbcursor;
    }

    public void close(ButtonBase button) {
        if (this.dbcursor != null) {
            this.dbcursor.close();
            this.dbcursor = null;
        }
        this.tabbedDiv.removeTab(this);
    }

    void addToTabbedDiv() {
        this.tabbedDiv = UMongo.instance.getTabbedResult();
        this.tabbedDiv.addTab(this, true);
        this.getTree().expandNode(this.getTree().getTreeNode());
    }

    public void actionPerformed(Enum enm, XmlComponentUnit unit, Object src) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ButtonBase button) throws IOException {
        ExportDialog dia = UMongo.instance.getGlobalStore().getExportDialog();
        if (!dia.show()) {
            return;
        }
        DocumentSerializer ds = dia.getDocumentSerializer();
        try {
            DefaultMutableTreeNode root = this.getTree().getTreeNode();
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
                Object obj = child.getUserObject();
                DBObject doc = null;
                if (obj instanceof DBObject) {
                    doc = (DBObject)obj;
                } else if (obj instanceof TreeNodeDocumentField) {
                    doc = (DBObject)((TreeNodeDocumentField)obj).getValue();
                } else if (obj instanceof TreeNodeDocument) {
                    doc = ((TreeNodeDocument)obj).getDBObject();
                }
                if (doc == null) continue;
                ds.writeObject(doc);
            }
        }
        finally {
            ds.close();
        }
    }

    @Override
    public Component getTabComponent() {
        return this.getComponentBoundUnit("tabDiv").getComponent();
    }

    public void startAutoUpdate(ButtonBase button) {
        AutoUpdateDialog dia = UMongo.instance.getGlobalStore().getAutoUpdateDialog();
        if (!dia.show()) {
            return;
        }
        if (this.updateThread != null) {
            this.stopAutoUpdate(null);
        }
        this.updateThread = new Thread(this);
        this.updateType = dia.getComponentStringFieldValue(AutoUpdateDialog.Item.autoType);
        this.updateInterval = dia.getComponentIntFieldValue(AutoUpdateDialog.Item.autoInterval);
        this.updateCount = dia.getComponentIntFieldValue(AutoUpdateDialog.Item.autoCount);
        this.running = true;
        this.updateThread.start();
        this.getComponentBoundUnit((Enum)Item.stopAutoUpdate).enabled = true;
        this.getComponentBoundUnit(Item.stopAutoUpdate).updateComponent();
    }

    public void stopAutoUpdate(ButtonBase button) {
        this.running = false;
        try {
            this.updateThread.interrupt();
            this.updateThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updateThread = null;
        this.getComponentBoundUnit((Enum)Item.stopAutoUpdate).enabled = false;
        this.getComponentBoundUnit(Item.stopAutoUpdate).updateComponent();
    }

    @Override
    public void run() {
        int i = 0;
        while (this.running) {
            try {
                DbJob job = null;
                if ("Refresh".equals(this.updateType) || this.dbcursor != null) {
                    job = this.getRefreshJob();
                } else if ("Append".equals(this.updateType)) {
                    job = this.getAppendJob();
                }
                final DbJob fjob = job;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        fjob.addJob();
                    }
                });
                try {
                    fjob.join();
                }
                catch (InterruptedException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                catch (ExecutionException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                if (this.updateCount > 0 && ++i >= this.updateCount) break;
                Thread.sleep(this.updateInterval * 1000);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        this.getLogger().log(Level.INFO, "Ran " + i + " updates");
    }

    public void refresh(ButtonBase button) {
        this.getRefreshJob().addJob();
    }

    public DbJob getRefreshJob() {
        if (this.dbcursor != null) {
            return this.getUpdateCursorJob();
        }
        return this.getRefreshJob(false);
    }

    public void append(ButtonBase button) {
        this.getAppendJob().addJob();
    }

    public DbJob getAppendJob() {
        return this.getRefreshJob(true);
    }

    public void spawn(ButtonBase button) {
        if (this.job != null) {
            this.job.spawnDialog();
        }
    }

    public void expandText(ButtonBase button) throws IOException {
        FormDialog dia = (FormDialog)button.getDialog();
        DefaultMutableTreeNode root = this.getTree().getTreeNode();
        DefaultMutableTreeNode select = this.getTree().getSelectionNode();
        String txt = "";
        txt = select == null || select == root ? this.getTextAllNodes(false) : this.getTextForNode(select.getUserObject(), false);
        this.setStringFieldValue(Item.expandTextArea, txt);
        dia.label = this.label;
        dia.show();
    }

    String getTextAllNodes(boolean indent) throws IOException {
        StringBuilder b = new StringBuilder();
        DefaultMutableTreeNode root = this.getTree().getTreeNode();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            Object obj = child.getUserObject();
            b.append(this.getTextForNode(obj, indent));
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTextForNode(Object obj, boolean indent) throws IOException {
        DBObject doc = null;
        if (obj instanceof DBObject) {
            doc = (DBObject)obj;
        } else if (obj instanceof TreeNodeDocumentField) {
            doc = (DBObject)((TreeNodeDocumentField)obj).getValue();
        } else if (obj instanceof TreeNodeDocument) {
            doc = ((TreeNodeDocument)obj).getDBObject();
        }
        if (doc == null) {
            return "";
        }
        DocumentSerializer ds = new DocumentSerializer(DocumentSerializer.Format.JSON, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ds.setOutputStream(baos);
        try {
            ds.writeObject(doc);
        }
        finally {
            ds.close();
        }
        String txt = new String(baos.toByteArray());
        if (indent) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(txt);
            txt = gson.toJson(je);
            txt = txt + "\n";
        }
        return txt;
    }

    public void indent(ButtonBase button) throws IOException {
        DefaultMutableTreeNode root = this.getTree().getTreeNode();
        DefaultMutableTreeNode select = this.getTree().getSelectionNode();
        String txt = "";
        txt = select == null || select == root ? this.getTextAllNodes(true) : this.getTextForNode(select.getUserObject(), true);
        this.setComponentStringFieldValue(Item.expandTextArea, txt);
    }

    public DbJob getRefreshJob(final boolean append) {
        if (this.job == null) {
            return null;
        }
        DbJob newJob = new DbJob(){
            BasicDBObject result;

            @Override
            public Object doRun() throws Exception {
                this.result = (BasicDBObject)DocView.this.job.doRun();
                return null;
            }

            @Override
            public String getNS() {
                return DocView.this.job.getNS();
            }

            @Override
            public String getShortName() {
                return DocView.this.job.getShortName();
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (res == null && this.result != null) {
                    if (!append) {
                        DocView.this.getTree().removeAllChildren();
                    }
                    DocView.this.addDocument(this.result, this);
                    DocView.this.getTree().structureComponent();
                    DocView.this.getTree().expandAll();
                    if (DocView.this.job.getPanel() != null) {
                        DocView.this.job.getPanel().refresh();
                    }
                }
            }
        };
        return newJob;
    }

    public void getMore(final int max) {
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                DBObject obj;
                int i = 0;
                while (DocView.this.iterator.hasNext() && (i++ < max || max <= 0) && (obj = DocView.this.iterator.next()) != null) {
                    DocView.this.addDocument(obj, null);
                }
                return null;
            }

            @Override
            public String getNS() {
                if (DocView.this.dbcursor != null) {
                    return DocView.this.dbcursor.getCollection().getFullName();
                }
                return this.getLabel();
            }

            @Override
            public String getShortName() {
                return "Find";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (res == null) {
                    if (DocView.this.dbcursor != null) {
                        BasicDBObject desc = this.getDescription(DocView.this.job.getRoot(DocView.this.dbcursor));
                        DocView.this.getTree().label = desc.toString();
                    }
                    DocView.this.getTree().structureComponent();
                    DocView.this.getTree().expandNode(DocView.this.getTree().getTreeNode());
                    DocView.this.updateButtons();
                }
            }
        }.addJob();
    }

    public void getMore(ButtonBase button) {
        this.getMore(UMongo.instance.getPreferences().getGetMoreSize());
    }

    public void getAll(ButtonBase button) {
        this.getMore(0);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getTree().getSelectionPath();
        if (path == null || path.getPathCount() < 2) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public DBObject getSelectedDocument() {
        TreePath path = this.getTree().getSelectionPath();
        if (path == null || path.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
        Object obj = node.getUserObject();
        if (obj instanceof TreeNodeDocumentField) {
            return (DBObject)((TreeNodeDocumentField)obj).getValue();
        }
        if (obj instanceof DBObject) {
            return (DBObject)obj;
        }
        if (obj instanceof TreeNodeDocument) {
            return ((TreeNodeDocument)obj).getDBObject();
        }
        return null;
    }

    String getSelectedDocumentPath() {
        TreePath path = this.getTree().getSelectionPath();
        String pathStr = "";
        if (path.getPathCount() < 2) {
            return null;
        }
        for (int i = 2; i < path.getPathCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(i);
            String key = ((TreeNodeDocumentField)node.getUserObject()).getKey();
            pathStr = pathStr + "." + key;
        }
        return pathStr.substring(1);
    }

    public DbJob getUpdateCursorJob() {
        if (this.dbcursor == null) {
            return null;
        }
        DbJob newJob = new DbJob(){

            @Override
            public Object doRun() throws Exception {
                DocView.this.dbcursor = (DBCursor)DocView.this.job.doRun();
                return null;
            }

            @Override
            public String getNS() {
                return DocView.this.job.getNS();
            }

            @Override
            public String getShortName() {
                return DocView.this.job.getShortName();
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (res == null) {
                    DocView.this.iterator = DocView.this.dbcursor;
                    DocView.this.getTree().removeAllChildren();
                    DocView.this.getMore(null);
                }
            }
        };
        return newJob;
    }

    private void updateButtons() {
        boolean canGetMore = false;
        canGetMore = this.dbcursor != null ? this.iterator.hasNext() || this.dbcursor.getCursorId() > 0L : this.iterator.hasNext();
        this.getComponentBoundUnit((Enum)Item.getMore).enabled = canGetMore;
        this.getComponentBoundUnit(Item.getMore).updateComponent();
        this.getComponentBoundUnit((Enum)Item.getAll).enabled = canGetMore;
        this.getComponentBoundUnit(Item.getAll).updateComponent();
    }

    public void addDocument(DBObject doc, DbJob job) {
        this.addDocument(doc, job, false);
    }

    public void addDocument(DBObject doc, DbJob job, boolean expand) {
        TreeNodeDocument node = new TreeNodeDocument(doc, job);
        this.getTree().addChild(node);
        if (expand) {
            this.getTree().expandNode(node);
        }
    }

    public void collapseAll(ButtonBase button) {
        this.getTree().collapseAll();
        this.getTree().expandNode(this.getTree().getTreeNode());
    }

    public void expandAll(ButtonBase button) {
        this.getTree().expandAll();
    }

    static enum Item {
        docTree,
        tabDiv,
        tabTitle,
        tabClose,
        refresh,
        append,
        expandText,
        expandTextArea,
        indent,
        spawn,
        export,
        cursor,
        getMore,
        getAll,
        tools,
        startAutoUpdate,
        stopAutoUpdate,
        expandAll,
        collapseAll;

    }
}

