/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.Div;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.Text;
import com.edgytech.umongo.DocFieldArray;
import com.edgytech.umongo.DocFieldText;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class DocFieldObject
extends DocFieldText {
    public DocFieldObject(String id, String key, Object value, DocFieldObject parent) {
        super(id, key, value, parent);
        this.getJComponentBoundUnit((Enum)DocFieldText.Item.edit).visible = false;
        this.getJComponentBoundUnit((Enum)DocFieldText.Item.addField).visible = true;
        ((Div)this.getJComponentBoundUnit((Enum)DocFieldText.Item.fields)).borderSize = 1;
        if (parent == null) {
            this.field = false;
            this.getJComponentBoundUnit((Enum)DocFieldText.Item.up).visible = false;
            this.getJComponentBoundUnit((Enum)DocFieldText.Item.down).visible = false;
            this.getJComponentBoundUnit((Enum)DocFieldText.Item.remove).visible = false;
        }
    }

    @Override
    protected void structureComponentCustom(BoxPanel old) {
        Div fields = (Div)this.getBoundUnit(DocFieldText.Item.fields);
        fields.removeAllChildren();
        DBObject doc = (DBObject)this.value;
        if (doc == null || doc.keySet().isEmpty()) {
            fields.addChild(new Text(null, null, "Empty"));
        } else {
            for (String key : doc.keySet()) {
                Object val = doc.get(key);
                if (val instanceof BasicDBObject) {
                    fields.addChild(new DocFieldObject(key, key, val, this));
                    continue;
                }
                if (val instanceof BasicDBList) {
                    fields.addChild(new DocFieldArray(key, key, val, this));
                    continue;
                }
                fields.addChild(new DocFieldText(key, key, val, this));
            }
        }
        fields.structureComponent();
        super.structureComponentCustom(old);
    }

    @Override
    protected void commitComponentCustom(BoxPanel comp) {
        Div fields = (Div)this.getBoundUnit(DocFieldText.Item.fields);
        DBObject doc = this.createDBObject();
        if (fields.hasChildren()) {
            for (Object child : fields.getChildren()) {
                if (!(child instanceof DocFieldText)) continue;
                DocFieldText text = (DocFieldText)child;
                doc.put(text.getKey(), text.getValue());
            }
        }
        this.value = doc;
    }

    void remove(String key) {
        DBObject doc = (DBObject)this.value;
        doc.removeField(key);
        this.structureComponent();
    }

    void moveUp(String key) {
        DBObject doc = (DBObject)this.value;
        this.value = this.createDBObject();
        Iterator<String> it = doc.keySet().iterator();
        String prev = it.next();
        while (it.hasNext()) {
            String cur = it.next();
            if (cur.equals(key)) {
                this.addField(cur, doc.get(cur));
                cur = prev;
            } else {
                this.addField(prev, doc.get(prev));
            }
            prev = cur;
        }
        this.addField(prev, doc.get(prev));
        this.structureComponent();
    }

    void moveDown(String key) {
        DBObject doc = (DBObject)this.value;
        this.value = this.createDBObject();
        Iterator<String> it = doc.keySet().iterator();
        while (it.hasNext()) {
            String cur = it.next();
            if (cur.equals(key) && it.hasNext()) {
                String next = it.next();
                this.addField(next, doc.get(next));
            }
            this.addField(cur, doc.get(cur));
        }
        this.structureComponent();
    }

    public void addNewField(String key, String type) {
        Object val = "";
        if (type.equals("Integer")) {
            val = new Integer(0);
        } else if (type.startsWith("Long")) {
            val = new Long(0L);
        } else if (type.equals("Binary")) {
            val = new Binary(0, new byte[1]);
        } else if (type.startsWith("ObjectId")) {
            val = new ObjectId();
        } else if (type.equals("Boolean")) {
            val = new Boolean(true);
        } else if (type.equals("Code")) {
            val = new Code("");
        } else if (type.equals("Date")) {
            val = new Date();
        } else if (type.startsWith("Double")) {
            val = new Double(0.0);
        } else if (type.equals("Pattern")) {
            val = Pattern.compile("");
        } else if (type.equals("Timestamp")) {
            val = new BSONTimestamp((int)(System.currentTimeMillis() / 1000L), 0);
        } else if (type.equals("Document")) {
            val = new BasicDBObject();
        } else if (type.equals("List")) {
            val = new BasicDBList();
        } else if (type.equals("Null")) {
            val = null;
        } else if (type.equals("UUID")) {
            val = UUID.randomUUID();
        } else if (type.equals("MinKey")) {
            val = new MinKey();
        } else if (type.equals("MaxKey")) {
            val = new MaxKey();
        }
        if (this.value == null) {
            this.value = this.createDBObject();
        }
        this.addField(key, val);
        this.structureComponent();
    }

    public void addField(ButtonBase button) {
        String key = this.getStringFieldValue(DocFieldText.Item.addKey);
        String type = this.getStringFieldValue(DocFieldText.Item.addType);
        DBObject doc = (DBObject)this.value;
        if (key.isEmpty() || doc != null && doc.containsField(key)) {
            new InfoDialog(null, "Invalid Key", null, "Please provide a unique key for this field").show();
            return;
        }
        this.addNewField(key, type);
    }

    protected void addField(String key, Object val) {
        DBObject doc = (DBObject)this.value;
        doc.put(key, val);
    }

    protected DBObject createDBObject() {
        return new BasicDBObject();
    }
}

