/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.Div;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.TextArea;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.umongo.DocBuilderDialog;
import com.edgytech.umongo.JSONTextDialog;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.UMongo;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Level;

public class DocBuilderField
extends Div
implements EnumListener,
FocusListener {
    @XmlUnit.Serial
    public String dialogId;
    @XmlUnit.Serial
    public boolean nonEmpty = false;
    @XmlUnit.SerialStar
    public String value;
    DBObject doc;

    public DocBuilderField() {
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.docBuilderField, null);
            this.setState(XmlUnit.State.STRUCTURE);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.setEnumBinding(Item.values(), this);
    }

    public void actionPerformed(Enum enm, XmlComponentUnit unit, Object src) {
    }

    public void edit(ButtonBase button) {
        String txt = this.getComponentStringFieldValue(Item.jsonText);
        try {
            this.doc = (DBObject)JSON.parse(txt);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.INFO, null, ex);
        }
        DocBuilderDialog dialog = UMongo.instance.getGlobalStore().getDocBuilderDialog();
        dialog.setDBObject(this.doc);
        if (!dialog.show()) {
            return;
        }
        this.doc = dialog.getDBObject();
        this.value = MongoUtils.getJSON(this.doc);
        this.setComponentStringFieldValue(Item.jsonText, this.value);
        this.notifyListener(this.getComponent());
    }

    public void expandText(ButtonBase button) {
        String txt = this.getComponentStringFieldValue(Item.jsonText);
        JSONTextDialog dia = UMongo.instance.getGlobalStore().getJSONTextDialog();
        dia.setText(txt);
        if (dia.show()) {
            this.setComponentStringFieldValue(Item.jsonText, dia.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.notifyListener(this.getComponent());
    }

    @Override
    protected boolean checkComponentCustom(BoxPanel comp) {
        String txt = this.getComponentStringFieldValue(Item.jsonText);
        if (this.nonEmpty && txt.isEmpty()) {
            this.setDisplayError("Field cannot be empty");
            return false;
        }
        if (!this.getComponentBooleanFieldValue(Item.validate)) {
            return true;
        }
        try {
            MongoUtils.getJsonParser().parse(txt);
            DBObject doc = (DBObject)JSON.parse(txt);
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, null, e);
            this.setDisplayError("Invalid JSON format: correct or disable validation");
            return false;
        }
    }

    @Override
    protected void updateComponentCustom(BoxPanel old) {
        this.setStringFieldValue(Item.jsonText, this.value);
        ((TextArea)this.getComponentBoundUnit((Enum)Item.jsonText)).editable = this.enabled;
        this.getComponentBoundUnit((Enum)Item.edit).enabled = this.enabled;
        this.getComponentBoundUnit((Enum)Item.expandText).enabled = this.enabled;
    }

    @Override
    protected void commitComponentCustom(BoxPanel comp) {
        try {
            this.value = this.getStringFieldValue(Item.jsonText);
            this.doc = (DBObject)JSON.parse(this.value);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, null, e);
        }
    }

    public void setDBObject(DBObject obj) {
        this.doc = obj;
        this.value = this.doc != null ? MongoUtils.getJSON(this.doc) : "";
        this.setStringFieldValue(Item.jsonText, this.value);
    }

    public DBObject getDBObject() {
        return this.doc;
    }

    static enum Item {
        expandText,
        jsonText,
        edit,
        validate;

    }
}

