/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.ComboBox;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.ListArea;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.CmdField;
import com.edgytech.umongo.CollectionPanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DbNode;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocField;
import com.edgytech.umongo.DocumentDeserializer;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.OptionDialog;
import com.edgytech.umongo.UMongo;
import com.edgytech.umongo.UserDialog;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.bson.types.Code;

public class DbPanel
extends BasePanel
implements EnumListener<Item> {
    GridFS gridFS;

    public DbPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public GridFS getGridFS() {
        if (this.gridFS == null) {
            this.gridFS = new GridFS(this.getDbNode().getDb());
        }
        return this.gridFS;
    }

    public DbNode getDbNode() {
        return (DbNode)this.getNode();
    }

    @Override
    protected void updateComponentCustom(JPanel old) {
        try {
            DB db = this.getDbNode().getDb();
            this.setStringFieldValue(Item.name, db.getName());
            this.setStringFieldValue(Item.queryOptions, MongoUtils.queryOptionsToString(db.getOptions()));
            ((DocField)this.getBoundUnit(Item.writeConcern)).setDoc(db.getWriteConcern().getCommand());
            ((DocField)this.getBoundUnit(Item.readPreference)).setDoc(db.getReadPreference().toDBObject());
            ((CmdField)this.getBoundUnit(Item.stats)).updateFromCmd(db);
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void command(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        String scmd = this.getStringFieldValue(Item.commandStr);
        DBObject cmd = !scmd.isEmpty() ? new BasicDBObject(scmd, (Object)1) : ((DocBuilderField)this.getBoundUnit(Item.commandJson)).getDBObject();
        boolean help = this.getBooleanFieldValue(Item.commandHelp);
        if (help) {
            cmd.put("help", true);
        }
        new DbJobCmd(db, cmd, null, button).addJob();
    }

    public void listCommands(ButtonBase button) {
        new DbJobCmd(this.getDbNode().getDb(), "listCommands").addJob();
    }

    public void eval(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        String sfunc = this.getStringFieldValue(Item.evalCode);
        boolean noLock = this.getBooleanFieldValue(Item.evalNoLock);
        BasicDBObject cmd = new BasicDBObject("$eval", sfunc);
        if (noLock) {
            cmd.put("nolock", (Object)true);
        }
        new DbJobCmd(db, cmd, null, button).addJob();
    }

    public void uploadFile(final ButtonBase button) {
        final DbNode dbNode = this.getDbNode();
        final DB db = dbNode.getDb();
        final String path = this.getStringFieldValue(Item.uploadFilePath);
        if (path.isEmpty()) {
            return;
        }
        final File src = new File(path);
        final String fileName = this.getStringFieldValue(Item.uploadFileName);
        final String contentType = this.getStringFieldValue(Item.uploadContentType);
        final DBObject metadata = ((DocBuilderField)this.getBoundUnit(Item.uploadMetadata)).getDBObject();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                GridFSInputFile file = DbPanel.this.getGridFS().createFile(src);
                if (!fileName.isEmpty()) {
                    file.setFilename(fileName);
                }
                if (!contentType.isEmpty()) {
                    file.setContentType(contentType);
                }
                if (metadata != null) {
                    file.setMetaData(metadata);
                }
                file.save();
                return file;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Upload File";
            }

            @Override
            public DBObject getRoot(Object result) {
                return new BasicDBObject("path", path);
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                dbNode.structureComponent();
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void downloadFile(final ButtonBase button) {
        final DB db = this.getDbNode().getDb();
        final DBObject query = ((DocBuilderField)this.getBoundUnit(Item.downloadQuery)).getDBObject();
        final String fname = this.getStringFieldValue(Item.downloadFileName);
        final String dpath = this.getStringFieldValue(Item.downloadFilePath);
        if (dpath.isEmpty()) {
            return;
        }
        final File dfile = new File(dpath);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                GridFSDBFile dbfile = null;
                dbfile = query != null ? DbPanel.this.getGridFS().findOne(query) : DbPanel.this.getGridFS().findOne(fname);
                if (dbfile == null) {
                    throw new MongoException("GridFS cannot find file " + fname);
                }
                dbfile.writeTo(dfile);
                return dbfile;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Download File";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("filename", fname);
                obj.put("query", (Object)query);
                obj.put("path", (Object)dpath);
                return obj;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void listFiles(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        final DBCollection col = db.getCollection("fs.files");
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return col.find();
            }

            @Override
            public String getNS() {
                return col.getName();
            }

            @Override
            public String getShortName() {
                return "List Files";
            }
        }.addJob();
    }

    public void deleteFile(final ButtonBase button) {
        final DB db = this.getDbNode().getDb();
        final DBObject query = ((DocBuilderField)this.getBoundUnit(Item.downloadQuery)).getDBObject();
        final String fname = this.getStringFieldValue(Item.downloadFileName);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                if (query != null) {
                    DbPanel.this.getGridFS().remove(query);
                } else {
                    DbPanel.this.getGridFS().remove(fname);
                }
                return true;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Delete File";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("filename", fname);
                obj.put("query", (Object)query);
                return obj;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void dropDatabase(ButtonBase button) {
        DbNode node = this.getDbNode();
        final DB db = this.getDbNode().getDb();
        new DbJob(){

            @Override
            public Object doRun() {
                db.dropDatabase();
                return null;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Drop";
            }

            @Override
            public void wrapUp(Object res) {
                this.node.removeNode();
                this.node = null;
                super.wrapUp(res);
            }
        }.addJob();
    }

    public void readWriteOptions(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        OptionDialog od = UMongo.instance.getGlobalStore().getOptionDialog();
        od.update(db.getOptions(), db.getWriteConcern(), db.getReadPreference());
        if (!od.show()) {
            return;
        }
        db.setOptions(od.getQueryOptions());
        db.setWriteConcern(od.getWriteConcern());
        db.setReadPreference(od.getReadPreference());
        this.refresh();
    }

    public void authenticate(final ButtonBase button) {
        final DbNode dbNode = this.getDbNode();
        final DB db = dbNode.getDb();
        final String user = this.getStringFieldValue(Item.authUser);
        final String pass = this.getStringFieldValue(Item.authPassword);
        new DbJob(){

            @Override
            public Object doRun() {
                db.authenticateCommand(user, pass.toCharArray());
                return null;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Auth";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (dbNode.getDb().getName().equals("admin")) {
                    dbNode.getMongoNode().structureComponent();
                } else {
                    dbNode.structureComponent();
                }
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    void refreshUserList() {
        ListArea list = (ListArea)this.getBoundUnit(Item.userList);
        DB db = this.getDbNode().getDb();
        DBCursor cur = db.getCollection("system.users").find().sort(new BasicDBObject("user", (Object)1));
        ArrayList<String> users = new ArrayList<String>();
        while (cur.hasNext()) {
            BasicDBObject user = (BasicDBObject)cur.next();
            users.add(user.getString("user"));
        }
        list.items = users.toArray(new String[users.size()]);
        list.structureComponent();
    }

    public void manageUsers(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.manageUsers)).getDialog();
        this.refreshUserList();
        dialog.show();
    }

    public void addUser(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        final DBCollection col = db.getCollection("system.users");
        UserDialog ud = (UserDialog)this.getBoundUnit(Item.userDialog);
        ud.resetForNew();
        if (!ud.show()) {
            return;
        }
        final BasicDBObject newUser = ud.getUser(null);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return col.insert(newUser);
            }

            @Override
            public String getNS() {
                return "system.users";
            }

            @Override
            public String getShortName() {
                return "Add User";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                DbPanel.this.refreshUserList();
            }
        }.addJob();
    }

    public void removeUser(ButtonBase button) {
        final DB db = this.getDbNode().getDb();
        final String user = this.getComponentStringFieldValue(Item.userList);
        if (user == null) {
            return;
        }
        if (!((ConfirmDialog)this.getBoundUnit(Item.userChange)).show()) {
            return;
        }
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return db.removeUser(user);
            }

            @Override
            public String getNS() {
                return "system.users";
            }

            @Override
            public String getShortName() {
                return "Remove User";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                DbPanel.this.refreshUserList();
            }
        }.addJob();
    }

    public void editUser(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        final DBCollection col = db.getCollection("system.users");
        String user = this.getComponentStringFieldValue(Item.userList);
        if (user == null) {
            return;
        }
        BasicDBObject userObj = (BasicDBObject)col.findOne(new BasicDBObject("user", user));
        UserDialog ud = (UserDialog)this.getBoundUnit(Item.userDialog);
        ud.resetForEdit(userObj);
        if (!ud.show()) {
            return;
        }
        final BasicDBObject newUser = ud.getUser(userObj);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return col.save(newUser);
            }

            @Override
            public String getNS() {
                return col.getName();
            }

            @Override
            public String getShortName() {
                return "Edit User";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                DbPanel.this.refreshUserList();
            }
        }.addJob();
    }

    public void createCollection(final ButtonBase button) {
        DbNode node = this.getDbNode();
        final DB db = this.getDbNode().getDb();
        final String name = this.getStringFieldValue(Item.createCollName);
        final boolean capped = this.getBooleanFieldValue(Item.createCollCapped);
        final int size = this.getIntFieldValue(Item.createCollSize);
        final int count = this.getIntFieldValue(Item.createCollCount);
        final boolean autoIndexId = this.getBooleanFieldValue(Item.createCollAutoIndex);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                BasicDBObject opt = new BasicDBObject("capped", capped);
                if (capped) {
                    if (size > 0) {
                        opt.put("size", (Object)size);
                    }
                    if (count > 0) {
                        opt.put("max", (Object)count);
                    }
                }
                if (!autoIndexId) {
                    opt.put("autoIndexId", (Object)false);
                }
                db.createCollection(name, opt);
                return null;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Create Collection";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                this.node.structureComponent();
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void getStats(ButtonBase button) {
        new DbJobCmd(this.getDbNode().getDb(), "dbstats").addJob();
    }

    public void dbHash(ButtonBase button) {
        new DbJobCmd(this.getDbNode().getDb(), "dbHash").addJob();
    }

    public void enableSharding(ButtonBase button) {
        MongoClient m = this.getDbNode().getMongoNode().getMongoClient();
        DB admin = m.getDB("admin");
        BasicDBObject cmd = new BasicDBObject("enableSharding", this.getDbNode().getDb().getName());
        new DbJobCmd(admin, cmd, this, null).addJob();
    }

    public void profile(ButtonBase button) {
        int slow;
        DB db = this.getDbNode().getDb();
        int level = this.getIntFieldValue(Item.profileLevel);
        BasicDBObject cmd = new BasicDBObject("profile", (Object)level);
        if (level == 1 && (slow = this.getIntFieldValue(Item.profileSlowMS)) > 0) {
            cmd.put("slowms", (Object)slow);
        }
        new DbJobCmd(db, cmd).addJob();
    }

    public void analyzeProfilingData(ButtonBase button) {
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                DBCollection prof = DbPanel.this.getDbNode().getDb().getCollection("system.profile");
                BasicDBObject out = new BasicDBObject();
                CommandResult res = null;
                DocumentDeserializer dd = null;
                BasicDBObject aggCmd = null;
                dd = new DocumentDeserializer(DocumentDeserializer.Format.JSON_SINGLE_DOC, null);
                dd.setInputStream(DbPanel.class.getResourceAsStream("/json/profOperationType.json"));
                aggCmd = (BasicDBObject)dd.readObject();
                res = DbPanel.this.getDbNode().getDb().command(aggCmd);
                out.put("byOperationType", res.get("result"));
                dd.close();
                dd = new DocumentDeserializer(DocumentDeserializer.Format.JSON_SINGLE_DOC, null);
                dd.setInputStream(DbPanel.class.getResourceAsStream("/json/profNamespace.json"));
                aggCmd = (BasicDBObject)dd.readObject();
                res = DbPanel.this.getDbNode().getDb().command(aggCmd);
                out.put("byNamespace", res.get("result"));
                dd.close();
                dd = new DocumentDeserializer(DocumentDeserializer.Format.JSON_SINGLE_DOC, null);
                dd.setInputStream(DbPanel.class.getResourceAsStream("/json/profClient.json"));
                aggCmd = (BasicDBObject)dd.readObject();
                res = DbPanel.this.getDbNode().getDb().command(aggCmd);
                out.put("byClient", res.get("result"));
                dd.close();
                dd = new DocumentDeserializer(DocumentDeserializer.Format.JSON_SINGLE_DOC, null);
                dd.setInputStream(DbPanel.class.getResourceAsStream("/json/profMoved.json"));
                aggCmd = (BasicDBObject)dd.readObject();
                res = DbPanel.this.getDbNode().getDb().command(aggCmd);
                out.put("movedVsNonMoved", res.get("result"));
                dd.close();
                dd = new DocumentDeserializer(DocumentDeserializer.Format.JSON_SINGLE_DOC, null);
                dd.setInputStream(DbPanel.class.getResourceAsStream("/json/profResponseTimeAnalysis.json"));
                aggCmd = (BasicDBObject)dd.readObject();
                res = DbPanel.this.getDbNode().getDb().command(aggCmd);
                out.put("responseTimeAnalysis", res.get("result"));
                dd.close();
                return out;
            }

            @Override
            public String getNS() {
                return DbPanel.this.getDbNode().getDb().getName();
            }

            @Override
            public String getShortName() {
                return "Analyze Profiling Data";
            }
        }.addJob();
    }

    public void repair(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        BasicDBObject cmd = new BasicDBObject("repairDatabase", (Object)1);
        if (!UMongo.instance.getGlobalStore().confirmLockingOperation()) {
            return;
        }
        new DbJobCmd(db, cmd).addJob();
    }

    public void shardingInfo(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        DB config = db.getSisterDB("config");
        DBCollection col = config.getCollection("databases");
        CollectionPanel.doFind(col, new BasicDBObject("_id", db.getName()));
    }

    public void movePrimary(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.movePrimary)).getDialog();
        ComboBox combo = (ComboBox)this.getBoundUnit(Item.mvpToShard);
        combo.value = 0;
        combo.items = this.getDbNode().getMongoNode().getShardNames();
        combo.structureComponent();
        if (!dialog.show()) {
            return;
        }
        MongoClient m = this.getDbNode().getMongoNode().getMongoClient();
        DB admin = m.getDB("admin");
        String shard = this.getStringFieldValue(Item.mvpToShard);
        BasicDBObject cmd = new BasicDBObject("movePrimary", this.getDbNode().getDb().getName());
        cmd.put("to", (Object)shard);
        new DbJobCmd(admin, cmd, this, null).addJob();
    }

    public void findJSFunction(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        DBCollection col = db.getCollection("system.js");
        String name = this.getStringFieldValue(Item.findJSFunctionName);
        BasicDBObject query = new BasicDBObject();
        if (name != null && !name.isEmpty()) {
            query.put("_id", (Object)name);
        }
        CollectionPanel.doFind(col, query);
    }

    public void addJSFunction(ButtonBase button) {
        DB db = this.getDbNode().getDb();
        final DBCollection col = db.getCollection("system.js");
        final String name = this.getStringFieldValue(Item.addJSFunctionName);
        final String code = this.getStringFieldValue(Item.addJSFunctionCode);
        CollectionPanel.doFind(col, new BasicDBObject("_id", name));
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                BasicDBObject obj = new BasicDBObject("_id", name);
                obj.put("value", (Object)new Code(code));
                return col.insert(obj);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Add JS Function";
            }

            @Override
            public ButtonBase getButton() {
                return null;
            }
        }.addJob();
    }

    public void summarizeData(ButtonBase button) {
        final DbNode dbnode = this.getDbNode();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return dbnode.summarizeData();
            }

            @Override
            public String getNS() {
                return dbnode.getDb().getName();
            }

            @Override
            public String getShortName() {
                return "Summarize Data";
            }
        }.addJob();
    }

    static enum Item {
        icon,
        name,
        queryOptions,
        writeConcern,
        readPreference,
        stats,
        getStats,
        refresh,
        dropDatabase,
        uploadFile,
        uploadFileDialog,
        uploadFilePath,
        uploadFileName,
        uploadContentType,
        uploadMetadata,
        downloadFile,
        downloadQuery,
        downloadFileName,
        downloadFilePath,
        listFiles,
        deleteFile,
        deleteQuery,
        deleteFileName,
        commandCmd,
        commandStr,
        commandJson,
        commandHelp,
        listCommands,
        eval,
        evalCode,
        evalNoLock,
        dbHash,
        readWriteOptions,
        authenticate,
        authUser,
        authPassword,
        manageUsers,
        userDialog,
        userList,
        addUser,
        removeUser,
        editUser,
        userChange,
        createCollection,
        createCollName,
        createCollCapped,
        createCollSize,
        createCollCount,
        createCollAutoIndex,
        enableSharding,
        movePrimary,
        mvpToShard,
        shardingInfo,
        profile,
        profileLevel,
        profileSlowMS,
        analyzeProfilingData,
        repair,
        addJSFunction,
        addJSFunctionName,
        addJSFunctionCode,
        findJSFunction,
        findJSFunctionName,
        summarizeData;

    }
}

