/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.CollectionNode;
import com.edgytech.umongo.MongoNode;
import com.edgytech.umongo.Resource;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;

public class DbNode
extends BaseTreeNode {
    DB db;
    BasicDBObject stats;

    public DbNode(DB db) {
        this.db = db;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.dbNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public DB getDb() {
        return this.db;
    }

    public MongoNode getMongoNode() {
        return (MongoNode)((DefaultMutableTreeNode)this.getTreeNode().getParent()).getUserObject();
    }

    @Override
    protected void populateChildren() {
        for (String colname : this.db.getCollectionNames()) {
            DBCollection col = this.db.getCollection(colname);
            try {
                this.addChild(new CollectionNode(col));
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected void updateNode() {
        this.label = this.db.getName();
        if (this.stats != null) {
            this.label = this.label + " (" + this.stats.getInt("objects") + "/" + this.stats.getInt("dataSize") + ")";
        }
    }

    @Override
    protected void refreshNode() {
        CommandResult res = this.db.command((DBObject)new BasicDBObject("dbstats", (Object)1), this.db.getMongo().getOptions());
        res.throwOnError();
        this.stats = res;
    }

    List<DBObject> summarizeData() {
        ArrayList<DBObject> global = new ArrayList<DBObject>();
        for (CollectionNode node : this.getChildrenOfClass(CollectionNode.class)) {
            DBObject res = node.summarizeData();
            global.add(res);
        }
        return global;
    }
}

