/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.DbJob;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;

public class DbJobCmd
extends DbJob {
    DB db;
    DBObject cmd;
    BasePanel panel;
    ButtonBase button;

    public DbJobCmd(DB db, DBObject cmd, BasePanel panel, ButtonBase button) {
        this.id = null;
        this.label = cmd.keySet().iterator().next();
        this.db = db;
        this.cmd = cmd;
        this.panel = panel;
        this.button = button;
    }

    public DbJobCmd(DB db, DBObject cmd) {
        this(db, cmd, null, null);
    }

    public DbJobCmd(DB db, String cmdStr) {
        this(db, new BasicDBObject(cmdStr, (Object)1), null, null);
    }

    public DbJobCmd(DBCollection col, String cmdStr) {
        this(col.getDB(), new BasicDBObject(cmdStr, col.getName()), null, null);
    }

    @Override
    public Object doRun() {
        CommandResult res = this.db.command(this.cmd);
        res.throwOnError();
        return res;
    }

    @Override
    public String getNS() {
        String ns = this.db.getName();
        Object value = this.cmd.get(this.cmd.keySet().iterator().next());
        if (value instanceof String) {
            ns = ns + "." + value;
        }
        return ns;
    }

    @Override
    public String getShortName() {
        return this.cmd.keySet().iterator().next();
    }

    @Override
    public DBObject getRoot(Object result) {
        return this.cmd;
    }

    @Override
    public ButtonBase getButton() {
        return this.button;
    }

    @Override
    DB getDB() {
        return this.db;
    }

    @Override
    DBObject getCommand() {
        return this.cmd;
    }

    @Override
    BasePanel getPanel() {
        return this.panel;
    }

    @Override
    public void wrapUp(Object res) {
        super.wrapUp(res);
        if (this.panel != null) {
            this.panel.refresh();
        }
    }
}

