/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.Div;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.ProgressBar;
import com.edgytech.swingfast.ProgressBarWorker;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.DocView;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.TextView;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import org.bson.types.ObjectId;

public abstract class DbJob
extends Div
implements EnumListener<Item> {
    long startTime;
    long endTime;
    boolean stopped = false;
    ProgressBar _progress;
    ProgressBarWorker _pbw;
    BaseTreeNode node;

    public DbJob() {
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.dbJob, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.setEnumBinding(Item.values(), this);
    }

    public void start() {
        this.start(false);
    }

    @Override
    public void start(boolean determinate) {
        this.setComponentStringFieldValue(Item.jobName, this.getTitle());
        ButtonBase button = this.getButton();
        if (button != null) {
            this.xmlSaveLocalCopy(button, null, null);
        }
        this._progress = (ProgressBar)this.getBoundUnit(Item.progressBar);
        this._progress.determinate = this.isDeterminate();
        this._pbw = new ProgressBarWorker(this._progress){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doInBackground() throws Exception {
                DbJob.this.startTime = System.currentTimeMillis();
                try {
                    Object res;
                    Object object = res = DbJob.this.doRun();
                    return object;
                }
                catch (Exception e) {
                    DbJob.this.getLogger().log(Level.WARNING, null, e);
                    Exception exception = e;
                    return exception;
                }
                finally {
                    DbJob.this.endTime = System.currentTimeMillis();
                }
            }

            @Override
            protected void done() {
                Object res = null;
                try {
                    res = this.get();
                }
                catch (Exception ex) {
                    UMongo.instance.showError(DbJob.this.getTitle(), res);
                }
                try {
                    DbJob.this.wrapUp(res);
                }
                catch (Exception ex) {
                    UMongo.instance.showError(DbJob.this.getTitle(), ex);
                }
            }
        };
        this._pbw.start();
    }

    public abstract Object doRun() throws Exception;

    public abstract String getNS();

    public abstract String getShortName();

    public DBObject getRoot(Object result) {
        return null;
    }

    public ButtonBase getButton() {
        return null;
    }

    public boolean isCancelled() {
        if (this._pbw != null) {
            return this._pbw.isCancelled();
        }
        return false;
    }

    public void cancel() {
        if (this._pbw != null) {
            this._pbw.cancel(true);
        }
    }

    public void setProgress(int progress) {
        if (this._pbw != null) {
            this._pbw.updateProgress(progress);
        }
    }

    public BasicDBObject getDescription(DBObject root) {
        BasicDBObject sroot = new BasicDBObject();
        sroot.put("ns", (Object)this.getNS());
        sroot.put("name", (Object)this.getShortName());
        sroot.put("details", (Object)root);
        return sroot;
    }

    public void wrapUp(Object res) {
        UMongo.instance.removeJob(this);
        if (this.node != null) {
            UMongo.instance.addNodeToRefresh(this.node);
        }
        if (res == null) {
            return;
        }
        String title = this.getTitle();
        boolean log = UMongo.instance.isLoggingOn();
        boolean logRes = UMongo.instance.isLoggingFirstResultOn();
        BasicDBObject sroot = this.getDescription(this.getRoot(res));
        BasicDBObject logObj = null;
        if (log) {
            logObj = new BasicDBObject("_id", new ObjectId());
            logObj.put("ns", (Object)this.getNS());
            logObj.put("name", (Object)this.getShortName());
            logObj.put("details", (Object)this.getRoot(res));
        }
        if (res instanceof Iterator) {
            new DocView(null, title, this, (Object)sroot, (Iterator)res).addToTabbedDiv();
            if (logRes && res instanceof DBCursor) {
                logObj.put("firstResult", (Object)((DBCursor)res).curr());
            }
        } else if (res instanceof List) {
            List list = (List)res;
            new DocView(null, title, this, (Object)sroot, list.iterator()).addToTabbedDiv();
            if (logRes && list.size() > 0) {
                logObj.put("firstResult", list.get(0));
            }
        } else if (res instanceof DBObject) {
            new DocView(null, title, this, (Object)sroot, (DBObject)res).addToTabbedDiv();
            if (logRes) {
                logObj.put("firstResult", res);
            }
        } else if (res instanceof String) {
            new TextView(null, title, this, (String)res).addToTabbedDiv();
            if (logRes) {
                logObj.put("firstResult", (Object)MongoUtils.limitString((String)res, 0));
            }
        } else if (res instanceof WriteResult) {
            WriteResult wres = (WriteResult)res;
            CommandResult lasterr = wres.getCachedLastError();
            if (lasterr != null) {
                new DocView(null, title, this, (Object)sroot, lasterr).addToTabbedDiv();
            }
            if (logRes) {
                logObj.put("firstResult", (Object)lasterr);
            }
        } else if (res instanceof Exception) {
            UMongo.instance.showError(title, (Exception)res);
            if (logRes) {
                logObj.put("firstResult", (Object)res.toString());
            }
        } else {
            BasicDBObject obj = new BasicDBObject("result", res.toString());
            new DocView(null, title, this, (Object)sroot, obj).addToTabbedDiv();
            if (logRes) {
                logObj.put("firstResult", (Object)res.toString());
            }
        }
        if (log) {
            UMongo.instance.logActivity(logObj);
        }
        this._progress = null;
        this._pbw = null;
    }

    public String getTitle() {
        String title = "";
        if (this.getNS() != null) {
            title = title + this.getNS() + " / ";
        }
        if (this.getShortName() != null) {
            title = title + this.getShortName();
        }
        return title;
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
        if (enm == Item.close) {
            // empty if block
        }
    }

    public boolean isDeterminate() {
        return false;
    }

    public void addJob() {
        this.node = UMongo.instance.getNode();
        UMongo.instance.runJob(this);
    }

    long getRunTime() {
        return this.endTime - this.startTime;
    }

    void spawnDialog() {
        if (this.node == null) {
            return;
        }
        UMongo.instance.getTree().selectNode(this.node);
        ButtonBase button = this.getButton();
        if (button == null) {
            return;
        }
        this.xmlLoadLocalCopy(button, null, null);
        Component comp = button.getComponent();
        if (comp != null) {
            ((AbstractButton)comp).doClick();
        }
    }

    DB getDB() {
        return null;
    }

    DBObject getCommand() {
        return null;
    }

    BasePanel getPanel() {
        return null;
    }

    void join() throws InterruptedException, ExecutionException {
        if (this._pbw != null) {
            this._pbw.get();
        }
    }

    static enum Item {
        jobName,
        progressBar,
        close;

    }
}

