/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.FormDialog;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectDialog
extends FormDialog {
    public ConnectDialog() {
        this.setEnumBinding(Item.values(), null);
    }

    MongoClientOptions getMongoClientOptions() {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.connectTimeout(this.getIntFieldValue(Item.connectTimeout));
        builder.socketTimeout(this.getIntFieldValue(Item.socketTimeout));
        if (!this.getBooleanFieldValue(Item.safeWrites)) {
            builder.writeConcern(WriteConcern.NONE);
        }
        if (this.getBooleanFieldValue(Item.secondaryReads)) {
            builder.readPreference(ReadPreference.secondaryPreferred());
        }
        int stype = this.getIntFieldValue(Item.socketType);
        int proxy = this.getIntFieldValue(Item.proxyType);
        if (proxy == 1) {
            final String host = this.getStringFieldValue(Item.proxyHost);
            final int port = this.getIntFieldValue(Item.proxyPort);
            builder.socketFactory(new SocketFactory(){

                @Override
                public Socket createSocket() throws IOException {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
                    Socket socket = new Socket(proxy);
                    return socket;
                }

                @Override
                public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
                    Socket socket = new Socket(proxy);
                    InetSocketAddress dest = new InetSocketAddress(string, i);
                    socket.connect(dest);
                    return socket;
                }

                @Override
                public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public Socket createSocket(InetAddress ia, int i) throws IOException {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
                    Socket socket = new Socket(proxy);
                    InetSocketAddress dest = new InetSocketAddress(ia, i);
                    socket.connect(dest);
                    return socket;
                }

                @Override
                public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
        }
        if (stype == 1) {
            builder.socketFactory(SSLSocketFactory.getDefault());
        } else if (stype == 2) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                builder.socketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return builder.build();
    }

    void setName(String name) {
        this.setStringFieldValue(Item.name, name);
    }

    String getName() {
        return this.getStringFieldValue(Item.name);
    }

    static enum Item {
        name,
        uri,
        servers,
        connectionMode,
        databases,
        user,
        password,
        connectionsPerHost,
        blockingThreadMultiplier,
        maxWaitTime,
        socketType,
        connectTimeout,
        socketTimeout,
        safeWrites,
        secondaryReads,
        proxyType,
        proxyHost,
        proxyPort,
        proxyUser,
        proxyPassword;

    }
}

