/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.ComboBox;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.ListArea;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.AggregateDialog;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.CmdField;
import com.edgytech.umongo.CollectionNode;
import com.edgytech.umongo.CreateIndexDialog;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocField;
import com.edgytech.umongo.DocumentDeserializer;
import com.edgytech.umongo.DocumentSerializer;
import com.edgytech.umongo.ExportDialog;
import com.edgytech.umongo.ImportDialog;
import com.edgytech.umongo.MongoNode;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.OptionDialog;
import com.edgytech.umongo.TagRangeDialog;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.LazyDBDecoder;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JPanel;

public class CollectionPanel
extends BasePanel
implements EnumListener<Item> {
    public CollectionPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public CollectionNode getCollectionNode() {
        return (CollectionNode)this.getNode();
    }

    public BasicDBObject getStats() {
        return this.getCollectionNode().getStats();
    }

    @Override
    protected void updateComponentCustom(JPanel old) {
        try {
            DBCollection collection = this.getCollectionNode().getCollection();
            this.setStringFieldValue(Item.name, collection.getName());
            this.setStringFieldValue(Item.fullName, collection.getFullName());
            this.setStringFieldValue(Item.queryOptions, MongoUtils.queryOptionsToString(collection.getOptions()));
            ((DocField)this.getBoundUnit(Item.writeConcern)).setDoc(collection.getWriteConcern().getCommand());
            ((DocField)this.getBoundUnit(Item.readPreference)).setDoc(collection.getReadPreference().toDBObject());
            ((CmdField)this.getBoundUnit(Item.stats)).updateFromCmd(collection);
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
        if (enm == Item.lazyDecoding) {
            boolean lazy = this.getBooleanFieldValue(Item.lazyDecoding);
            DBCollection col = this.getCollectionNode().getCollection();
            if (lazy) {
                col.setDBDecoderFactory(LazyDBDecoder.FACTORY);
            } else {
                col.setDBDecoderFactory(null);
            }
        }
    }

    public void find(final ButtonBase button) {
        final DBCollection col = this.getCollectionNode().getCollection();
        final DBObject query = ((DocBuilderField)this.getBoundUnit(Item.findQuery)).getDBObject();
        final DBObject fields = ((DocBuilderField)this.getBoundUnit(Item.findFields)).getDBObject();
        final DBObject sort = ((DocBuilderField)this.getBoundUnit(Item.findSort)).getDBObject();
        final DBObject hint = ((DocBuilderField)this.getBoundUnit(Item.findHint)).getDBObject();
        final int skip = this.getIntFieldValue(Item.findSkip);
        final int limit = this.getIntFieldValue(Item.findLimit);
        final int batchSize = this.getIntFieldValue(Item.findBatchSize);
        final boolean explain = this.getBooleanFieldValue(Item.findExplain);
        boolean export = this.getBooleanFieldValue(Item.findExport);
        if (export) {
            this.exportToFile(col, query, fields, sort, skip, limit, batchSize);
        } else {
            new DbJob(){

                @Override
                public Object doRun() {
                    DBCursor cur = col.find(query, fields, skip, batchSize);
                    if (sort != null) {
                        cur.sort(sort);
                    }
                    if (limit > 0) {
                        cur.limit(limit);
                    }
                    if (hint != null) {
                        cur.hint(hint);
                    }
                    if (explain) {
                        return cur.explain();
                    }
                    cur.hasNext();
                    return cur;
                }

                @Override
                public String getNS() {
                    return col.getFullName();
                }

                @Override
                public String getShortName() {
                    return "Find";
                }

                @Override
                public DBObject getRoot(Object result) {
                    if (result == null || !(result instanceof DBCursor)) {
                        return null;
                    }
                    DBCursor res = (DBCursor)result;
                    BasicDBObject obj = new BasicDBObject("cursorId", (Object)res.getCursorId());
                    obj.put("server", (Object)res.getServerAddress().toString());
                    obj.put("query", (Object)res.getQuery());
                    obj.put("fields", (Object)res.getKeysWanted());
                    obj.put("options", (Object)res.getOptions());
                    obj.put("readPreference", (Object)res.getReadPreference().toDBObject());
                    obj.put("numSeen", (Object)res.numSeen());
                    obj.put("numGetMores", (Object)res.numGetMores());
                    return obj;
                }

                @Override
                public ButtonBase getButton() {
                    return button;
                }
            }.addJob();
        }
    }

    public void rename(ButtonBase button) {
        CollectionNode colNode = this.getCollectionNode();
        DBCollection col = colNode.getCollection();
        UMongo.instance.displayNode(colNode.getDbNode());
        String name = this.getStringFieldValue(Item.newName);
        boolean dropTarget = this.getBooleanFieldValue(Item.dropTarget);
        DBObject cmd = BasicDBObjectBuilder.start().add("renameCollection", col.getFullName()).add("to", col.getDB().getName() + "." + name).add("dropTarget", dropTarget).get();
        new DbJobCmd(col.getDB().getSisterDB("admin"), cmd, null, null).addJob();
    }

    public void group(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection();
        DBObject keys = ((DocBuilderField)this.getBoundUnit(Item.grpKeys)).getDBObject();
        DBObject initial = ((DocBuilderField)this.getBoundUnit(Item.grpInitialValue)).getDBObject();
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.grpQuery)).getDBObject();
        String reduce = this.getStringFieldValue(Item.grpReduce);
        String finalize = this.getStringFieldValue(Item.grpFinalize);
        GroupCommand cmd = new GroupCommand(col, keys, query, initial, reduce, finalize);
        new DbJobCmd(col.getDB(), cmd.toDBObject(), null, button).addJob();
    }

    public void distinct(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection();
        BasicDBObject cmd = new BasicDBObject("distinct", col.getName());
        cmd.put("key", (Object)this.getStringFieldValue(Item.distinctKey));
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.distinctQuery)).getDBObject();
        if (query != null) {
            cmd.put("query", (Object)query);
        }
        new DbJobCmd(col.getDB(), cmd, null, button).addJob();
    }

    public void mapReduce(final ButtonBase button) {
        final DBCollection col = this.getCollectionNode().getCollection();
        String map = this.getStringFieldValue(Item.mrMap);
        String reduce = this.getStringFieldValue(Item.mrReduce);
        String finalize = this.getStringFieldValue(Item.mrFinalize);
        String stype = this.getStringFieldValue(Item.mrType);
        final MapReduceCommand.OutputType type = MapReduceCommand.OutputType.valueOf(stype.toUpperCase());
        String out = this.getStringFieldValue(Item.mrOut);
        if (type != MapReduceCommand.OutputType.INLINE && out.isEmpty()) {
            new InfoDialog(this.id, null, null, "Output collection cannot be empty if type is not inline.").show();
            return;
        }
        String outDB = this.getStringFieldValue(Item.mrOutDB);
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.mrQuery)).getDBObject();
        int limit = this.getIntFieldValue(Item.mrLimit);
        final MapReduceCommand cmd = new MapReduceCommand(col, map, reduce, out, type, query);
        DBObject sort = ((DocBuilderField)this.getBoundUnit(Item.mrSort)).getDBObject();
        if (sort != null) {
            cmd.setSort(sort);
        }
        if (!outDB.isEmpty()) {
            cmd.setOutputDB(outDB);
        }
        if (!finalize.isEmpty()) {
            cmd.setFinalize(finalize);
        }
        if (limit > 0) {
            cmd.setLimit(limit);
        }
        if (this.getBooleanFieldValue(Item.mrJSMode)) {
            cmd.addExtraOption("jsMode", true);
        }
        final BasicDBObject cmdobj = (BasicDBObject)cmd.toDBObject();
        if (this.getBooleanFieldValue(Item.mrOutSharded)) {
            ((BasicDBObject)cmdobj.get("out")).put("sharded", (Object)true);
        }
        if (this.getBooleanFieldValue(Item.mrNonAtomic)) {
            ((BasicDBObject)cmdobj.get("out")).put("nonAtomic", (Object)true);
        }
        new DbJob(){
            MapReduceOutput output;

            @Override
            public Object doRun() {
                CommandResult res = null;
                if (type == MapReduceCommand.OutputType.INLINE) {
                    res = col.getDB().command((DBObject)cmdobj, col.getOptions());
                    return res;
                }
                res = col.getDB().command(cmdobj);
                res.throwOnError();
                this.output = new MapReduceOutput(col, cmdobj, res);
                return this.output;
            }

            @Override
            public void wrapUp(Object res) {
                if (this.output != null) {
                    if (cmd.getOutputType() == MapReduceCommand.OutputType.INLINE) {
                        res = this.output.results();
                    } else {
                        CollectionPanel.doFind(this.output.getOutputCollection(), null);
                        res = this.output.getRaw();
                    }
                }
                super.wrapUp(res);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "MR";
            }

            @Override
            public DBObject getRoot(Object result) {
                return cmdobj;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }

            @Override
            DBObject getCommand() {
                return cmdobj;
            }

            @Override
            DB getDB() {
                return col.getDB();
            }
        }.addJob();
    }

    static void doFind(DBCollection col, DBObject query) {
        CollectionPanel.doFind(col, query, null, null, 0, 0, 0, false, null, 0);
    }

    static void doFind(final DBCollection col, final DBObject query, final DBObject fields, final DBObject sort, final int skip, final int limit, final int batchSize, final boolean explain, final DBObject hint, final int options) {
        new DbJob(){

            @Override
            public Object doRun() {
                DBCursor cur = col.find(query, fields).skip(skip).batchSize(batchSize).addOption(options);
                if (sort != null) {
                    cur.sort(sort);
                }
                if (limit > 0) {
                    cur.limit(limit);
                }
                if (hint != null) {
                    cur.hint(hint);
                }
                if (explain) {
                    return cur.explain();
                }
                cur.hasNext();
                return cur;
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Find";
            }

            @Override
            public DBObject getRoot(Object result) {
                if (result == null || !(result instanceof DBCursor)) {
                    return null;
                }
                DBCursor res = (DBCursor)result;
                BasicDBObject obj = new BasicDBObject("cursorId", (Object)res.getCursorId());
                obj.put("query", (Object)res.getQuery());
                obj.put("fields", (Object)res.getKeysWanted());
                obj.put("options", (Object)res.getOptions());
                obj.put("readPreference", (Object)res.getReadPreference().toDBObject());
                obj.put("numSeen", (Object)res.numSeen());
                obj.put("numGetMores", (Object)res.numGetMores());
                return obj;
            }
        }.addJob();
    }

    private void exportToFile(final DBCollection col, final DBObject query, final DBObject fields, final DBObject sort, final int skip, final int limit, final int batchSize) {
        ExportDialog dia = UMongo.instance.getGlobalStore().getExportDialog();
        if (!dia.show()) {
            return;
        }
        final DocumentSerializer ds = dia.getDocumentSerializer();
        final boolean continueOnError = dia.getBooleanFieldValue(ExportDialog.Item.continueOnError);
        new DbJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doRun() throws Exception {
                block11: {
                    try {
                        try {
                            DBCursor cur = col.find(query, fields);
                            if (skip > 0) {
                                cur.skip(skip);
                            }
                            if (batchSize != 0) {
                                cur.batchSize(batchSize);
                            }
                            if (sort != null) {
                                cur.sort(sort);
                            }
                            if (limit > 0) {
                                cur.limit(limit);
                            }
                            while (cur.hasNext() && !this.stopped) {
                                ds.writeObject(cur.next());
                            }
                        }
                        catch (Exception e) {
                            if (continueOnError) {
                                this.getLogger().log(Level.WARNING, null, e);
                                break block11;
                            }
                            throw e;
                        }
                    }
                    finally {
                        ds.close();
                    }
                }
                return null;
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Export";
            }
        }.addJob();
    }

    public void dropCollection(ButtonBase button) {
        final CollectionNode colNode = this.getCollectionNode();
        final DBCollection col = this.getCollectionNode().getCollection();
        new DbJob(){

            @Override
            public Object doRun() {
                col.drop();
                return null;
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Drop";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                colNode.removeNode();
            }
        }.addJob();
    }

    public void readWriteOptions(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection();
        OptionDialog od = UMongo.instance.getGlobalStore().getOptionDialog();
        od.update(col.getOptions(), col.getWriteConcern(), col.getReadPreference());
        if (!od.show()) {
            return;
        }
        col.setOptions(od.getQueryOptions());
        col.setWriteConcern(od.getWriteConcern());
        col.setReadPreference(od.getReadPreference());
        this.refresh();
    }

    public void insert(final ButtonBase button) {
        final DBCollection col = this.getCollectionNode().getCollection();
        final BasicDBObject doc = (BasicDBObject)((DocBuilderField)this.getBoundUnit(Item.insertDoc)).getDBObject();
        final int count = this.getIntFieldValue(Item.insertCount);
        final boolean bulk = this.getBooleanFieldValue(Item.insertBulk);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                WriteResult res = null;
                ArrayList<DBObject> list = new ArrayList<DBObject>();
                for (int i = 0; i < count; ++i) {
                    BasicDBObject newdoc = (BasicDBObject)doc.copy();
                    CollectionPanel.this.handleSpecialFields(newdoc);
                    if (bulk) {
                        list.add(newdoc);
                        if (list.size() < 1000) continue;
                        res = col.insert(list);
                        list.clear();
                        continue;
                    }
                    res = col.insert(newdoc);
                }
                if (bulk && !list.isEmpty()) {
                    return col.insert(list);
                }
                return res;
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Insert";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject root = new BasicDBObject("doc", doc);
                root.put("count", (Object)count);
                root.put("bulk", (Object)bulk);
                return root;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void save(final ButtonBase button) {
        final DBCollection col = this.getCollectionNode().getCollection();
        final BasicDBObject doc = (BasicDBObject)((DocBuilderField)this.getBoundUnit(Item.saveDoc)).getDBObject();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return col.save((DBObject)doc.copy());
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Save";
            }

            @Override
            public DBObject getRoot(Object result) {
                return doc;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void remove(final ButtonBase button) {
        ConfirmDialog confirm;
        BasicDBObject doc;
        final DBCollection col = this.getCollectionNode().getCollection();
        BasicDBObject tmp = (BasicDBObject)((DocBuilderField)this.getBoundUnit(Item.removeQuery)).getDBObject();
        BasicDBObject basicDBObject = doc = tmp != null ? tmp : new BasicDBObject();
        if (doc.isEmpty() && !(confirm = (ConfirmDialog)this.getBoundUnit(Item.rmAllConfirm)).show()) {
            return;
        }
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return col.remove(doc);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Remove";
            }

            @Override
            public DBObject getRoot(Object result) {
                return new BasicDBObject("query", doc);
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void createIndex(final ButtonBase button) {
        CollectionNode node = this.getCollectionNode();
        final DBCollection col = this.getCollectionNode().getCollection();
        CreateIndexDialog dia = (CreateIndexDialog)button.getDialog();
        final DBObject keys = dia.getKeys();
        final DBObject opts = dia.getOptions();
        if (!UMongo.instance.getGlobalStore().confirmLockingOperation()) {
            return;
        }
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                col.createIndex(keys, opts);
                return new BasicDBObject("ok", (Object)1);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Ensure Index";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                this.node.structureComponent();
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("keys", keys);
                obj.put("options", (Object)opts);
                return obj;
            }
        }.addJob();
    }

    public void count(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection();
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.countQuery)).getDBObject();
        int skip = this.getIntFieldValue(Item.countSkip);
        int limit = this.getIntFieldValue(Item.countLimit);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("count", (Object)col.getName());
        cmd.put("query", (Object)query);
        if (limit > 0) {
            cmd.put("limit", (Object)limit);
        }
        if (skip > 0) {
            cmd.put("skip", (Object)skip);
        }
        new DbJobCmd(col.getDB(), cmd, null, button).addJob();
    }

    public void findAndModify(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection();
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.famQuery)).getDBObject();
        DBObject fields = ((DocBuilderField)this.getBoundUnit(Item.famFields)).getDBObject();
        DBObject sort = ((DocBuilderField)this.getBoundUnit(Item.famSort)).getDBObject();
        BasicDBObject update = (BasicDBObject)((DocBuilderField)this.getBoundUnit(Item.famUpdate)).getDBObject();
        boolean remove = this.getBooleanFieldValue(Item.famRemove);
        boolean returnNew = this.getBooleanFieldValue(Item.famReturnNew);
        boolean upsert = this.getBooleanFieldValue(Item.famUpsert);
        BasicDBObject cmd = new BasicDBObject("findandmodify", col.getName());
        if (query != null && !query.keySet().isEmpty()) {
            cmd.append("query", query);
        }
        if (fields != null && !fields.keySet().isEmpty()) {
            cmd.append("fields", fields);
        }
        if (sort != null && !sort.keySet().isEmpty()) {
            cmd.append("sort", sort);
        }
        if (remove) {
            cmd.append("remove", remove);
        } else {
            if (update != null && !update.keySet().isEmpty()) {
                String key = (String)update.keySet().iterator().next();
                if (key.charAt(0) != '$') {
                    MongoUtils.checkObject(update, false, false);
                }
                cmd.append("update", (DBObject)update.copy());
            }
            if (returnNew) {
                cmd.append("new", returnNew);
            }
            if (upsert) {
                cmd.append("upsert", upsert);
            }
        }
        new DbJobCmd(col.getDB(), cmd, null, button).addJob();
    }

    public void update(final ButtonBase button) {
        final DBCollection col = this.getCollectionNode().getCollection();
        final DBObject query = ((DocBuilderField)this.getBoundUnit(Item.upQuery)).getDBObject();
        final BasicDBObject update = (BasicDBObject)((DocBuilderField)this.getBoundUnit(Item.upUpdate)).getDBObject();
        final boolean upsert = this.getBooleanFieldValue(Item.upUpsert);
        final boolean multi = this.getBooleanFieldValue(Item.upMulti);
        final boolean safe = this.getBooleanFieldValue(Item.upSafe);
        col.setWriteConcern(WriteConcern.SAFE);
        new DbJob(){

            @Override
            public Object doRun() {
                if (safe) {
                    String text;
                    ConfirmDialog confirm;
                    long toupdate;
                    long count = col.getCount(query);
                    long l = toupdate = count > 0L ? 1L : 0L;
                    if (multi) {
                        toupdate = count;
                    }
                    if (!(confirm = new ConfirmDialog(null, "Confirm Update", null, text = "Proceed with updating " + toupdate + " of " + count + " documents?")).show()) {
                        return null;
                    }
                }
                return col.update(query, (DBObject)update.copy(), upsert, multi);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Update";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                obj.put("upsert", (Object)upsert);
                obj.put("multi", (Object)multi);
                return obj;
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void doImport(final ButtonBase button) throws IOException {
        String[] upsertFields;
        ImportDialog dia = UMongo.instance.getGlobalStore().getImportDialog();
        if (!dia.show()) {
            return;
        }
        final boolean dropCollection = dia.getBooleanFieldValue(ImportDialog.Item.dropCollection);
        final boolean continueOnError = dia.getBooleanFieldValue(ImportDialog.Item.continueOnError);
        final boolean upsert = dia.getBooleanFieldValue(ImportDialog.Item.upsert);
        final boolean bulk = dia.getBooleanFieldValue(ImportDialog.Item.bulk);
        String supsertFields = dia.getStringFieldValue(ImportDialog.Item.upsertFields);
        String[] stringArray = upsertFields = supsertFields != null ? supsertFields.split(",") : null;
        if (upsertFields != null) {
            for (int i = 0; i < upsertFields.length; ++i) {
                upsertFields[i] = upsertFields[i].trim();
            }
        }
        final DocumentDeserializer dd = dia.getDocumentDeserializer();
        final DBCollection col = this.getCollectionNode().getCollection();
        new DbJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doRun() throws Exception {
                try {
                    if (dropCollection) {
                        col.drop();
                    }
                    DBObject obj = null;
                    ArrayList<DBObject> batch = new ArrayList<DBObject>();
                    while ((obj = dd.readObject()) != null) {
                        try {
                            if (upsert) {
                                if (upsertFields == null) {
                                    col.save(obj);
                                    continue;
                                }
                                BasicDBObject query = new BasicDBObject();
                                for (int i = 0; i < upsertFields.length; ++i) {
                                    String field = upsertFields[i];
                                    if (!obj.containsField(field)) {
                                        throw new Exception("Upsert field " + field + " not present in object " + obj.toString());
                                    }
                                    query.put(field, obj.get(field));
                                }
                                col.update(query, obj, true, false);
                                continue;
                            }
                            if (bulk) {
                                if (batch.size() > 1000) {
                                    col.insert(batch);
                                    batch.clear();
                                }
                                batch.add(obj);
                                continue;
                            }
                            col.insert(obj);
                        }
                        catch (Exception e) {
                            if (continueOnError) {
                                this.getLogger().log(Level.WARNING, null, e);
                                continue;
                            }
                            throw e;
                        }
                    }
                    if (!batch.isEmpty()) {
                        col.insert(batch);
                    }
                }
                finally {
                    dd.close();
                }
                return null;
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Import";
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void export(ButtonBase button) {
        this.exportToFile(this.getCollectionNode().getCollection(), null, null, null, 0, 0, 0);
    }

    public void getStats(ButtonBase button) {
        new DbJobCmd(this.getCollectionNode().getCollection(), "collstats").addJob();
    }

    public void getIndexes(ButtonBase button) {
        DBCollection col = this.getCollectionNode().getCollection().getDB().getCollection("system.indexes");
        CollectionPanel.doFind(col, new BasicDBObject("ns", this.getCollectionNode().getCollection().getFullName()));
    }

    public void validate(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("validate", this.getCollectionNode().getCollection().getName());
        if (this.getBooleanFieldValue(Item.validateFull)) {
            cmd.put("full", (Object)true);
        }
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb(), cmd, null, button).addJob();
    }

    public void touch(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("touch", this.getCollectionNode().getCollection().getName());
        cmd.put("data", (Object)this.getBooleanFieldValue(Item.touchData));
        cmd.put("index", (Object)this.getBooleanFieldValue(Item.touchIndex));
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb(), cmd, null, button).addJob();
    }

    public void compact(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("compact", this.getCollectionNode().getCollection().getName());
        if (this.getBooleanFieldValue(Item.compactForce)) {
            cmd.put("force", (Object)true);
        }
        if (!UMongo.instance.getGlobalStore().confirmLockingOperation()) {
            return;
        }
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb(), cmd, null, button).addJob();
    }

    public void reIndex(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("reIndex", this.getCollectionNode().getCollection().getName());
        if (!UMongo.instance.getGlobalStore().confirmLockingOperation()) {
            return;
        }
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb(), cmd, null, button).addJob();
    }

    public void shardingInfo(ButtonBase button) {
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        DBCollection col = config.getCollection("collections");
        CollectionPanel.doFind(col, new BasicDBObject("_id", this.getCollectionNode().getCollection().getFullName()));
    }

    public void shardingDistribution(ButtonBase button) {
        final DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                BasicDBObject result = new BasicDBObject();
                BasicDBList shardList = new BasicDBList();
                BasicDBObject stats = CollectionPanel.this.getStats();
                BasicDBObject shards = (BasicDBObject)stats.get("shards");
                if (shards == null || shards.isEmpty()) {
                    return null;
                }
                long totalChunks = 0L;
                long totalSize = stats.getLong("size");
                long totalCount = stats.getLong("count");
                for (Map.Entry shard : shards.entrySet()) {
                    String shardName = (String)shard.getKey();
                    BasicDBObject shardStats = (BasicDBObject)shard.getValue();
                    BasicDBObject query = new BasicDBObject("ns", CollectionPanel.this.getCollectionNode().getCollection().getFullName());
                    query.put("shard", (Object)shardName);
                    long numChunks = config.getCollection("chunks").count(query);
                    totalChunks += numChunks;
                    double estChunkData = numChunks <= 0L ? 0.0 : (double)(shardStats.getLong("size") / numChunks);
                    long estChunkCount = numChunks <= 0L ? 0L : (long)Math.floor(shardStats.getLong("count") / numChunks);
                    BasicDBObject shardDetails = new BasicDBObject("shard", shardName);
                    shardDetails.put("data", (Object)shardStats.getLong("size"));
                    shardDetails.put("pctData", (Object)(totalSize <= 0L ? 0.0 : (double)shardStats.getLong("size") * 100.0 / (double)totalSize));
                    shardDetails.put("docs", (Object)shardStats.getLong("count"));
                    shardDetails.put("pctDocs", (Object)(totalCount <= 0L ? 0.0 : (double)shardStats.getLong("count") * 100.0 / (double)totalCount));
                    shardDetails.put("chunks", (Object)numChunks);
                    if (shardStats.containsField("avgObjSize")) {
                        shardDetails.put("avgDocSize", (Object)shardStats.getDouble("avgObjSize"));
                    }
                    shardDetails.put("estimatedDataPerChunk", (Object)estChunkData);
                    shardDetails.put("estimatedDocsPerChunk", (Object)estChunkCount);
                    shardList.add(shardDetails);
                }
                result.put("shards", (Object)shardList);
                BasicDBObject total = new BasicDBObject();
                total.put("data", (Object)totalSize);
                total.put("docs", (Object)totalCount);
                total.put("chunks", (Object)totalChunks);
                total.put("avgDocSize", (Object)stats.getDouble("avgObjSize"));
                result.put("total", (Object)total);
                return result;
            }

            @Override
            public String getNS() {
                return CollectionPanel.this.getCollectionNode().getCollection().getFullName();
            }

            @Override
            public String getShortName() {
                return "Sharding Distribution";
            }
        }.addJob();
    }

    public void listChunks(ButtonBase button) {
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        DBCollection col = config.getCollection("chunks");
        CollectionPanel.doFind(col, new BasicDBObject("ns", this.getCollectionNode().getCollection().getFullName()));
    }

    public void moveChunk(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.moveChunk)).getDialog();
        ComboBox combo = (ComboBox)this.getBoundUnit(Item.mvckToShard);
        combo.value = 0;
        combo.items = this.getCollectionNode().getDbNode().getMongoNode().getShardNames();
        combo.structureComponent();
        if (!dialog.show()) {
            return;
        }
        BasicDBObject cmd = new BasicDBObject("moveChunk", this.getCollectionNode().getCollection().getFullName());
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.mvckQuery)).getDBObject();
        cmd.append("find", query);
        cmd.append("to", this.getStringFieldValue(Item.mvckToShard));
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb().getSisterDB("admin"), cmd).addJob();
    }

    public void splitChunk(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("split", this.getCollectionNode().getCollection().getFullName());
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.spckQuery)).getDBObject();
        if (this.getBooleanFieldValue(Item.spckOnValue)) {
            cmd.append("middle", query);
        } else {
            cmd.append("find", query);
        }
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb().getSisterDB("admin"), cmd).addJob();
    }

    public void shardCollection(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.shardCollection)).getDialog();
        ComboBox combo = (ComboBox)this.getBoundUnit(Item.shardKeyCombo);
        combo.value = 0;
        List<DBObject> indices = this.getCollectionNode().getCollection().getIndexInfo();
        String[] items = new String[indices.size() + 1];
        items[0] = "None";
        int i = 1;
        for (DBObject index : indices) {
            items[i++] = ((DBObject)index.get("key")).toString();
        }
        combo.items = items;
        combo.structureComponent();
        if (!dialog.show()) {
            return;
        }
        DBObject key = null;
        int index = combo.getComponentIntValue();
        key = index > 0 ? (DBObject)indices.get(index - 1).get("key") : ((DocBuilderField)this.getBoundUnit(Item.shardCustomKey)).getDBObject();
        if (key == null) {
            new InfoDialog(null, "Empty key", null, "You must select a shard key").show();
            return;
        }
        if (!new ConfirmDialog(null, "Confirm shard key", null, "About to shard collection with key " + key + ", is it correct? This operation cannot be undone.").show()) {
            return;
        }
        boolean unique = this.getBooleanFieldValue(Item.shardUniqueIndex);
        DB admin = this.getCollectionNode().getDbNode().getDb().getSisterDB("admin");
        BasicDBObject cmd = new BasicDBObject("shardCollection", this.getCollectionNode().getCollection().getFullName());
        cmd.put("key", (Object)key);
        if (unique) {
            cmd.put("unique", (Object)unique);
        }
        new DbJobCmd(admin, cmd, this, null).addJob();
    }

    private Object handleSpecialFields(DBObject doc) {
        for (String field : doc.keySet()) {
            Object val;
            if (field.equals("__rand")) {
                String type = (String)doc.get(field);
                if (type.equals("int")) {
                    int min = (Integer)doc.get("min");
                    int max = (Integer)doc.get("max");
                    return min + (int)(Math.random() * (double)(max - min + 1));
                }
                if (type.equals("str")) {
                    int len = (Integer)doc.get("len");
                    StringBuilder sb = new StringBuilder(len);
                    int min = 97;
                    int max = 122;
                    for (int i = 0; i < len; ++i) {
                        char c = (char)(min + (byte)(Math.random() * (double)(max - min + 1)));
                        sb.append(c);
                    }
                    return sb.toString();
                }
            }
            if ((val = doc.get(field)) instanceof BasicDBObject) {
                BasicDBObject subdoc = (BasicDBObject)val;
                Object res = this.handleSpecialFields(subdoc);
                if (res == null) continue;
                doc.put(field, res);
                continue;
            }
            if (!(val instanceof BasicDBList)) continue;
            BasicDBList sublist = (BasicDBList)val;
            this.handleSpecialFields(sublist);
        }
        return null;
    }

    public void geoNear(ButtonBase button) {
        DBObject search;
        boolean spherical;
        DBObject query;
        BasicDBObject cmd = new BasicDBObject("geoNear", this.getCollectionNode().getCollection().getName());
        DBObject origin = ((DocBuilderField)this.getBoundUnit(Item.gnOrigin)).getDBObject();
        cmd.put("near", (Object)origin);
        double distance = this.getDoubleFieldValue(Item.gnMaxDistance);
        cmd.put("maxDistance", (Object)distance);
        int limit = this.getIntFieldValue(Item.gnLimit);
        cmd.put("limit", (Object)limit);
        double distanceMult = this.getDoubleFieldValue(Item.gnDistanceMultiplier);
        if (distanceMult > 0.0) {
            cmd.put("distanceMultiplier", (Object)distanceMult);
        }
        if ((query = ((DocBuilderField)this.getBoundUnit(Item.gnQuery)).getDBObject()) != null) {
            cmd.put("query", (Object)query);
        }
        if (spherical = this.getBooleanFieldValue(Item.gnSpherical)) {
            cmd.put("spherical", (Object)true);
        }
        if ((search = ((DocBuilderField)this.getBoundUnit(Item.gnSearch)).getDBObject()) != null) {
            cmd.put("search", (Object)search);
        }
        new DbJobCmd(this.getCollectionNode().getDbNode().getDb(), cmd).addJob();
    }

    public void fixCollection(ButtonBase button) {
        MongoClient m = this.getCollectionNode().getDbNode().getMongoNode().getMongoClient();
        ArrayList<MongoNode> mongoNodes = UMongo.instance.getMongos();
        String[] mongonames = new String[mongoNodes.size() - 1];
        MongoClient[] mongos = new MongoClient[mongonames.length];
        int i = 0;
        for (MongoNode node : mongoNodes) {
            MongoClient m2 = node.getMongoClient();
            if (m == m2) continue;
            mongonames[i] = m2.toString();
            mongos[i] = m2;
            ++i;
        }
        ComboBox src = (ComboBox)this.getBoundUnit(Item.fcSrcMongo);
        src.items = mongonames;
        src.structureComponent();
        FormDialog dialog = (FormDialog)this.getBoundUnit(Item.fcDialog);
        if (!dialog.show()) {
            return;
        }
        final DBCollection dstCol = this.getCollectionNode().getCollection();
        MongoClient srcMongo = mongos[src.getIntValue()];
        final boolean upsert = this.getBooleanFieldValue(Item.fcUpsert);
        String dbname = dstCol.getDB().getName();
        String colname = dstCol.getName();
        final DBCollection srcCol = srcMongo.getDB(dbname).getCollection(colname);
        String txt = "About to copy from ";
        txt = txt + srcMongo.getConnectPoint() + "(" + srcCol.count() + ")";
        txt = txt + " to ";
        if (!new ConfirmDialog(null, "Confirm Fix Collection", null, txt = txt + m.getConnectPoint() + "(" + dstCol.count() + ")").show()) {
            return;
        }
        new DbJob(){

            @Override
            public Object doRun() {
                DBCursor cur = srcCol.find();
                int count = 0;
                int dup = 0;
                while (cur.hasNext()) {
                    DBObject obj = cur.next();
                    if (upsert) {
                        BasicDBObject id = new BasicDBObject("_id", obj.get("_id"));
                        dstCol.update(id, obj, true, false);
                    } else {
                        try {
                            dstCol.insert(obj);
                        }
                        catch (MongoException.DuplicateKey e) {
                            ++dup;
                        }
                    }
                    ++count;
                }
                BasicDBObject res = new BasicDBObject("count", (Object)count);
                res.put("dups", (Object)dup);
                return res;
            }

            @Override
            public String getNS() {
                return "*";
            }

            @Override
            public String getShortName() {
                return "Fix Collection";
            }
        }.addJob();
    }

    public void fullTextSearch(ButtonBase button) {
        String search = this.getStringFieldValue(Item.ftsSearch);
        DBObject filter = ((DocBuilderField)this.getBoundUnit(Item.ftsFilter)).getDBObject();
        DBObject project = ((DocBuilderField)this.getBoundUnit(Item.ftsProject)).getDBObject();
        int limit = this.getIntFieldValue(Item.ftsLimit);
        String language = this.getStringFieldValue(Item.ftsLanguage);
        BasicDBObject cmd = new BasicDBObject("text", this.getCollectionNode().getCollection().getName());
        cmd.put("search", (Object)search);
        cmd.put("filter", (Object)filter);
        cmd.put("project", (Object)project);
        cmd.put("limit", (Object)limit);
        cmd.put("language", (Object)language);
        new DbJobCmd(this.getCollectionNode().getCollection().getDB(), cmd, null, button).addJob();
    }

    public void aggregate(ButtonBase button) {
        AggregateDialog dialog = (AggregateDialog)((MenuItem)this.getBoundUnit(Item.aggregate)).getDialog();
        dialog.refreshAggList();
        if (!dialog.show()) {
            return;
        }
        BasicDBObject cmd = dialog.getAggregateCommand(this.getCollectionNode().getCollection().getName());
        new DbJobCmd(this.getCollectionNode().getCollection().getDB(), cmd, null, button).addJob();
    }

    public void settings(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.settings)).getDialog();
        BasicDBObject stats = this.getStats();
        boolean pwr2 = stats.getBoolean("userFlags", false);
        this.setBooleanFieldValue(Item.usePowerOf2Sizes, pwr2);
        if (!dialog.show()) {
            return;
        }
        boolean newPwr2 = this.getBooleanFieldValue(Item.usePowerOf2Sizes);
        if (newPwr2 != pwr2) {
            BasicDBObject cmd = new BasicDBObject("collMod", this.getCollectionNode().getCollection().getName());
            cmd.put("usePowerOf2Sizes", (Object)newPwr2);
            new DbJobCmd(this.getCollectionNode().getCollection().getDB(), cmd).addJob();
        }
    }

    void refreshTagRangeList() {
        String ns = this.getCollectionNode().getCollection().getFullName();
        ListArea list = (ListArea)this.getBoundUnit(Item.tagRangeList);
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        DBCollection col = config.getCollection("tags");
        DBCursor cur = col.find(new BasicDBObject("ns", ns));
        ArrayList<String> ranges = new ArrayList<String>();
        while (cur.hasNext()) {
            BasicDBObject range = (BasicDBObject)cur.next();
            ranges.add(MongoUtils.getJSON(range));
        }
        list.items = ranges.toArray(new String[ranges.size()]);
        list.structureComponent();
    }

    public void manageTagRanges(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.manageTagRanges)).getDialog();
        this.refreshTagRangeList();
        dialog.show();
    }

    public void addTagRange(ButtonBase button) {
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        final DBCollection col = config.getCollection("tags");
        final String ns = this.getCollectionNode().getCollection().getFullName();
        TagRangeDialog dia = (TagRangeDialog)this.getBoundUnit(Item.tagRangeDialog);
        dia.resetForNew(config, ns);
        if (!dia.show()) {
            return;
        }
        final BasicDBObject doc = dia.getRange(ns);
        new DbJob(){

            @Override
            public Object doRun() {
                return col.insert(doc);
            }

            @Override
            public String getNS() {
                return ns;
            }

            @Override
            public String getShortName() {
                return "Add Tag Range";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject root = new BasicDBObject("doc", doc);
                return root;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                CollectionPanel.this.refreshTagRangeList();
            }
        }.addJob();
    }

    public void editTagRange(ButtonBase button) {
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        final DBCollection col = config.getCollection("tags");
        final String ns = this.getCollectionNode().getCollection().getFullName();
        TagRangeDialog dia = (TagRangeDialog)this.getBoundUnit(Item.tagRangeDialog);
        String value = this.getComponentStringFieldValue(Item.tagRangeList);
        BasicDBObject range = (BasicDBObject)JSON.parse(value);
        dia.resetForEdit(config, range);
        if (!dia.show()) {
            return;
        }
        final BasicDBObject doc = dia.getRange(ns);
        new DbJob(){

            @Override
            public Object doRun() {
                return col.save(doc);
            }

            @Override
            public String getNS() {
                return ns;
            }

            @Override
            public String getShortName() {
                return "Edit Tag Range";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject root = new BasicDBObject("doc", doc);
                return root;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                CollectionPanel.this.refreshTagRangeList();
            }
        }.addJob();
    }

    public void removeTagRange(ButtonBase button) {
        DB config = this.getCollectionNode().getCollection().getDB().getSisterDB("config");
        final DBCollection col = config.getCollection("tags");
        final String ns = this.getCollectionNode().getCollection().getFullName();
        String value = this.getComponentStringFieldValue(Item.tagRangeList);
        BasicDBObject range = (BasicDBObject)JSON.parse(value);
        DBObject min = (DBObject)range.get("min");
        final BasicDBObject doc = new BasicDBObject("_id", new BasicDBObject("ns", ns).append("min", min));
        new DbJob(){

            @Override
            public Object doRun() {
                return col.remove(doc);
            }

            @Override
            public String getNS() {
                return ns;
            }

            @Override
            public String getShortName() {
                return "Remove Tag Range";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject root = new BasicDBObject("doc", doc);
                return root;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                CollectionPanel.this.refreshTagRangeList();
            }
        }.addJob();
    }

    public void summarizeData(ButtonBase button) {
        final CollectionNode cnode = this.getCollectionNode();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return cnode.summarizeData();
            }

            @Override
            public String getNS() {
                return cnode.getCollection().getFullName();
            }

            @Override
            public String getShortName() {
                return "Summarize Data";
            }
        }.addJob();
    }

    static enum Item {
        icon,
        name,
        fullName,
        queryOptions,
        writeConcern,
        readPreference,
        stats,
        getStats,
        getIndexes,
        refresh,
        dropCollection,
        rename,
        newName,
        dropTarget,
        doImport,
        export,
        find,
        findQuery,
        findFields,
        findSort,
        findSkip,
        findLimit,
        findBatchSize,
        findExplain,
        findExport,
        findHint,
        foQuery,
        foFields,
        count,
        countQuery,
        countSkip,
        countLimit,
        remove,
        removeQuery,
        rmAllConfirm,
        mapReduce,
        mrMap,
        mrReduce,
        mrFinalize,
        mrQuery,
        mrSort,
        mrType,
        mrOut,
        mrOutDB,
        mrOutSharded,
        mrNonAtomic,
        mrLimit,
        mrJSMode,
        group,
        grpKeys,
        grpQuery,
        grpInitialValue,
        grpReduce,
        grpFinalize,
        readWriteOptions,
        insert,
        insertDoc,
        insertCount,
        insertBulk,
        createIndex,
        findAndModify,
        famQuery,
        famFields,
        famSort,
        famUpdate,
        famRemove,
        famReturnNew,
        famUpsert,
        update,
        upQuery,
        upUpdate,
        upUpsert,
        upMulti,
        upSafe,
        save,
        saveDoc,
        shardingInfo,
        shardingDistribution,
        shardCollection,
        shardKeyCombo,
        shardCustomKey,
        shardUniqueIndex,
        listChunks,
        validate,
        validateFull,
        touch,
        touchData,
        touchIndex,
        compact,
        compactForce,
        reIndex,
        moveChunk,
        mvckQuery,
        mvckToShard,
        splitChunk,
        spckQuery,
        spckOnValue,
        geoNear,
        gnOrigin,
        gnLimit,
        gnMaxDistance,
        gnDistanceMultiplier,
        gnQuery,
        gnSpherical,
        gnSearch,
        lazyDecoding,
        fixCollection,
        fcDialog,
        fcSrcMongo,
        fcUpsert,
        fullTextSearch,
        ftsSearch,
        ftsFilter,
        ftsProject,
        ftsLimit,
        ftsLanguage,
        aggregate,
        settings,
        usePowerOf2Sizes,
        manageTagRanges,
        tagRangeList,
        tagRangeDialog,
        addTagRange,
        editTagRange,
        removeTagRange,
        distinct,
        distinctKey,
        distinctQuery,
        summarizeData;

    }
}

