/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.DbNode;
import com.edgytech.umongo.IndexNode;
import com.edgytech.umongo.Resource;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.SAXException;

public class CollectionNode
extends BaseTreeNode {
    DBCollection collection;
    BasicDBObject stats;

    public CollectionNode(DBCollection collection) throws IOException, SAXException {
        this.collection = collection;
        this.xmlLoad(Resource.getXmlDir(), Resource.File.collectionNode, null);
        this.markStructured();
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public DbNode getDbNode() {
        return (DbNode)((DefaultMutableTreeNode)this.getTreeNode().getParent()).getUserObject();
    }

    @Override
    protected void populateChildren() {
        for (DBObject index : this.collection.getIndexInfo()) {
            this.addChild(new IndexNode(this.collection, index));
        }
    }

    @Override
    protected void updateNode() {
        this.label = this.collection.getName();
        if (this.stats != null) {
            this.label = this.label + " (" + this.stats.getLong("count") + "/" + this.stats.getLong("size") + ")";
            if (this.stats.getBoolean("sharded")) {
                this.addOverlay("overlay/star_grey.png");
            }
        }
    }

    @Override
    protected void refreshNode() {
        CommandResult res = this.collection.getStats();
        res.throwOnError();
        this.stats = res;
    }

    public BasicDBObject getStats() {
        BasicDBObject cmd = new BasicDBObject("collStats", this.getCollection().getName());
        return this.getCollection().getDB().command(cmd);
    }

    DBObject summarizeData() {
        BasicDBObject sum = new BasicDBObject("ns", this.getCollection().getFullName());
        sum.put("sampleDoc", (Object)this.getCollection().findOne());
        sum.put("stats", (Object)this.getStats());
        return sum;
    }
}

