/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.Tree;
import com.edgytech.swingfast.TreeNodeLabel;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.umongo.UMongo;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class BaseTreeNode
extends TreeNodeLabel {
    ImageIcon cachedIcon;
    boolean hasExpanded = false;
    private Set<String> overlays = new HashSet<String>();

    @Override
    protected void structureComponentCustom(JComponent old) {
        long time = System.currentTimeMillis();
        this.removeAllChildren();
        try {
            XmlUnit parent = this.getParent();
            if (parent instanceof Tree || ((BaseTreeNode)parent).hasExpanded) {
                UMongo.instance.addNodeToRefresh(this);
                this.populateChildren();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        super.structureComponentCustom(old);
    }

    @Override
    protected void updateComponentCustom(JComponent comp) {
        try {
            this.updateNode();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        this.cachedIcon = SwingFast.createIcon(this.icon, this.iconGroup);
        if (this.overlays.size() > 0) {
            ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
            for (String str : this.overlays) {
                icons.add(SwingFast.createIcon(str, this.iconGroup));
            }
            this.cachedIcon = SwingFast.createOverlayIcon(this.cachedIcon, icons);
        }
        long time = System.currentTimeMillis();
        super.updateComponentCustom(comp);
    }

    void refresh() {
        this.clearOverlays();
        try {
            this.refreshNode();
        }
        catch (MongoException e) {
            if (e.getCode() == 10057 || e.getMessage().contains("unauthorized") || e.getMessage().contains("not authorized")) {
                this.addOverlay("overlay/lock_tiny.png");
            } else {
                this.addOverlay("overlay/error.png");
            }
            this.getLogger().log(Level.FINE, null, e);
        }
        catch (Exception e) {
            this.addOverlay("overlay/error.png");
            this.getLogger().log(Level.FINE, null, e);
        }
    }

    public TreeNodeLabel getParentNode() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getTreeNode().getParent();
        if (parent == null) {
            return null;
        }
        return (TreeNodeLabel)parent.getUserObject();
    }

    protected abstract void populateChildren();

    public void removeNode() {
        TreeNodeLabel parent = this.getParentNode();
        parent.removeChild(this);
        parent.structureComponent();
    }

    @Override
    public void handleNodeSelection() {
        UMongo.instance.displayNode(this);
    }

    @Override
    public Icon getIcon() {
        return this.cachedIcon;
    }

    protected abstract void updateNode();

    protected abstract void refreshNode();

    void clearOverlays() {
        this.overlays.clear();
    }

    void addOverlay(String str) {
        this.overlays.add(str);
    }

    @Override
    public void handleWillExpand() {
        if (!this.hasExpanded) {
            this.hasExpanded = true;
            this.structureComponent();
        }
    }
}

