/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.ListArea;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.umongo.EditAggOpDialog;
import com.edgytech.umongo.MongoUtils;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class AggregateDialog
extends FormDialog
implements EnumListener<Item> {
    List<BasicDBObject> operationList = new ArrayList<BasicDBObject>();
    @XmlUnit.SerialStar
    public String pipeline = "";

    public AggregateDialog() {
        this.setEnumBinding(Item.values(), this);
    }

    void refreshAggList() {
        ListArea list = (ListArea)this.getBoundUnit(Item.operationList);
        String[] items = new String[this.operationList.size()];
        int i = 0;
        for (BasicDBObject op : this.operationList) {
            String json = MongoUtils.getJSON(op);
            items[i++] = json.substring(0, Math.min(80, json.length()));
        }
        list.items = items;
        list.structureComponent();
    }

    public void addOperation(ButtonBase button) {
        FormDialog od = (FormDialog)this.getBoundUnit(Item.addOperationDialog);
        if (!od.show()) {
            return;
        }
        String op = this.getStringFieldValue(Item.operation);
        BasicDBObject opObj = this.editOperation(null, "$" + op);
        if (opObj != null) {
            this.operationList.add(opObj);
            this.refreshAggList();
        }
    }

    public void removeOperation(ButtonBase button) {
        int opId = this.getComponentIntFieldValue(Item.operationList);
        this.operationList.remove(opId);
        this.refreshAggList();
    }

    public void editOperation(ButtonBase button) {
        int opId = this.getComponentIntFieldValue(Item.operationList);
        BasicDBObject opObj = this.operationList.get(opId);
        if ((opObj = this.editOperation(opObj, null)) != null) {
            this.operationList.set(opId, opObj);
            this.refreshAggList();
        }
    }

    public BasicDBObject editOperation(BasicDBObject opObj, String op) {
        if (op == null) {
            op = (String)opObj.keySet().iterator().next();
        }
        EditAggOpDialog od = null;
        if ("$match".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggMatchDialog);
        } else if ("$project".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggProjectDialog);
        } else if ("$limit".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggLimitDialog);
        } else if ("$skip".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggSkipDialog);
        } else if ("$sort".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggSortDialog);
        } else if ("$unwind".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggUnwindDialog);
        } else if ("$group".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggGroupDialog);
        } else if ("$geoNear".equals(op)) {
            od = (EditAggOpDialog)this.getBoundUnit(Item.editAggGeoNearDialog);
        }
        if (opObj != null) {
            od.setOperation(opObj);
        }
        if (!od.show()) {
            return null;
        }
        opObj = od.getOperation();
        return opObj;
    }

    public void moveUpOperation(ButtonBase button) {
        int opId = this.getComponentIntFieldValue(Item.operationList);
        if (opId > 0) {
            BasicDBObject opObj = this.operationList.get(opId);
            BasicDBObject other = this.operationList.get(opId - 1);
            this.operationList.set(opId - 1, opObj);
            this.operationList.set(opId, other);
            this.refreshAggList();
        }
    }

    public void moveDownOperation(ButtonBase button) {
        int opId = this.getComponentIntFieldValue(Item.operationList);
        if (opId < this.operationList.size() - 1) {
            BasicDBObject opObj = this.operationList.get(opId);
            BasicDBObject other = this.operationList.get(opId + 1);
            this.operationList.set(opId + 1, opObj);
            this.operationList.set(opId, other);
            this.refreshAggList();
        }
    }

    BasicDBObject getAggregateCommand(String collection) {
        BasicDBObject cmd = new BasicDBObject("aggregate", collection);
        BasicDBList list = new BasicDBList();
        cmd.put("pipeline", (Object)list);
        for (BasicDBObject op : this.operationList) {
            list.add(op);
        }
        return cmd;
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        BasicDBObject cmd = (BasicDBObject)JSON.parse(this.pipeline);
        if (cmd != null && cmd.containsField("pipeline")) {
            BasicDBList list = (BasicDBList)cmd.get("pipeline");
            this.operationList.clear();
            for (Object op : list) {
                this.operationList.add((BasicDBObject)op);
            }
            this.refreshAggList();
        }
    }

    @Override
    protected void commitComponentCustom(JDialog comp) {
        this.pipeline = MongoUtils.getJSON(this.getAggregateCommand("dummy"));
    }

    static enum Item {
        operationList,
        addOperationDialog,
        valueOperationDialog,
        genericOperationDialog,
        operation,
        value,
        parameters,
        addOperation,
        removeOperation,
        editOperation,
        moveUpOperation,
        moveDownOperation,
        editAggLimitDialog,
        editAggSkipDialog,
        editAggMatchDialog,
        editAggSortDialog,
        editAggProjectDialog,
        editAggUnwindDialog,
        editAggGroupDialog,
        editAggGeoNearDialog;

    }
}

