/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    static XmlUtils m_instance = null;
    DocumentBuilderFactory m_factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder m_defaultBuilder;
    static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getSimpleName());

    private XmlUtils() {
        this.m_factory.setValidating(false);
        this.m_factory.setNamespaceAware(false);
        this.m_defaultBuilder = this.createDocBuilder();
    }

    public static XmlUtils getInstance() {
        if (m_instance == null) {
            m_instance = new XmlUtils();
        }
        return m_instance;
    }

    public DocumentBuilder getDefaultBuilder() {
        return this.m_defaultBuilder;
    }

    public DocumentBuilder createDocBuilder() {
        DocumentBuilder builder;
        try {
            builder = this.m_factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            builder = null;
        }
        return builder;
    }

    public static Element getChildByTagname(Node parent, String tag) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elmt;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(elmt = (Element)child).getTagName().equals(tag)) continue;
            return elmt;
        }
        return null;
    }

    public static ArrayList<Element> getChildrenByTagname(Node parent, String tag) {
        NodeList children = parent.getChildNodes();
        ArrayList<Element> res = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elmt;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(elmt = (Element)child).getTagName().equals(tag)) continue;
            res.add(elmt);
        }
        return res;
    }

    public static int getNumChildrenByTagname(Node parent, String tag) {
        NodeList children = parent.getChildNodes();
        int num = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Element elmt;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(elmt = (Element)child).getTagName().equals(tag)) continue;
            ++num;
        }
        return num;
    }

    public static Element addChildByTagname(Node parent, String tag) {
        Element unit = XmlUtils.getDocumentOf(parent).createElement(tag);
        parent.appendChild(unit);
        return unit;
    }

    public static String getChildTextValue(Node parent, String childName) {
        Element child = XmlUtils.getChildByTagname(parent, childName);
        if (child == null) {
            return null;
        }
        return child.getTextContent();
    }

    public static void setChildTextValue(Node parent, String childName, String value) {
        boolean set = true;
        if (value == null) {
            set = false;
        }
        Element child = XmlUtils.getChildByTagname(parent, childName);
        if (!set) {
            if (child == null) {
                return;
            }
            parent.removeChild(child);
            return;
        }
        if (child == null) {
            child = XmlUtils.getDocumentOf(parent).createElement(childName);
            parent.appendChild(child);
        }
        child.setTextContent(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseString(String xmlStr, DocumentBuilder builder) {
        if (builder == null) {
            builder = this.getDefaultBuilder();
        }
        StringReader reader = new StringReader(xmlStr);
        InputSource source = new InputSource(reader);
        Document xmlDoc = null;
        try {
            DocumentBuilder documentBuilder = builder;
            synchronized (documentBuilder) {
                xmlDoc = builder.parse(source);
            }
        }
        catch (SAXException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseStream(InputStream xml, DocumentBuilder builder) throws SAXException, IOException {
        if (builder == null) {
            builder = this.getDefaultBuilder();
        }
        Document xmlDoc = null;
        DocumentBuilder documentBuilder = builder;
        synchronized (documentBuilder) {
            xmlDoc = builder.parse(xml);
        }
        return xmlDoc;
    }

    public Document parseResource(String path, DocumentBuilder builder) throws SAXException, IOException {
        return this.parseStream(XmlUtils.class.getResourceAsStream(path), builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseFile(String path, DocumentBuilder builder) throws IOException, SAXException {
        if (builder == null) {
            builder = this.getDefaultBuilder();
        }
        Document xmlDoc = null;
        DocumentBuilder documentBuilder = builder;
        synchronized (documentBuilder) {
            xmlDoc = builder.parse(path);
        }
        return xmlDoc;
    }

    public static void saveFile(String fileName, Document doc) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        File xmlOutputFile = new File(fileName);
        FileOutputStream fos = new FileOutputStream(xmlOutputFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(fos);
        transformer.transform(source, result);
    }

    public static String convertToString(Element elmt) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(elmt), new StreamResult(buffer));
        return buffer.toString();
    }

    public static Document getDocumentOf(Node xmlNode) {
        if (xmlNode.getNodeType() == 9) {
            return (Document)xmlNode;
        }
        return xmlNode.getOwnerDocument();
    }

    public static void removeAllChildNodes(Node elmt) {
        NodeList children = elmt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            elmt.removeChild(children.item(i));
        }
    }

    public static void copyChildNodesOver(Node src, Node dst, Document doc) {
        NodeList children = src.getChildNodes();
        if (children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                node = doc.importNode(node, true);
                dst.appendChild(node);
            }
        }
    }
}

