/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.FieldChecker;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class XmlUnitField<U extends XmlUnit, C extends JComponent>
extends XmlJComponentUnit<U, C> {
    @XmlUnit.Serial
    public int columns = 0;
    @XmlUnit.Serial
    public boolean field = true;
    JLabel _jlabel;
    JLabel _error;
    static final Color C_NORMAL = Color.DARK_GRAY;
    static final Color C_ERROR = Color.RED;
    BoxPanel _displayComp;

    public XmlUnitField() {
        this.fill = true;
        this.commitOnNotify = false;
    }

    @Override
    public Component getDisplayComponent() {
        if (this.field) {
            if (this._displayComp == null) {
                this._displayComp = new BoxPanel(Common.Axis.X, Common.Align.CENTER, false);
                this._displayComp.setOpaque(false);
                BoxPanel content = new BoxPanel(Common.Axis.Y, Common.Align.CENTER, false);
                content.setOpaque(false);
                this._displayComp.add(content);
                BoxPanel body = new BoxPanel(Common.Axis.X, Common.Align.CENTER, false);
                body.setOpaque(false);
                content.add(body);
                this._jlabel = new JLabel(this.getLabelToDisplay() + " : ", 4);
                body.add(this._jlabel);
                body.add(this.getComponent());
                body.addGlue();
                this._error = new JLabel();
                this._error.setForeground(C_ERROR);
                this._error.setVisible(false);
                content.add(this._error);
                if (this.toolTipText != null) {
                    this._displayComp.setToolTipText(this.toolTipText);
                }
                this._displayComp.setVisible(this.visible);
            }
            return this._displayComp;
        }
        return this.getComponent();
    }

    public void setDisplayNormal() {
        if (this._jlabel != null) {
            this._jlabel.setForeground(C_NORMAL);
        }
        if (this._error != null) {
            this._error.setVisible(false);
        }
        if (this._displayComp != null) {
            this._displayComp.setVisible(this.visible);
        }
    }

    public void setDisplayError(String error) {
        if (this._jlabel != null) {
            this._jlabel.setForeground(C_ERROR);
        }
        if (this._error != null) {
            this._error.setText(error);
            this._error.setVisible(true);
        }
    }

    public JLabel getFieldLabel() {
        return this._jlabel;
    }

    @Override
    public void updateComponent(boolean doChildren) {
        super.updateComponent(doChildren);
        if (this.field && this.hasComponent()) {
            this.setDisplayNormal();
        }
    }

    protected abstract boolean checkComponentCustom(C var1);

    public final boolean checkComponent(FieldChecker checker) {
        return this.checkComponent(checker, true);
    }

    public boolean checkComponent(FieldChecker checker, boolean doChildren) {
        Enum enm;
        boolean res = true;
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlUnitField.class.isInstance(child) || ((XmlUnitField)child).checkComponent(checker)) continue;
                res = false;
            }
        }
        if (!this.checkComponentCustom(this.getComponent())) {
            res = false;
        }
        if (checker != null && (enm = this.getBoundEnum()) != null && !checker.formCheckField(enm, this)) {
            res = false;
        }
        return res;
    }
}

