/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.AppUtils;
import com.edgytech.swingfast.BooleanFieldInterface;
import com.edgytech.swingfast.DateFieldInterface;
import com.edgytech.swingfast.Directory;
import com.edgytech.swingfast.DoubleFieldInterface;
import com.edgytech.swingfast.EnumBinding;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FloatFieldInterface;
import com.edgytech.swingfast.IntFieldInterface;
import com.edgytech.swingfast.LongFieldInterface;
import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.Template;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUnit<T extends XmlUnit> {
    static String PACKAGE;
    static String XMLHOLDER_TAGNAME;
    static String DEFAULT_CONTEXT;
    static String DEFAULT_SEPARATOR;
    protected ArrayList<T> _children = null;
    protected HashMap<String, T> _childrenMap;
    protected boolean _structured = false;
    protected Element _checkpoint;
    protected HashMap<String, Element> _xmlHolder = null;
    protected XmlUnit _parent;
    @SerialStar
    public String id = null;
    @Serial
    public String[] contexts;
    @Serial
    public String label = null;
    @Serial
    public boolean load = true;
    @Serial
    public boolean save = true;
    @Serial
    public boolean alwaysStructure = false;
    @Serial
    public String start;
    @Serial
    public String stop;
    @Serial
    public String templateId;
    private static HashMap<Class, ClassData> CLASS_DATA;
    private ClassData _clData = this.getClassData();
    protected Enum _ebEnum;
    protected EnumBinding _eb;
    State _state = State.STRUCTURE;

    public final boolean isStructured() {
        return this._structured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassData getClassData(Class c) {
        ClassData data = CLASS_DATA.get(c);
        if (data == null) {
            HashMap<Class, ClassData> hashMap = CLASS_DATA;
            synchronized (hashMap) {
                data = CLASS_DATA.get(c);
                if (data == null) {
                    data = new ClassData(c);
                    CLASS_DATA.put(c, data);
                }
            }
        }
        return data;
    }

    private ClassData getClassData() {
        ClassData data = XmlUnit.getClassData(this.getClass());
        return data;
    }

    public Logger getLogger() {
        return this._clData._log;
    }

    public void logInfoLine(String str) {
        this.getLogger().info(this.getExplicitName() + ": " + str);
    }

    public void logWarnLine(String str) {
        this.getLogger().warning(this.getExplicitName() + ": " + str);
    }

    public void logErrorLine(String str) {
        this.getLogger().severe(this.getExplicitName() + ": " + str);
    }

    public void logDebugLine(String str) {
        this.getLogger().info(this.getExplicitName() + ": " + str);
    }

    public Element getCheckpoint() {
        return this._checkpoint;
    }

    public void setCheckpoint(Element checkpoint) {
        this._checkpoint = checkpoint;
    }

    public T addChild(T child) {
        String id;
        if (this._children == null) {
            this._children = new ArrayList();
            this._childrenMap = new HashMap();
        }
        if ((id = ((XmlUnit)child).getId()) != null) {
            XmlUnit old = (XmlUnit)this._childrenMap.get(((XmlUnit)child).getId());
            if (old != null) {
                this.getLogger().warning(String.format("Duplicate ids '%s' for unit '%s', only 1st child will exists", ((XmlUnit)child).getId(), child.getClass().getName()));
                return (T)old;
            }
            this._childrenMap.put(((XmlUnit)child).getId(), child);
        }
        this._children.add(child);
        if (this._eb != null) {
            ((XmlUnit)child).setEnumBinding(this._eb);
        }
        this.propagateContextsUp(((XmlUnit)child).getContexts());
        ((XmlUnit)child).setParent(this);
        return null;
    }

    public final void removeChild(T child) {
        if (this.hasChildren()) {
            this._children.remove(child);
            this._childrenMap.remove(((XmlUnit)child).getId());
            ((XmlUnit)child).setParent(null);
        }
    }

    public final void addChildren(T[] children) {
        for (T child : children) {
            this.addChild(child);
        }
    }

    public final void removeChildren(T[] children) {
        for (XmlUnit child : this.getChildren()) {
            this.removeChild(child);
        }
    }

    public final void removeAllChildren() {
        if (this.hasChildren()) {
            this._children.clear();
            this._childrenMap.clear();
        }
    }

    public final T getChild(int i) {
        return (T)((XmlUnit)this._children.get(i));
    }

    public final T getChildById(String id) {
        if (this.hasChildren()) {
            return (T)((XmlUnit)this._childrenMap.get(id));
        }
        return null;
    }

    public final XmlUnit getChildByIdRecursive(String refId) {
        XmlUnit child = null;
        if (this.hasChildren()) {
            child = (XmlUnit)this._childrenMap.get(refId);
            if (child != null) {
                return child;
            }
            XmlUnit found = null;
            for (XmlUnit child2 : this.getChildren()) {
                child = child2.getChildByIdRecursive(refId);
                if (child == null) continue;
                if (found == null) {
                    found = child;
                    continue;
                }
                this.logWarnLine("Duplicate id " + refId + " found while loading, loading may be wrong");
                return found;
            }
            return found;
        }
        return null;
    }

    public final <C> C getFirstChildOfClass(Class<C> c, String id) {
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (id != null && !id.equals(child.getId()) || !c.isInstance(child)) continue;
                return (C)child;
            }
        }
        return null;
    }

    public <C> ArrayList<C> getChildrenOfClass(Class<C> c, ArrayList<C> list) {
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!c.isInstance(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public <C> ArrayList<C> getChildrenOfClass(Class<C> c) {
        return this.getChildrenOfClass(c, new ArrayList());
    }

    public final ArrayList<T> getChildren() {
        return this._children;
    }

    public final boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    public final int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public final T getFirstChild() {
        if (!this.hasChildren()) {
            return null;
        }
        return (T)((XmlUnit)this._children.get(0));
    }

    public void setParent(XmlUnit parent) {
        if (this._parent != null && parent != null && this._parent != parent) {
            if (parent.getId() != null) {
                this.logDebugLine(String.format("Unit already has a parent %s, trying to set new parent %s", this._parent.getExplicitName(), parent.getExplicitName()));
            }
            return;
        }
        this._parent = parent;
    }

    public XmlUnit getParent() {
        return this._parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasId() {
        return this.id != null && !"".equals(this.id);
    }

    public String getLabelToDisplay() {
        if (this.label == null) {
            if (this.id != null && this.id.length() > 0) {
                return AppUtils.convertIdToLabel(this.id);
            }
            return "";
        }
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public void setContexts(String[] contexts) {
        this.contexts = contexts;
    }

    public boolean hasContext(String context) {
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        if (this.contexts == null) {
            return context.equalsIgnoreCase(DEFAULT_CONTEXT);
        }
        for (String c : this.contexts) {
            if (!c.equalsIgnoreCase(context)) continue;
            return true;
        }
        return false;
    }

    public void addDefaultContext() {
        this.addContext(DEFAULT_CONTEXT);
    }

    public void addContext(String context) {
        if (this.contexts == null) {
            this.contexts = new String[1];
            this.contexts[0] = context;
        } else {
            if (this.hasContext(context)) {
                return;
            }
            String[] newContexts = Arrays.copyOf(this.contexts, this.contexts.length + 1);
            newContexts[this.contexts.length] = context;
            this.contexts = newContexts;
        }
    }

    private void propagateContextsUp(String[] contexts) {
        if (contexts == null) {
            return;
        }
        if (this.contexts == null) {
            this.addDefaultContext();
        }
        for (String context : contexts) {
            this.addContext(context);
        }
        if (this._parent != null) {
            this._parent.propagateContextsUp(contexts);
        }
    }

    public boolean setEnumBinding(EnumBinding eb) {
        return this.setEnumBinding(eb, false);
    }

    public boolean setEnumBinding(EnumBinding eb, boolean force) {
        if (eb == null) {
            return false;
        }
        eb.registerUnit(this);
        if (this._eb == null || force) {
            this._eb = eb;
            if (this.hasChildren()) {
                for (XmlUnit unit : this._children) {
                    unit.setEnumBinding(eb, force);
                }
            }
            return true;
        }
        return false;
    }

    public void setEnumBinding(Enum[] enms, EnumListener listener) {
        this.setEnumBinding(new EnumBinding(enms, listener));
    }

    public EnumBinding getEnumBinding() {
        return this._eb;
    }

    public void setBoundEnum(Enum enm) {
        this._ebEnum = enm;
    }

    public Enum getBoundEnum() {
        return this._ebEnum;
    }

    public XmlUnit getBoundUnit(Enum enm) {
        if (this._eb != null) {
            return this._eb.getUnit(enm);
        }
        return null;
    }

    public XmlComponentUnit getComponentBoundUnit(Enum enm) {
        return (XmlComponentUnit)this.getBoundUnit(enm);
    }

    public XmlJComponentUnit getJComponentBoundUnit(Enum enm) {
        return (XmlJComponentUnit)this.getBoundUnit(enm);
    }

    public XmlUnit getBoundUnit(String name) {
        XmlUnit unit = null;
        if (this._eb != null) {
            unit = this._eb.getUnit(name);
        }
        if (unit != null) {
            return unit;
        }
        return this.getChildById(name);
    }

    public XmlComponentUnit getComponentBoundUnit(String name) {
        return (XmlComponentUnit)this.getBoundUnit(name);
    }

    public static final XmlUnit newInstance(Class c) {
        XmlUnit inst = null;
        try {
            inst = (XmlUnit)c.newInstance();
        }
        catch (Exception ex) {
            System.out.println(ex);
            XmlUnit.getClassData((Class)c)._log.severe("Class " + c.getCanonicalName() + " doesn't have a valid nullary constructor.");
        }
        return inst;
    }

    private XmlUnit xmlCreateAndAddChild(Element elmt, Class c) {
        XmlUnit child = XmlUnit.newInstance(c);
        if (child == null) {
            return null;
        }
        child.xmlLoad(elmt, null);
        this.addChild(child);
        return child;
    }

    public final void setState(State state) {
        this._state = state;
    }

    public final State getState() {
        return this._state;
    }

    public String getTagName() {
        String tagname = this.getClass().getName();
        if (tagname.startsWith(PACKAGE)) {
            return this.getClass().getSimpleName();
        }
        return tagname;
    }

    public String getExplicitName() {
        return this.getTagName() + " of id " + this.getId();
    }

    private final Element xmlAddEmptyNode(Node parent, XmlUnit unit) {
        Element elmt = XmlUtils.addChildByTagname(parent, unit.getTagName());
        return elmt;
    }

    public final Element xmlLoad(Element elmt, String context) {
        return this.xmlLoad(elmt, context, null);
    }

    public final Element xmlLoadCheckpoint() {
        return this.xmlLoadCheckpoint(State.NORMAL, true);
    }

    public final Element xmlLoadCheckpoint(State force, boolean recursive) {
        Element elmt = null;
        if (this._checkpoint != null) {
            elmt = this.xmlLoad(this._checkpoint, null, force, false);
        }
        if (recursive && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                child.xmlLoadCheckpoint(force, recursive);
            }
        }
        return elmt;
    }

    public final Element xmlLoad(Element elmt, String context, State force) {
        return this.xmlLoad(elmt, context, force, true);
    }

    public final Element xmlLoad(Element elmt, String context, State force, boolean recursive) {
        if (elmt == null) {
            return elmt;
        }
        this.xmlPreLoadCallback(elmt, force);
        if (!this.load) {
            return null;
        }
        if (!this.hasContext(context)) {
            return null;
        }
        State state = force == null ? this._state : force;
        if (state != State.STRUCTURE && !this._structured) {
            this.getLogger().warning("xmlLoad on an unstructured node " + this.getExplicitName());
        }
        switch (state) {
            case STRUCTURE: {
                this.xmlLoadAttrs(elmt);
                this.xmlHolderLoad(elmt);
                Element refElmt = null;
                if (this.templateId != null) {
                    if (!this.hasId()) {
                        this.logErrorLine(" id must be set when trying to use templateId " + this.templateId);
                    } else {
                        Element template = Template.getTemplate(this.templateId);
                        if (template != null) {
                            refElmt = elmt;
                            elmt = template;
                        }
                    }
                }
                this.structure(elmt);
                this._structured = true;
                if (refElmt != null) {
                    elmt = this.xmlLoadReferences(refElmt, context);
                }
                Element ckpt = XmlUtils.getDocumentOf(elmt).createElement("checkpoint");
                this.xmlSaveAttrs(ckpt);
                this.setCheckpoint(ckpt);
                break;
            }
            case NORMAL: {
                this.xmlLoadAttrs(elmt);
                this.xmlHolderLoad(elmt);
                if (!recursive) break;
                this.xmlLoadChildren(elmt, context, force);
                break;
            }
            case STARRED: {
                this.xmlLoadStarAttrs(elmt);
                this.xmlHolderLoad(elmt);
                if (!recursive) break;
                this.xmlLoadChildren(elmt, context, force);
            }
        }
        this.xmlPostLoadCallback(elmt, state);
        state = this.xmlStateCallback();
        if (state != this._state) {
            this.setState(state);
        }
        return elmt;
    }

    private Element xmlLoadReferences(Element refElmt, String context) {
        ArrayList<Element> references = XmlUtils.getChildrenByTagname(refElmt, "Ref");
        boolean modified = false;
        for (Element ref : references) {
            XmlUnit child;
            String refId = ref.getAttribute("id");
            if (refId.length() == 0 || (child = this.getChildByIdRecursive(refId)) == null) continue;
            child.setState(State.STRUCTURE);
            child.xmlLoad(ref, context);
            modified = true;
        }
        if (!modified) {
            return null;
        }
        Element elmt = XmlUtils.getDocumentOf(refElmt).createElement(this.getTagName());
        this.xmlSave(elmt, context, State.STRUCTURE);
        return elmt;
    }

    public final Element xmlLoad(String filename, boolean resource, String context) throws IOException, SAXException {
        return this.xmlLoad(filename, resource, context, null);
    }

    public final Element xmlLoad(String filename, boolean resource, String context, State force) throws IOException, SAXException {
        Document doc = resource ? XmlUtils.getInstance().parseResource(filename, null) : XmlUtils.getInstance().parseFile(filename, null);
        if (doc != null) {
            return this.xmlLoad(doc.getDocumentElement(), context, force);
        }
        return null;
    }

    public final Element xmlLoad(Directory dir, Enum file, String context) throws IOException, SAXException {
        return this.xmlLoad(dir, file, context, null);
    }

    public final Element xmlLoad(Directory dir, Enum file, String context, State force) throws IOException, SAXException {
        return this.xmlLoad(dir.getPath(file), dir.isResource(), context, force);
    }

    protected void xmlPreLoadCallback(Node parent, State force) {
    }

    protected void xmlPostLoadCallback(Node unit, State state) {
    }

    protected State xmlStateCallback() {
        if (this.alwaysStructure) {
            return State.STRUCTURE;
        }
        if (this._structured) {
            return State.STARRED;
        }
        return State.STRUCTURE;
    }

    public final Element xmlSave(Element elmt, String context) {
        return this.xmlSave(elmt, context, null);
    }

    public final Element xmlSaveCreatingNode(Node parent, String context, State force) {
        boolean isroot = parent.getOwnerDocument() == null;
        Element elmt = XmlUtils.getDocumentOf(parent).createElement(this.getTagName());
        this.xmlSave(elmt, context, force);
        State state = force == null ? this._state : force;
        if (state == State.STRUCTURE || isroot || elmt.hasAttribute("id") && (elmt.getAttributes().getLength() > 1 || elmt.hasChildNodes())) {
            parent.appendChild(elmt);
            return elmt;
        }
        if (elmt.hasChildNodes()) {
            Node node;
            while ((node = elmt.getFirstChild()) != null) {
                Element elmt2;
                if (node.getNodeType() != 1 || !(elmt2 = (Element)node).hasAttribute("id")) continue;
                elmt.removeChild(elmt2);
                parent.appendChild(elmt2);
            }
        }
        return null;
    }

    public final Element xmlSave(Element elmt, String context, State force) {
        if (elmt == null) {
            return null;
        }
        this.xmlPreSaveCallback(elmt, force);
        State state = force == null ? this._state : force;
        if (!this.save && state != State.STRUCTURE) {
            return null;
        }
        if (!this.hasContext(context)) {
            return null;
        }
        switch (state) {
            case STRUCTURE: 
            case NORMAL: {
                this.xmlSaveAttrs(elmt);
                this.xmlHolderSave(elmt);
                break;
            }
            case STARRED: {
                if (this._clData._stars.length == 0 && !this.hasChildren() && this._xmlHolder == null) break;
                this.xmlSaveStarAttrs(elmt);
                this.xmlHolderSave(elmt);
            }
        }
        if (this.hasChildren()) {
            if (state == State.STRUCTURE) {
                force = State.STRUCTURE;
            }
            for (XmlUnit child : this._children) {
                child.xmlSaveCreatingNode(elmt, context, force);
            }
        }
        this.xmlPostSaveCallback(elmt, state);
        return elmt;
    }

    public final Element xmlSave(String filename, String context) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        return this.xmlSave(filename, context, null);
    }

    public final Element xmlSave(String filename, String context, State force) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        Document doc = XmlUtils.getInstance().getDefaultBuilder().newDocument();
        Element unit = this.xmlSaveCreatingNode(doc, context, force);
        XmlUtils.saveFile(filename, doc);
        return unit;
    }

    public final Element xmlSave(Directory dir, Enum file, String context) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        return this.xmlSave(dir, file, context, null);
    }

    public final Element xmlSave(Directory dir, Enum file, String context, State force) throws FileNotFoundException, TransformerConfigurationException, TransformerException {
        if (dir.isResource()) {
            this.getLogger().severe("xmlSave to a read-only resource at " + dir.getPath(file));
            return null;
        }
        return this.xmlSave(dir.getPath(file), context, force);
    }

    protected void xmlPreSaveCallback(Node elmt, State force) {
    }

    protected void xmlPostSaveCallback(Node elmt, State state) {
    }

    protected void structure(Element elmt) {
        if (elmt != null) {
            this.addAllChildren(elmt);
        }
    }

    protected void xmlLoadChildren(Element elmt, String context, State force) {
        if (elmt == null) {
            return;
        }
        NodeList children = elmt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XmlUnit unit;
            Element child;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(child = (Element)node).hasAttribute("id") || (unit = this.getChildByIdRecursive(child.getAttribute("id"))) == null) continue;
            unit.xmlLoad(child, context, force);
        }
    }

    public void addAllChildren(Node elmt) {
        if (elmt == null) {
            return;
        }
        NodeList children = elmt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String tagname = child.getTagName();
            if (tagname.indexOf(46) < 0) {
                if (tagname.equals(XMLHOLDER_TAGNAME)) continue;
                tagname = PACKAGE + tagname;
            }
            try {
                Class<?> c = this.getClass().getClassLoader().loadClass(tagname);
                this.xmlCreateAndAddChild(child, c);
                continue;
            }
            catch (ClassNotFoundException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    protected void markStructured() {
        this.markStructured(true);
    }

    protected void markStructured(boolean doChildren) {
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                child.markStructured();
            }
        }
        this._structured = true;
        this.setState(this.xmlStateCallback());
    }

    private void xmlLoadAttr(Element unit, Field f) throws IllegalAccessException {
        String name = f.getName();
        if (unit.hasAttribute(name)) {
            Class<?> c = f.getType();
            String val = unit.getAttribute(name);
            if (c == String.class) {
                f.set(this, val);
            } else if (c == Integer.TYPE) {
                f.setInt(this, Integer.parseInt(val));
            } else if (c == Boolean.TYPE) {
                f.setBoolean(this, Boolean.parseBoolean(val));
            } else if (c.getSuperclass() == Enum.class) {
                val = val.toUpperCase();
                f.set(this, Enum.valueOf(c, val));
            } else if (c == Byte.TYPE) {
                f.setByte(this, Byte.parseByte(val));
            } else if (c == Character.TYPE) {
                if (val.length() > 0) {
                    f.setChar(this, val.charAt(0));
                } else {
                    f.setChar(this, '\u0000');
                }
            } else if (c == Short.TYPE) {
                f.setShort(this, Short.parseShort(val));
            } else if (c == Long.TYPE) {
                f.setLong(this, Long.parseLong(val));
            } else if (c == Float.TYPE) {
                f.setFloat(this, Float.parseFloat(val));
            } else if (c == Double.TYPE) {
                f.setDouble(this, Double.parseDouble(val));
            } else if (c == Dimension.class) {
                f.set(this, this.parseDimension(val));
            } else if (c == Color.class) {
                Color color = null;
                String[] chan = val.split(DEFAULT_SEPARATOR);
                if (chan.length >= 4) {
                    int r = Integer.parseInt(chan[0]);
                    int g = Integer.parseInt(chan[1]);
                    int b = Integer.parseInt(chan[2]);
                    int a = Integer.parseInt(chan[3]);
                    color = new Color(r, g, b, a);
                } else if (chan.length >= 3) {
                    int r = Integer.parseInt(chan[0]);
                    int g = Integer.parseInt(chan[1]);
                    int b = Integer.parseInt(chan[2]);
                    color = new Color(r, g, b);
                } else {
                    long argb = Long.parseLong(val, 16);
                    if (argb > Integer.MAX_VALUE) {
                        long offset = 0L;
                        argb -= offset;
                    }
                    color = new Color((int)argb, true);
                }
                f.set(this, color);
            } else if (c.isArray()) {
                String[] tokens = val.split(DEFAULT_SEPARATOR);
                c = c.getComponentType();
                Object array = Array.newInstance(c, tokens.length);
                for (int i = 0; i < tokens.length; ++i) {
                    try {
                        if (c == Integer.class) {
                            Array.setInt(array, i, Integer.parseInt(tokens[i]));
                            continue;
                        }
                        if (c == Short.class) {
                            Array.setShort(array, i, Short.parseShort(tokens[i]));
                            continue;
                        }
                        if (c == Boolean.class) {
                            Array.setBoolean(array, i, Boolean.parseBoolean(tokens[i]));
                            continue;
                        }
                        if (c == Byte.class) {
                            Array.setByte(array, i, Byte.parseByte(tokens[i]));
                            continue;
                        }
                        if (c == Character.class) {
                            Array.setChar(array, i, tokens[i].toCharArray()[0]);
                            continue;
                        }
                        if (c == Float.class) {
                            Array.setFloat(array, i, Float.parseFloat(tokens[i]));
                            continue;
                        }
                        if (c == Double.class) {
                            Array.setDouble(array, i, Double.parseDouble(tokens[i]));
                            continue;
                        }
                        Array.set(array, i, tokens[i]);
                        continue;
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                f.set(this, array);
            }
        }
    }

    private Dimension parseDimension(String size) {
        if (size == null) {
            return null;
        }
        String[] tmp = size.split(DEFAULT_SEPARATOR);
        if (tmp.length == 2) {
            try {
                int w = Integer.parseInt(tmp[0].trim());
                int h = Integer.parseInt(tmp[1].trim());
                return new Dimension(w, h);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.SEVERE, t.getMessage(), t);
            }
        } else {
            this.getLogger().warning(this.getExplicitName() + " has wrong size definition: " + size);
        }
        return null;
    }

    private void xmlSaveAttr(Element unit, Field f) throws IllegalAccessException {
        String val = null;
        String name = f.getName();
        Class<?> c = f.getType();
        if (c == String.class) {
            val = (String)f.get(this);
        } else if (c == Integer.TYPE) {
            val = String.valueOf(f.getInt(this));
        } else if (c == Boolean.TYPE) {
            val = String.valueOf(f.getBoolean(this));
        } else if (c.getSuperclass() == Enum.class) {
            Enum enm = (Enum)f.get(this);
            if (enm != null) {
                val = enm.name();
            }
        } else if (c == Byte.TYPE) {
            val = String.valueOf(f.getByte(this));
        } else if (c == Character.TYPE) {
            val = String.valueOf(f.getChar(this));
        } else if (c == Short.TYPE) {
            val = String.valueOf(f.getShort(this));
        } else if (c == Long.TYPE) {
            val = String.valueOf(f.getLong(this));
        } else if (c == Float.TYPE) {
            val = String.valueOf(f.getFloat(this));
        } else if (c == Double.TYPE) {
            val = String.valueOf(f.getDouble(this));
        } else if (c == Dimension.class) {
            Dimension dim = (Dimension)f.get(this);
            if (dim != null) {
                val = String.format("%d%s%d", dim.width, DEFAULT_SEPARATOR, dim.height);
            }
        } else if (c == Color.class) {
            Color color = (Color)f.get(this);
            if (color != null) {
                val = String.format("%x", color.getRGB());
            }
        } else if (c.isArray()) {
            Object array = f.get(this);
            if (array != null) {
                int length = Array.getLength(array);
                boolean first = true;
                if (length > 0) {
                    val = "";
                    for (int i = 0; i < length; ++i) {
                        Object obj = Array.get(array, i);
                        if (!first) {
                            val = val + DEFAULT_SEPARATOR;
                        } else {
                            first = false;
                        }
                        val = val + obj.toString();
                    }
                }
            }
        } else {
            Object obj = f.get(this);
            if (obj != null) {
                val = obj.toString();
            }
        }
        if (val != null) {
            unit.setAttribute(name, val);
        } else {
            unit.removeAttribute(name);
        }
    }

    private void xmlLoadAttrs(Element unit) {
        for (Field f : this._clData._fields) {
            try {
                this.xmlLoadAttr(unit, f);
            }
            catch (IllegalAccessException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void xmlSaveAttrs(Element unit) {
        for (Field f : this._clData._fields) {
            try {
                this.xmlSaveAttr(unit, f);
            }
            catch (IllegalAccessException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void xmlLoadStarAttrs(Element unit) {
        for (Field f : this._clData._stars) {
            try {
                this.xmlLoadAttr(unit, f);
            }
            catch (IllegalAccessException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void xmlSaveStarAttrs(Element unit) {
        for (Field f : this._clData._stars) {
            try {
                this.xmlSaveAttr(unit, f);
            }
            catch (IllegalAccessException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void createXmlHolder() {
        if (this._xmlHolder == null) {
            this._xmlHolder = new HashMap();
        }
    }

    public Node xmlSaveLocalCopy(XmlUnit unit, String context, State force) {
        if (!unit.hasId()) {
            this.getLogger().warning(String.format("Attempting to save a local copy of object %s which had no id.", unit.getClass().getName()));
            return null;
        }
        if (this._xmlHolder == null) {
            this.createXmlHolder();
        }
        Document doc = XmlUtils.getInstance().getDefaultBuilder().newDocument();
        Element elmt = unit.xmlSaveCreatingNode(doc, context, force);
        this._xmlHolder.put(unit.getId(), elmt);
        return elmt;
    }

    public Node xmlLoadLocalCopy(XmlUnit unit, String context, State force) {
        if (!unit.hasId()) {
            this.getLogger().warning(String.format("Attempting to load a local copy of object %s which had no id.", unit.getClass().getName()));
            return null;
        }
        if (this._xmlHolder != null) {
            Element elmt = this._xmlHolder.get(unit.getId());
            if (elmt != null) {
                unit.xmlLoad(elmt, context, force);
            }
            return elmt;
        }
        return null;
    }

    public String[] xmlGetLocalCopiesIds() {
        if (this._xmlHolder == null) {
            return null;
        }
        return this._xmlHolder.keySet().toArray(new String[this._xmlHolder.keySet().size()]);
    }

    public Element xmlRemoveLocalCopy(String id) {
        if (this._xmlHolder == null) {
            return null;
        }
        return this._xmlHolder.remove(id);
    }

    private void xmlHolderLoad(Element elmt) {
        Element holder = XmlUtils.getChildByTagname(elmt, XMLHOLDER_TAGNAME);
        if (holder == null) {
            return;
        }
        if (this._xmlHolder == null) {
            this.createXmlHolder();
        }
        this._xmlHolder.clear();
        NodeList children = holder.getChildNodes();
        if (children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node tmp = children.item(i);
                if (tmp.getNodeType() != 1) continue;
                Element child = (Element)tmp;
                if (child.hasAttribute("id")) {
                    this._xmlHolder.put(child.getAttribute("id"), child);
                    continue;
                }
                this.getLogger().warning(String.format("Loading element '%s' from xmlHolder, that has no id.", elmt.getTagName()));
            }
        }
    }

    private void xmlHolderSave(Element unit) {
        if (this._xmlHolder == null) {
            return;
        }
        Element holder = XmlUtils.getChildByTagname(unit, XMLHOLDER_TAGNAME);
        if (holder == null) {
            holder = XmlUtils.addChildByTagname(unit, XMLHOLDER_TAGNAME);
        }
        for (Element elmt : this._xmlHolder.values()) {
            Node copy = holder.getOwnerDocument().importNode(elmt, true);
            holder.appendChild(copy);
        }
    }

    public void start(boolean doChildren) {
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                child.start(true);
            }
        }
        if (this.start != null && !this.start.isEmpty()) {
            try {
                Method method = this.getClass().getMethod(this.start, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void stop(boolean doChildren) {
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                child.stop(true);
            }
        }
        if (this.stop != null && !this.stop.isEmpty()) {
            try {
                Method method = this.getClass().getMethod(this.stop, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public int getIntFieldValue(Enum enm) {
        return ((IntFieldInterface)((Object)this.getBoundUnit(enm))).getIntValue();
    }

    public void setIntFieldValue(Enum enm, int val) {
        IntFieldInterface field = (IntFieldInterface)((Object)this.getBoundUnit(enm));
        field.setIntValue(val);
    }

    public long getLongFieldValue(Enum enm) {
        return ((LongFieldInterface)((Object)this.getBoundUnit(enm))).getLongValue();
    }

    public void setLongFieldValue(Enum enm, long val) {
        LongFieldInterface field = (LongFieldInterface)((Object)this.getBoundUnit(enm));
        field.setLongValue(val);
    }

    public float getFloatFieldValue(Enum enm) {
        return ((FloatFieldInterface)((Object)this.getBoundUnit(enm))).getFloatValue();
    }

    public void setFloatFieldValue(Enum enm, float val) {
        FloatFieldInterface field = (FloatFieldInterface)((Object)this.getBoundUnit(enm));
        field.setFloatValue(val);
    }

    public Double getDoubleFieldValue(Enum enm) {
        return ((DoubleFieldInterface)((Object)this.getBoundUnit(enm))).getDoubleValue();
    }

    public void setDoubleFieldValue(Enum enm, double val) {
        DoubleFieldInterface field = (DoubleFieldInterface)((Object)this.getBoundUnit(enm));
        field.setDoubleValue(val);
    }

    public String getStringFieldValue(Enum enm) {
        return ((StringFieldInterface)((Object)this.getBoundUnit(enm))).getStringValue();
    }

    public void setStringFieldValue(Enum enm, String val) {
        StringFieldInterface field = (StringFieldInterface)((Object)this.getBoundUnit(enm));
        field.setStringValue(val);
    }

    public boolean getBooleanFieldValue(Enum enm) {
        return ((BooleanFieldInterface)((Object)this.getBoundUnit(enm))).getBooleanValue();
    }

    public void setBooleanFieldValue(Enum enm, boolean val) {
        BooleanFieldInterface field = (BooleanFieldInterface)((Object)this.getBoundUnit(enm));
        field.setBooleanValue(val);
    }

    public Date getDateFieldValue(Enum enm) {
        return ((DateFieldInterface)((Object)this.getBoundUnit(enm))).getDateValue();
    }

    public void setDateFieldValue(Enum enm, Date val) {
        DateFieldInterface field = (DateFieldInterface)((Object)this.getBoundUnit(enm));
        field.setDateValue(val);
    }

    public int getComponentIntFieldValue(Enum enm) {
        return ((IntFieldInterface)((Object)this.getBoundUnit(enm))).getComponentIntValue();
    }

    public void setComponentIntFieldValue(Enum enm, int val) {
        IntFieldInterface field = (IntFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentIntValue(val);
    }

    public long getComponentLongFieldValue(Enum enm) {
        return ((LongFieldInterface)((Object)this.getBoundUnit(enm))).getComponentLongValue();
    }

    public void setComponentLongFieldValue(Enum enm, long val) {
        LongFieldInterface field = (LongFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentLongValue(val);
    }

    public float getComponentFloatFieldValue(Enum enm) {
        return ((FloatFieldInterface)((Object)this.getBoundUnit(enm))).getComponentFloatValue();
    }

    public void setComponentFloatFieldValue(Enum enm, float val) {
        FloatFieldInterface field = (FloatFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentFloatValue(val);
    }

    public Double getComponentDoubleFieldValue(Enum enm) {
        return ((DoubleFieldInterface)((Object)this.getBoundUnit(enm))).getComponentDoubleValue();
    }

    public void setComponentDoubleFieldValue(Enum enm, double val) {
        DoubleFieldInterface field = (DoubleFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentDoubleValue(val);
    }

    public String getComponentStringFieldValue(Enum enm) {
        return ((StringFieldInterface)((Object)this.getBoundUnit(enm))).getComponentStringValue();
    }

    public void setComponentStringFieldValue(Enum enm, String val) {
        StringFieldInterface field = (StringFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentStringValue(val);
    }

    public boolean getComponentBooleanFieldValue(Enum enm) {
        return ((BooleanFieldInterface)((Object)this.getBoundUnit(enm))).getComponentBooleanValue();
    }

    public void setComponentBooleanFieldValue(Enum enm, boolean val) {
        BooleanFieldInterface field = (BooleanFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentBooleanValue(val);
    }

    public Date getComponentDateFieldValue(Enum enm) {
        return ((DateFieldInterface)((Object)this.getBoundUnit(enm))).getComponentDateValue();
    }

    public void setComponentDateFieldValue(Enum enm, Date val) {
        DateFieldInterface field = (DateFieldInterface)((Object)this.getBoundUnit(enm));
        field.setComponentDateValue(val);
    }

    static {
        String pkgname = XmlUnit.class.getName();
        int last = pkgname.lastIndexOf(46);
        PACKAGE = pkgname.substring(0, last + 1);
        XMLHOLDER_TAGNAME = "XmlHolder";
        DEFAULT_CONTEXT = "default";
        DEFAULT_SEPARATOR = ";";
        CLASS_DATA = new HashMap(32);
    }

    public static enum State {
        STRUCTURE,
        NORMAL,
        STARRED;

    }

    static class ClassData {
        Field _id;
        Field[] _fields;
        Field[] _stars;
        Logger _log;

        public ClassData(Class c) {
            Class s = c;
            ArrayList<Field> fields = new ArrayList<Field>(32);
            ArrayList<Field> stars = new ArrayList<Field>(16);
            while (true) {
                for (Field f : s.getDeclaredFields()) {
                    if (s == c || !Modifier.isPrivate(f.getModifiers())) {
                        if (f.isAnnotationPresent(Serial.class)) {
                            fields.add(f);
                        } else if (f.isAnnotationPresent(SerialStar.class)) {
                            fields.add(f);
                            stars.add(f);
                        }
                    }
                    if (!"id".equals(f.getName())) continue;
                    this._id = f;
                }
                if (s.equals(XmlUnit.class)) break;
                s = s.getSuperclass();
            }
            this._fields = fields.toArray(new Field[fields.size()]);
            this._stars = stars.toArray(new Field[stars.size()]);
            this._log = Logger.getLogger(c.getSimpleName());
        }

        private static Field[] getSerialFields(Class c) {
            Class s = c;
            ArrayList<Field> fields = new ArrayList<Field>(32);
            while (true) {
                for (Field f : s.getDeclaredFields()) {
                    if (s != c && Modifier.isPrivate(f.getModifiers()) || !f.isAnnotationPresent(Serial.class)) continue;
                    fields.add(f);
                }
                if (s.equals(XmlUnit.class)) break;
                s = s.getSuperclass();
            }
            return fields.toArray(new Field[fields.size()]);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface SerialStar {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Serial {
    }
}

