/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Cursor;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.Zone;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.w3c.dom.Node;

public abstract class XmlComponentUnit<U extends XmlUnit, C extends Component>
extends XmlUnit<U> {
    @XmlUnit.Serial
    public Color bgColor;
    @XmlUnit.Serial
    public Color fgColor;
    @XmlUnit.Serial
    public Cursor cursor;
    @XmlUnit.Serial
    public String font;
    @XmlUnit.Serial
    public String locale;
    @XmlUnit.Serial
    public boolean enabled = true;
    @XmlUnit.Serial
    public boolean ignoreRepaint = false;
    @XmlUnit.Serial
    public String location;
    @XmlUnit.Serial
    public boolean fill = false;
    @XmlUnit.Serial
    public Dimension preferredSize;
    @XmlUnit.Serial
    public Dimension fixedSize;
    @XmlUnit.Serial
    public Dimension minimumSize;
    @XmlUnit.Serial
    public Dimension maximumSize;
    @XmlUnit.Serial
    public Zone.Zones zone;
    private C _comp;
    boolean _created = false;
    @XmlUnit.Serial
    public boolean focusable = true;
    @XmlUnit.Serial
    public boolean commitOnNotify = true;

    public boolean hasListener() {
        return this.getListener() != null;
    }

    public EnumListener getListener() {
        if (this._eb != null && this._ebEnum != null) {
            return this._eb.getListener();
        }
        return null;
    }

    public void notifyListener(Object src) {
        if (this._eb != null && this._ebEnum != null) {
            EnumListener listener;
            if (this.commitOnNotify) {
                this.commitComponent();
            }
            if ((listener = this._eb.getListener()) != null) {
                listener.actionPerformed(this._ebEnum, this, src);
                return;
            }
        }
        this.getLogger().info("Could not notify listener of event at " + this.getExplicitName());
    }

    public Component getDisplayComponent() {
        return this.getComponent();
    }

    public C getComponent() {
        if (!this.isStructured()) {
            this.getLogger().info("getComponent() but unit is not structured. calling markStructured().");
            this.markStructured();
        }
        if (this._comp == null) {
            this._comp = this.createComponent();
            this._created = true;
            this.structureComponent();
        }
        return this._comp;
    }

    public void deleteComponent() {
        this.deleteComponent(true);
    }

    public void deleteComponent(boolean doChildren) {
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlComponentUnit.class.isInstance(child)) continue;
                ((XmlComponentUnit)child).deleteComponent(doChildren);
            }
        }
        this._comp = null;
    }

    protected abstract C createComponent();

    public boolean hasComponent() {
        return this._comp != null;
    }

    public void structureComponent() {
        if (this._comp != null) {
            this.structureComponentCustom(this._comp);
            if (JComponent.class.isInstance(this._comp)) {
                ((JComponent)this._comp).revalidate();
            } else {
                ((Component)this._comp).invalidate();
                ((Component)this._comp).validate();
            }
            this.updateComponent(false);
            ((Component)this._comp).repaint();
        }
    }

    protected abstract void structureComponentCustom(C var1);

    public void updateComponent(boolean doChildren) {
        if (this._comp != null) {
            this.updateComponentCustom(this._comp);
            this.updateComponentCommonFields(this._comp);
        }
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlComponentUnit.class.isInstance(child)) continue;
                ((XmlComponentUnit)child).updateComponent();
            }
        }
        if (this._comp != null) {
            ((Component)this._comp).validate();
        }
    }

    public final void updateComponent() {
        this.updateComponent(true);
    }

    protected abstract void updateComponentCustom(C var1);

    private void updateComponentCommonFields(C comp) {
        String[] tmp;
        ((Component)comp).setEnabled(this.enabled);
        ((Component)comp).setIgnoreRepaint(this.ignoreRepaint);
        if (this.fgColor != null) {
            ((Component)comp).setForeground(this.fgColor);
        }
        if (this.bgColor != null) {
            ((Component)comp).setBackground(this.bgColor);
        }
        if (this.cursor != null) {
            ((Component)comp).setCursor(this.cursor.getCursor());
        }
        if (this.font != null) {
            tmp = this.font.split(",");
            if (tmp.length == 3) {
                String name = tmp[0];
                try {
                    int style = Integer.parseInt(tmp[1]);
                    int size = Integer.parseInt(tmp[2]);
                    ((Component)comp).setFont(new Font(name, style, size));
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, t.getMessage(), t);
                }
            } else {
                this.getLogger().warning(this.getExplicitName() + " has wrong definition for font: " + this.font);
            }
        }
        if (this.locale != null) {
            ((Component)comp).setLocale(new Locale(this.locale));
        }
        if (this.location != null) {
            tmp = this.location.split(",");
            if (tmp.length == 2) {
                try {
                    int x = Integer.parseInt(tmp[0]);
                    int y = Integer.parseInt(tmp[1]);
                    ((Component)comp).setLocation(x, y);
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, t.getMessage(), t);
                }
            } else {
                this.getLogger().warning(this.getExplicitName() + " has wrong definition for location: " + this.location);
            }
        }
        if (this.fixedSize != null) {
            ((Component)comp).setMinimumSize(this.fixedSize);
            ((Component)comp).setMaximumSize(this.fixedSize);
            ((Component)comp).setPreferredSize(this.fixedSize);
        } else {
            if (this.preferredSize != null) {
                ((Component)comp).setPreferredSize(this.mergeSizes(((Component)comp).getPreferredSize(), this.preferredSize));
            }
            if (this.minimumSize != null) {
                ((Component)comp).setMinimumSize(this.mergeSizes(((Component)comp).getMinimumSize(), this.minimumSize));
            }
            if (this.maximumSize != null) {
                ((Component)comp).setMaximumSize(this.mergeSizes(((Component)comp).getMaximumSize(), this.maximumSize));
            }
        }
        if (!this.focusable) {
            ((Component)comp).setFocusable(this.focusable);
        }
    }

    private Dimension mergeSizes(Dimension base, Dimension set) {
        if (base == null) {
            return set;
        }
        if (set == null) {
            return base;
        }
        Dimension size = new Dimension(base);
        if (set.width >= 0) {
            size.width = set.width;
        }
        if (set.height >= 0) {
            size.height = set.height;
        }
        return size;
    }

    public void commitComponent(boolean doChildren) {
        if (doChildren && this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlComponentUnit.class.isInstance(child)) continue;
                ((XmlComponentUnit)child).commitComponent();
            }
        }
        if (this._comp != null) {
            this.commitComponentCustom(this._comp);
        }
    }

    public final void commitComponent() {
        this.commitComponent(true);
    }

    protected abstract void commitComponentCustom(C var1);

    protected void addAllChildrenToComponent(C comp) {
        if (Container.class.isInstance(comp)) {
            Container cont = (Container)comp;
            if (this.hasChildren()) {
                for (XmlUnit child : this.getChildren()) {
                    if (!XmlComponentUnit.class.isInstance(child)) continue;
                    XmlComponentUnit comp2 = (XmlComponentUnit)child;
                    cont.add(comp2.getDisplayComponent());
                }
            }
        }
    }

    public XmlComponentUnit getBoundComponentUnit(Enum enm) {
        if (this._eb != null) {
            return (XmlComponentUnit)this._eb.getUnit(enm);
        }
        return null;
    }

    public XmlJComponentUnit getBoundJComponentUnit(Enum enm) {
        if (this._eb != null) {
            return (XmlJComponentUnit)this._eb.getUnit(enm);
        }
        return null;
    }

    @Override
    protected final void xmlPostLoadCallback(Node unit, XmlUnit.State state) {
        if (this._state == XmlUnit.State.STRUCTURE) {
            this.structureComponent();
        } else {
            this.updateComponent(false);
        }
        this.xmlPostLoadComponentCallback(unit, state);
    }

    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
    }

    @Override
    protected final void xmlPreSaveCallback(Node parent, XmlUnit.State state) {
        this.commitComponent(false);
        this.xmlPreSaveComponentCallback(parent, state);
    }

    protected void xmlPreSaveComponentCallback(Node parent, XmlUnit.State state) {
    }
}

