/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;

public class XmlAttrGroup {
    private HashMap<Enum, String> m_values;
    private ArrayList<Enum> m_attrs;

    public XmlAttrGroup(ArrayList<Enum> attrs) {
        this.m_attrs = attrs;
        this.m_values = new HashMap();
    }

    public String getAttrVal(Enum attr) {
        return this.m_values.get(attr);
    }

    public void setAttrVal(Enum attr, String value) {
        this.m_values.put(attr, value);
    }

    public void xmlLoad(Element xmlNode) {
        for (Enum attr : this.m_attrs) {
            this.xmlLoadAttr(xmlNode, attr);
        }
    }

    public void xmlSave(Element xmlNode) {
        for (Enum attr : this.m_attrs) {
            this.xmlSaveAttr(xmlNode, attr);
        }
    }

    public void xmlLoadAttr(Element xmlNode, Enum attr) {
        if (xmlNode.hasAttribute(attr.name())) {
            this.setAttrVal(attr, xmlNode.getAttribute(attr.name()));
        }
    }

    public void xmlSaveAttr(Element xmlNode, Enum attr) {
        String val = this.getAttrVal(attr);
        if (val != null) {
            xmlNode.setAttribute(attr.name(), val);
        } else {
            xmlNode.removeAttribute(attr.name());
        }
    }
}

