/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.Resource;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.Table;
import com.edgytech.swingfast.UndoRegisterListener;
import com.edgytech.swingfast.UndoStep;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UndoRegister<T extends XmlUnit>
extends XmlComponentUnit<XmlUnit, JDialog>
implements Showable,
MouseListener,
EnumListener,
ActionListener {
    @XmlUnit.Serial
    public int maxEntries;
    private List<AbstractButton> undoButtons;
    private List<AbstractButton> redoButtons;
    private static final Color LIGHT_BLUE = new Color(200, 255, 200);
    private static final Color LIGHT_GRAY = new Color(220, 220, 220);
    LinkedList<UndoStep> _steps = new LinkedList();
    int _current = -1;
    Frame _owner;
    RegisterTableModel _tableModel = new RegisterTableModel();
    JTable _table;
    UndoRegisterListener _listener;

    public UndoRegister() {
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.UndoRegister, null);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.setEnumBinding(Binding.values(), this);
        this.undoButtons = new ArrayList<AbstractButton>();
        this.redoButtons = new ArrayList<AbstractButton>();
    }

    public UndoRegister(String id, Frame owner, int maxEntries) {
        this();
        this.setId(id);
        this.setOwner(owner);
        this.maxEntries = maxEntries;
    }

    public void setOwner(Frame owner) {
        this._owner = owner;
    }

    public void setListener(UndoRegisterListener listener) {
        this._listener = listener;
    }

    public void addStep(T unit, Element node, String label) {
        UndoStep<T> step = new UndoStep<T>(unit, node, label);
        this.addStep(step);
    }

    public void addStep(UndoStep step) {
        ++this._current;
        if (this._current >= this._steps.size()) {
            this._steps.add(step);
        } else {
            this._steps.set(this._current, step);
            this.clearRedoSteps();
        }
        while (this._steps.size() > this.maxEntries) {
            this.removeStep(0);
        }
        this._tableModel.fireTableDataChanged();
        this.updateButtons();
        this._listener.addedStep(step);
    }

    private UndoStep removeStep(int index) {
        UndoStep step = this._steps.remove(index);
        if (step != null) {
            if (this._current >= index && this._current > 0) {
                --this._current;
            }
            this._listener.removedStep(step);
        }
        return step;
    }

    public void redo() {
        if (this._current == this._steps.size() - 1) {
            return;
        }
        this.restoreStep(this._current + 1);
    }

    public void undo() {
        if (this._current <= 0) {
            return;
        }
        this.restoreStep(this._current - 1);
    }

    public boolean canUndo() {
        return this._current > 0;
    }

    public boolean canRedo() {
        return this._current < this._steps.size() - 1;
    }

    public void restoreStep(int id) {
        if (this._current == id) {
            return;
        }
        this._current = id;
        UndoStep step = this._steps.get(this._current);
        ((XmlUnit)step.getUnit()).xmlLoad(step.getXmlElement(), null);
        this._tableModel.fireTableDataChanged();
        this.updateButtons();
        this._listener.restoredStep(step);
    }

    public int getStepCount() {
        return this._steps.size();
    }

    public void clearUndoSteps() {
        while (this._current > 0) {
            this.removeStep(0);
        }
        this._tableModel.fireTableDataChanged();
    }

    public void clearRedoSteps() {
        while (this._steps.size() - 1 > this._current) {
            this.removeStep(this._steps.size() - 1);
        }
        this._tableModel.fireTableDataChanged();
    }

    public void clear() {
        this._steps.clear();
        this._current = -1;
        this._tableModel.fireTableDataChanged();
        this.updateButtons();
        this._listener.cleared();
    }

    @Override
    protected JDialog createComponent() {
        JDialog dia = new JDialog(this._owner, this.getLabelToDisplay());
        dia.setModal(true);
        dia.setDefaultCloseOperation(1);
        return dia;
    }

    @Override
    protected void structureComponentCustom(JDialog old) {
        this.addAllChildrenToComponent(old);
        Table table = (Table)this.getBoundUnit(Binding.table);
        this._table = (JTable)table.getComponent();
        this._table.setModel(this._tableModel);
        this._table.setDefaultRenderer(JButton.class, new RegisterCellRenderer());
        this._table.setDefaultRenderer(JLabel.class, new RegisterCellRenderer());
        this._table.addMouseListener(this);
        this._table.setSelectionMode(0);
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        old.pack();
        old.setSize(400, 400);
    }

    @Override
    protected void commitComponentCustom(JDialog comp) {
    }

    @Override
    public boolean show() {
        ((JDialog)this.getComponent()).setVisible(true);
        return true;
    }

    @Override
    public void hide() {
        ((JDialog)this.getComponent()).setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int index = this._table.getSelectedRow();
        if (index >= 0) {
            index = this._steps.size() - 1 - index;
            this.restoreStep(index);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(Enum enm, XmlComponentUnit unit, Object src) {
        Binding bdg = (Binding)enm;
        switch (bdg) {
            case clearUndos: {
                this.clearUndoSteps();
                break;
            }
            case clearRedos: {
                this.clearRedoSteps();
            }
        }
    }

    public void addUndoButton(AbstractButton undo) {
        if (undo != null) {
            this.undoButtons.add(undo);
            undo.addActionListener(this);
        }
    }

    public void addRedoButton(AbstractButton redo) {
        if (redo != null) {
            this.redoButtons.add(redo);
            redo.addActionListener(this);
        }
    }

    public void removeUndoButton(AbstractButton undo) {
        if (undo != null) {
            this.undoButtons.remove(undo);
            undo.removeActionListener(this);
        }
    }

    public void removeRedoButton(AbstractButton redo) {
        if (redo != null) {
            this.redoButtons.remove(redo);
            redo.removeActionListener(this);
        }
    }

    public void clearButtons() {
        for (AbstractButton button : this.undoButtons) {
            button.removeActionListener(this);
        }
        this.undoButtons.clear();
        for (AbstractButton button : this.redoButtons) {
            button.removeActionListener(this);
        }
        this.redoButtons.clear();
    }

    public void updateButtons() {
        for (AbstractButton undo : this.undoButtons) {
            undo.setEnabled(this.canUndo());
        }
        for (AbstractButton redo : this.redoButtons) {
            redo.setEnabled(this.canRedo());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.undoButtons.contains(e.getSource())) {
            this.undo();
        } else if (this.redoButtons.contains(e.getSource())) {
            this.redo();
        }
    }

    class RegisterCellRenderer
    implements TableCellRenderer {
        RegisterCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = (Component)value;
            int index = UndoRegister.this._steps.size() - 1 - UndoRegister.this._current;
            if (row < index) {
                comp.setBackground(Color.LIGHT_GRAY);
            } else {
                comp.setBackground(LIGHT_BLUE);
            }
            return comp;
        }
    }

    class RegisterTableModel
    extends AbstractTableModel {
        RegisterTableModel() {
        }

        @Override
        public int getRowCount() {
            return UndoRegister.this._steps.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UndoStep step = UndoRegister.this._steps.get(UndoRegister.this._steps.size() - 1 - rowIndex);
            JLabel label = new JLabel(step.getLabel());
            label.setOpaque(true);
            label.setHorizontalAlignment(0);
            return label;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public String getColumnName(int column) {
            return "Steps";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    static enum Binding {
        clearUndos,
        clearRedos,
        table;

    }
}

