/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.PopUpMenu;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.Tree;
import com.edgytech.swingfast.TreeNodeProvider;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Node;

public class TreeNodeLabel
extends XmlJComponentUnit<XmlUnit, JComponent>
implements TreeNodeProvider {
    @XmlUnit.Serial
    String popUpId;
    PopUpMenu popUpMenu;
    @XmlUnit.Serial
    public String icon;
    @XmlUnit.Serial
    public String iconGroup;
    DefaultMutableTreeNode _node = new DefaultMutableTreeNode(this);
    Tree _tree;
    protected boolean forced = false;

    public TreeNodeLabel() {
    }

    public TreeNodeLabel(String id, String label, String icon, String iconGroup) {
        this();
        this.id = id;
        this.label = label;
        this.icon = icon;
        this.iconGroup = iconGroup;
        this.markStructured();
    }

    @Override
    public PopUpMenu getPopUpMenu() {
        return this.popUpMenu;
    }

    public void setPopUpMenu(PopUpMenu popUpMenu) {
        this.popUpMenu = popUpMenu;
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
        if (state == XmlUnit.State.STRUCTURE) {
            this.popUpMenu = this.getFirstChildOfClass(PopUpMenu.class, this.popUpId);
            if (this.popUpMenu != null && "".equals(this.popUpMenu.getLabelToDisplay())) {
                this.popUpMenu.setLabel(this.getLabelToDisplay());
            }
        }
    }

    @Override
    protected JComponent createComponent() {
        return new JLabel(this.getTreeNode().toString());
    }

    @Override
    protected void structureComponentCustom(JComponent old) {
        if (this.forced) {
            return;
        }
        DefaultTreeModel model = this.getTree().getModel();
        DefaultMutableTreeNode node = this.getTreeNode();
        while (node.getChildCount() > 0) {
            model.removeNodeFromParent((MutableTreeNode)node.getChildAt(0));
        }
        try {
            if (this.hasChildren()) {
                int i = 0;
                for (XmlUnit child : this.getChildren()) {
                    if (child instanceof XmlComponentUnit) {
                        ((XmlComponentUnit)child).getComponent();
                    }
                    if (!(child instanceof TreeNodeProvider)) continue;
                    model.insertNodeInto(((TreeNodeLabel)child).getTreeNode(), this._node, i++);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    protected void updateComponentCustom(JComponent comp) {
        this._tree.getModel().nodeChanged(this._node);
    }

    @Override
    protected void commitComponentCustom(JComponent comp) {
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this._node;
    }

    public void forceTreeNode(DefaultMutableTreeNode node) {
        this._node = node;
        this.forced = true;
    }

    @Override
    public Icon getIcon() {
        return SwingFast.createIcon(this.icon, this.iconGroup);
    }

    public String toString() {
        return this.getLabelToDisplay();
    }

    @Override
    public XmlUnit addChild(XmlUnit child) {
        if (child instanceof TreeNodeProvider) {
            ((TreeNodeProvider)((Object)child)).setTree(this.getTree());
        }
        return super.addChild(child);
    }

    @Override
    public Tree getTree() {
        return this._tree;
    }

    @Override
    public void setTree(Tree tree) {
        this._tree = tree;
    }

    @Override
    public void handleNodeSelection() {
    }

    @Override
    public void handleWillExpand() {
    }

    @Override
    public void handleWillCollapse() {
    }
}

