/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.PopUpMenu;
import com.edgytech.swingfast.TreeNodeLabel;
import com.edgytech.swingfast.TreeNodeProvider;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Tree
extends TreeNodeLabel
implements TreeSelectionListener,
TreeExpansionListener,
TreeWillExpandListener {
    DefaultTreeModel _model;
    @XmlUnit.Serial
    Color selectColor;
    @XmlUnit.Serial
    Color selectTextColor;

    public Tree() {
        this._tree = this;
    }

    @Override
    protected JTree createComponent() {
        JTree tree = new JTree();
        tree.addMouseListener(new MyMouseAdapter());
        DefaultMutableTreeNode root = this.getTreeNode();
        this._model = new MyTreeModel(root);
        tree.setModel(this._model);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(this);
        tree.addTreeExpansionListener(this);
        tree.addTreeWillExpandListener(this);
        MyCellRenderer renderer = new MyCellRenderer();
        if (this.bgColor != null) {
            renderer.setBackground(this.bgColor);
            renderer.setBackgroundNonSelectionColor(this.bgColor);
        }
        if (this.selectColor != null) {
            renderer.setBorderSelectionColor(this.selectColor);
            renderer.setBackgroundSelectionColor(this.selectColor);
            renderer.setTextSelectionColor(this.selectTextColor);
        }
        if (this.fgColor != null) {
            renderer.setTextNonSelectionColor(this.fgColor);
        }
        tree.setCellRenderer(renderer);
        return tree;
    }

    public DefaultMutableTreeNode addTreeNodes(XmlUnit unit) {
        if (unit instanceof TreeNodeProvider) {
            return ((TreeNodeProvider)((Object)unit)).getTreeNode();
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(unit.getLabelToDisplay());
        if (unit.hasChildren()) {
            for (Object child : unit.getChildren()) {
                DefaultMutableTreeNode nchild = this.addTreeNodes((XmlUnit)child);
                node.add(nchild);
            }
        }
        return node;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = this.getSelectionNode();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof TreeNodeProvider) {
            ((TreeNodeProvider)nodeInfo).handleNodeSelection();
        } else {
            this.nodeWasSelected(nodeInfo);
        }
    }

    public DefaultMutableTreeNode getSelectionNode() {
        return (DefaultMutableTreeNode)((JTree)this.getComponent()).getLastSelectedPathComponent();
    }

    public TreePath getSelectionPath() {
        return ((JTree)this.getComponent()).getSelectionPath();
    }

    public int[] getSelectionRows() {
        return ((JTree)this.getComponent()).getSelectionRows();
    }

    public void nodeWasSelected(Object nodeInfo) {
    }

    public void nodeWillExpand(Object nodeInfo) {
    }

    public DefaultTreeModel getModel() {
        return this._model;
    }

    public void expandNode(TreeNodeProvider prov) {
        this.expandNode(prov.getTreeNode());
    }

    public void expandNode(MutableTreeNode node) {
        JTree tree = (JTree)this.getComponent();
        Object[] path = this.getModel().getPathToRoot(node);
        tree.expandPath(new TreePath(path));
    }

    public void collapseNode(TreeNodeProvider prov) {
        this.collapseNode(prov.getTreeNode());
    }

    public void collapseNode(MutableTreeNode node) {
        JTree tree = (JTree)this.getComponent();
        Object[] path = this.getModel().getPathToRoot(node);
        tree.collapsePath(new TreePath(path));
    }

    public void expandAll() {
        JTree tree = (JTree)this.getComponent();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public void collapseAll() {
        JTree tree = (JTree)this.getComponent();
        for (int i = tree.getRowCount() - 1; i >= 0; --i) {
            tree.collapseRow(i);
        }
    }

    public void selectNode(TreeNodeProvider prov) {
        this.selectNode(prov.getTreeNode());
    }

    public void selectNode(MutableTreeNode node) {
        JTree tree = (JTree)this.getComponent();
        Object[] path = this.getModel().getPathToRoot(node);
        tree.setSelectionPath(new TreePath(path));
    }

    public void nodeChanged(DefaultMutableTreeNode node) {
        this.getModel().nodeChanged(node);
    }

    public void nodeStructureChanged(DefaultMutableTreeNode node) {
        this.getModel().nodeStructureChanged(node);
    }

    public void showPopUpMenu(int x, int y) {
        TreeNodeProvider prov;
        PopUpMenu popup;
        DefaultMutableTreeNode node = this.getSelectionNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj instanceof TreeNodeProvider && (popup = (prov = (TreeNodeProvider)obj).getPopUpMenu()) != null) {
            popup.setSource(node);
            ((JPopupMenu)popup.getComponent()).show(this.getComponent(), x, y);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent tee) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent tee) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tee.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof TreeNodeProvider) {
            ((TreeNodeProvider)nodeInfo).handleWillExpand();
        } else {
            this.nodeWillExpand(nodeInfo);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
    }

    class MyCellRenderer
    extends DefaultTreeCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof TreeNodeProvider) {
                TreeNodeProvider prov = (TreeNodeProvider)obj;
                Icon ico = prov.getIcon();
                this.setIcon(ico);
                if (ico != null && tree.getRowHeight() < ico.getIconHeight()) {
                    tree.setRowHeight(ico.getIconHeight());
                }
            }
            return this;
        }
    }

    class MyTreeModel
    extends DefaultTreeModel {
        public MyTreeModel(TreeNode root) {
            super(root);
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        private void setSelectionPath(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getPathForLocation(x, y);
            if (path == null) {
                return;
            }
            tree.setSelectionPath(path);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setSelectionPath(e);
                Tree.this.showPopUpMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setSelectionPath(e);
                Tree.this.showPopUpMenu(e.getX(), e.getY());
            }
        }
    }
}

