/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.AppUtils;
import com.edgytech.swingfast.Button;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.EnumBinding;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.ToolBarSeparator;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import javax.swing.JToolBar;

public class ToolBar
extends XmlJComponentUnit<XmlUnit, JToolBar> {
    @XmlUnit.Serial
    Common.Axis axis = Common.Axis.X;
    @XmlUnit.Serial
    boolean floatable = false;
    @XmlUnit.Serial
    boolean borderPainted = true;
    @XmlUnit.Serial
    boolean rollover = false;

    public ToolBar() {
    }

    public ToolBar(String id, Enum[] bindings, EnumListener listener) {
        this();
        this.setId(id);
        this.setEnumBinding(new EnumBinding(bindings, listener));
    }

    public ToolBar(String id, Enum[] bindings, EnumListener listener, Common.Axis axis) {
        this(id, bindings, listener);
        this.axis = axis;
    }

    public void populateButtons() {
        EnumBinding bind = this.getEnumBinding();
        if (bind == null) {
            return;
        }
        Enum[] buttons = bind.getBindings();
        if (buttons == null) {
            return;
        }
        for (Enum enm : buttons) {
            String name = enm.name();
            Button button = new Button();
            button.setId(name);
            button.setLabel(AppUtils.capitalize(name));
            button.markStructured();
            this.addChild(button);
        }
        this.markStructured();
    }

    @Override
    protected JToolBar createComponent() {
        JToolBar bar = new JToolBar();
        int orient = this.axis == Common.Axis.X ? 0 : 1;
        bar.setOrientation(orient);
        bar.setFloatable(this.floatable);
        bar.setBorderPainted(this.borderPainted);
        bar.setRollover(this.rollover);
        bar.setFocusable(false);
        return bar;
    }

    @Override
    protected void structureComponentCustom(JToolBar old) {
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (ToolBarSeparator.class.isInstance(child)) {
                    ToolBarSeparator sep = (ToolBarSeparator)child;
                    if (sep.size != null) {
                        old.addSeparator(sep.size);
                        continue;
                    }
                    old.addSeparator();
                    continue;
                }
                if (!XmlComponentUnit.class.isInstance(child)) continue;
                XmlComponentUnit comp = (XmlComponentUnit)child;
                old.add(comp.getDisplayComponent());
            }
        }
    }

    @Override
    protected void updateComponentCustom(JToolBar old) {
    }

    @Override
    protected void commitComponentCustom(JToolBar comp) {
    }
}

