/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.TextBox;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class TextField
extends XmlUnitField<XmlUnit, TextBox>
implements StringFieldInterface,
FocusListener {
    @XmlUnit.Serial
    public int limit = -1;
    @XmlUnit.Serial
    public boolean nonEmpty;
    @XmlUnit.Serial
    public boolean editable;
    @XmlUnit.SerialStar
    public String value;

    public TextField() {
        this.columns = -1;
        this.nonEmpty = false;
        this.editable = true;
        this.value = "";
    }

    public TextField(String id, String label, String value) {
        this();
        this.id = id;
        this.label = label;
        this.value = value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public String getComponentStringValue() {
        return ((TextBox)this.getComponent()).getText();
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public void setComponentStringValue(String value) {
        ((TextBox)this.getComponent()).setText(value);
    }

    @Override
    protected boolean checkComponentCustom(TextBox comp) {
        String txt = this.getComponentStringValue().trim();
        if (this.nonEmpty && txt.isEmpty()) {
            this.setDisplayError("Field cannot be empty");
            return false;
        }
        return true;
    }

    @Override
    protected TextBox createComponent() {
        TextBox comp = new TextBox(this.value, this.columns <= 0 ? 20 : this.columns, this.limit < 0 ? 0 : this.limit);
        comp.addFocusListener(this);
        return comp;
    }

    @Override
    protected void structureComponentCustom(TextBox comp) {
    }

    @Override
    protected void updateComponentCustom(TextBox comp) {
        comp.setEditable(this.editable);
        comp.setText(this.value);
    }

    @Override
    protected void commitComponentCustom(TextBox comp) {
        this.value = comp.getText();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hasListener()) {
            this.notifyListener(this.getComponent());
        }
    }
}

