/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextArea
extends XmlUnitField<XmlUnit, JScrollPane>
implements StringFieldInterface,
FocusListener {
    @XmlUnit.SerialStar
    public String value;
    @XmlUnit.Serial
    public int rows;
    @XmlUnit.Serial
    public boolean editable;
    @XmlUnit.Serial
    public boolean lineWrap;
    @XmlUnit.Serial
    public boolean wrapStyleWord;
    @XmlUnit.Serial
    public boolean nonEmpty;
    JTextArea area;

    public TextArea() {
        this.value = "";
        this.editable = true;
        this.lineWrap = false;
        this.wrapStyleWord = false;
        this.rows = 3;
        this.nonEmpty = false;
    }

    public TextArea(String id, String label, String text) {
        this.setId(id);
        this.setLabel(label);
        this.value = text;
    }

    public TextArea(String id, String label, String text, int rows, int columns, boolean editable) {
        this.setId(id);
        this.setLabel(label);
        this.value = text;
        this.rows = rows;
        this.columns = columns;
        this.editable = editable;
    }

    @Override
    protected JScrollPane createComponent() {
        JScrollPane scroll = new JScrollPane();
        this.area = new JTextArea();
        this.area.setRows(this.rows);
        this.area.setColumns(this.columns <= 0 ? 20 : this.columns);
        this.area.addFocusListener(this);
        scroll.setViewportView(this.area);
        return scroll;
    }

    @Override
    protected void structureComponentCustom(JScrollPane comp) {
    }

    @Override
    protected void updateComponentCustom(JScrollPane comp) {
        this.area.setText(this.value);
        this.area.setEditable(this.editable);
        this.area.setLineWrap(this.lineWrap);
        this.area.setWrapStyleWord(this.wrapStyleWord);
        if (!this.editable) {
            this.area.setCaretPosition(0);
        }
    }

    @Override
    protected void commitComponentCustom(JScrollPane comp) {
        this.value = this.area.getText();
    }

    @Override
    protected boolean checkComponentCustom(JScrollPane comp) {
        String txt = this.getComponentStringValue().trim();
        if (this.nonEmpty && txt.isEmpty()) {
            this.setDisplayError("Field cannot be empty");
            return false;
        }
        return true;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public String getComponentStringValue() {
        return this.area.getText();
    }

    @Override
    public void setComponentStringValue(String value) {
        this.area.setText(value);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hasListener()) {
            this.notifyListener(this.getComponent());
        }
    }

    public JTextArea getTextArea() {
        return this.area;
    }
}

