/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.TabInterface;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TabbedDiv
extends XmlUnitField<XmlUnit, JTabbedPane> {
    @XmlUnit.Serial
    public boolean titled = false;
    @XmlUnit.Serial
    public Layout layout;

    public TabbedDiv() {
        this.field = false;
        this.layout = Layout.WRAP;
    }

    @Override
    protected JTabbedPane createComponent() {
        JTabbedPane comp = new JTabbedPane();
        if (this.titled) {
            comp.setBorder(BorderFactory.createTitledBorder(this.getLabelToDisplay()));
        }
        comp.setTabLayoutPolicy(this.layout.value);
        comp.setFocusTraversalKeysEnabled(false);
        comp.addMouseListener(new TabSelectionMouseHandler());
        return comp;
    }

    private static void setupTabTraversalKeys(JTabbedPane tabbedPane) {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke("ctrl TAB");
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(tabbedPane.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        tabbedPane.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(tabbedPane.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
        tabbedPane.setFocusTraversalKeys(1, backwardKeys);
        InputMap inputMap = tabbedPane.getInputMap(1);
        inputMap.put(ctrlTab, "navigateNext");
        inputMap.put(ctrlShiftTab, "navigatePrevious");
    }

    @Override
    protected boolean checkComponentCustom(JTabbedPane comp) {
        return true;
    }

    @Override
    protected void structureComponentCustom(JTabbedPane comp) {
        comp.removeAll();
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlComponentUnit.class.isInstance(child)) continue;
                this._addTab((XmlComponentUnit)child, false);
            }
        }
    }

    @Override
    protected void updateComponentCustom(JTabbedPane comp) {
    }

    @Override
    protected void commitComponentCustom(JTabbedPane comp) {
    }

    public int getSelectedIndex() {
        return ((JTabbedPane)this.getComponent()).getSelectedIndex();
    }

    public XmlUnit getSelectedUnit() {
        int selected = ((JTabbedPane)this.getComponent()).getSelectedIndex();
        if (selected < 0) {
            return null;
        }
        return (XmlUnit)this.getChildren().get(selected);
    }

    public void selectLastTab() {
        JTabbedPane pane = (JTabbedPane)this.getComponent();
        if (pane.getTabCount() == 0) {
            return;
        }
        pane.setSelectedIndex(pane.getTabCount() - 1);
    }

    public void selectFirstTab() {
        JTabbedPane pane = (JTabbedPane)this.getComponent();
        if (pane.getTabCount() == 0) {
            return;
        }
        pane.setSelectedIndex(0);
    }

    public void addTab(XmlComponentUnit child, boolean select) {
        this.addChild(child);
        this._addTab(child, select);
    }

    void _addTab(XmlComponentUnit child, boolean select) {
        JTabbedPane comp = (JTabbedPane)this.getComponent();
        if (child instanceof TabInterface) {
            comp.addTab(child.getLabelToDisplay(), (Component)child.getComponent());
            comp.setTabComponentAt(comp.getTabCount() - 1, ((TabInterface)((Object)child)).getTabComponent());
        } else {
            JPanel panel = new JPanel(new BorderLayout());
            if (this.bgColor != null) {
                panel.setBackground(this.bgColor);
            }
            panel.add((Component)child.getComponent(), "North");
            comp.addTab(child.getLabelToDisplay(), panel);
        }
        if (select) {
            this.selectLastTab();
        }
    }

    public void removeTab(XmlComponentUnit child) {
        this.removeChild(child);
        JTabbedPane pane = (JTabbedPane)this.getComponent();
        pane.remove((Component)child.getComponent());
    }

    public class TabSelectionMouseHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                JTabbedPane tabPane = (JTabbedPane)e.getSource();
                JPopupMenu menu = new JPopupMenu();
                int tabCount = tabPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    menu.add(new SelectTabAction(tabPane, i));
                }
                menu.show(tabPane, e.getX(), e.getY());
            }
        }
    }

    public class SelectTabAction
    extends AbstractAction {
        private JTabbedPane tabPane;
        private int index;

        public SelectTabAction(JTabbedPane tabPane, int index) {
            super(tabPane.getTitleAt(index), tabPane.getIconAt(index));
            this.tabPane = tabPane;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tabPane.setSelectedIndex(this.index);
        }
    }

    static enum Layout {
        WRAP(0),
        SCROLL(1);

        int value;

        private Layout(int value) {
            this.value = value;
        }
    }
}

