/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.OldSwingWorker;

public abstract class SwingWorkerLoop
extends OldSwingWorker {
    int _updateRate;
    boolean _pause;

    public SwingWorkerLoop(int updateRate) {
        this._updateRate = updateRate;
        this._pause = false;
    }

    public void setUpdateRate(int updateRate) {
        this._updateRate = updateRate;
    }

    public int getUpdateRate() {
        return this._updateRate;
    }

    public synchronized boolean pause() {
        if (this._pause) {
            return false;
        }
        this._pause = true;
        return true;
    }

    public synchronized boolean wakeUp() {
        if (this._pause) {
            this._pause = false;
            this.notifyAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct() {
        long prevTime = System.currentTimeMillis();
        while (true) {
            SwingWorkerLoop swingWorkerLoop = this;
            synchronized (swingWorkerLoop) {
                while (this._pause) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            this.loop();
            long newTime = System.currentTimeMillis();
            int loop = (int)(newTime - prevTime);
            int sleep = this._updateRate - loop;
            if (sleep > 0) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
                prevTime = newTime + (long)sleep;
                continue;
            }
            prevTime = newTime;
        }
    }

    protected abstract void loop();
}

