/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Application;
import com.edgytech.swingfast.Frame;
import com.edgytech.swingfast.IconGroup;
import com.edgytech.swingfast.ScalableThreadPool;
import com.edgytech.swingfast.XmlUnit;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SwingFast {
    public static ScalableThreadPool _tp = new ScalableThreadPool(50);
    static final Logger log = Logger.getLogger(SwingFast.class.getSimpleName());
    static boolean configured = false;
    private static Frame masterFrame;
    private static Application application;
    private static List<Window> topLevelWindows;
    private static boolean _debug;
    private static final Border PAD_BORDER;

    public static void configure(boolean systemLookAndFeel) {
        if (configured) {
            return;
        }
        if (systemLookAndFeel) {
            SwingFast.setUseSystemLookAndFeel(true);
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        IconGroup.registerGroup("edgytechIcons", new IconGroup("edgytechIcons", "com/edgytech/swingfast/img", true));
        configured = true;
    }

    public static Frame getMasterFrame() {
        return masterFrame;
    }

    public static void setMasterFrame(Frame frame) {
        masterFrame = frame;
    }

    public static Application getApplication() {
        return application;
    }

    public static void setApplication(Application application) {
        SwingFast.application = application;
    }

    public static void setUseSystemLookAndFeel(boolean system) {
        try {
            if (system) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addTopLevelWindow(Window w) {
        topLevelWindows.add(w);
    }

    public static List<Window> getTopLevelWindows() {
        return topLevelWindows;
    }

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public static boolean isDebugOn() {
        return _debug;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageIcon createIcon(String icon, String iconGroup) {
        ImageIcon ic = null;
        if (icon == null) return ic;
        if (icon.length() <= 0) return ic;
        if (iconGroup == null) return SwingFast.createIcon(icon);
        IconGroup group = IconGroup.getGroup(iconGroup);
        if (group != null) return SwingFast.createIcon(icon, group);
        log.warning("Could not find IconGroup " + iconGroup);
        return ic;
    }

    public static ImageIcon createIcon(String icon, IconGroup group) {
        ImageIcon ic = null;
        if (icon != null && icon.length() > 0 && group != null) {
            ic = group.getIcon(icon);
        }
        return ic;
    }

    public static ImageIcon createIcon(String path) {
        URL url = SwingFast.class.getResource(path);
        if (url == null) {
            log.warning("Couldn't find icon file: " + path);
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        if (icon == null) {
            log.warning("Couldn't create image from url: " + path);
        }
        return icon;
    }

    public static ImageIcon createOverlayIcon(ImageIcon base, ImageIcon overlay, int x, int y) {
        ImageIcon[] overlays = new ImageIcon[]{overlay};
        int[] xs = new int[]{x};
        int[] ys = new int[]{y};
        return SwingFast.createOverlayIcon(base, overlays, xs, ys);
    }

    public static ImageIcon createOverlayIcon(ImageIcon base, List<ImageIcon> overlays) {
        return SwingFast.createOverlayIcon(base, overlays.toArray(new ImageIcon[overlays.size()]));
    }

    public static ImageIcon createOverlayIcon(ImageIcon base, ImageIcon[] overlays) {
        int baseY;
        int[] xs = new int[overlays.length];
        int[] ys = new int[overlays.length];
        int minY = baseY = base.getIconHeight();
        int baseX = base.getIconWidth();
        for (int i = 0; i < overlays.length; ++i) {
            ImageIcon ico = overlays[i];
            int x = baseX - ico.getIconWidth();
            if (x < 0) {
                baseY = minY;
                baseX = base.getIconWidth();
                x = baseX - ico.getIconWidth();
            }
            int y = baseY - ico.getIconHeight();
            xs[i] = x;
            ys[i] = y;
            baseX = x;
            if (y >= minY) continue;
            minY = y;
        }
        return SwingFast.createOverlayIcon(base, overlays, xs, ys);
    }

    public static ImageIcon createOverlayIcon(ImageIcon base, ImageIcon[] overlays, int[] x, int[] y) {
        int w = base.getIconWidth();
        int h = base.getIconHeight();
        BufferedImage destIcon = new BufferedImage(w, h, 2);
        Graphics2D g2 = destIcon.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, w, h);
        g2.fill(rect);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawImage(base.getImage(), null, null);
        for (int i = 0; i < overlays.length; ++i) {
            ImageIcon overlay = overlays[i];
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.drawImage(overlay.getImage(), x[i], y[i], null);
        }
        return new ImageIcon(destIcon);
    }

    public static Border getPadBorder() {
        return PAD_BORDER;
    }

    public static void setFixedSize(Component comp, Dimension dim) {
        comp.setMinimumSize(dim);
        comp.setPreferredSize(dim);
        comp.setMaximumSize(dim);
    }

    public static void invokeAndWait(Runnable doRun) {
        try {
            SwingUtilities.invokeAndWait(doRun);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public static ScalableThreadPool getThreadPool() {
        return _tp;
    }

    public static void startThreadPool() {
        _tp.start();
    }

    public static void stopThreadPool() {
        _tp.stop();
    }

    public static XmlUnit findUnit(String ns) {
        String[] ids;
        XmlUnit unit = application;
        for (String id : ids = ns.split("\\.")) {
            if ((unit = unit.getBoundUnit(id)) != null) continue;
            return null;
        }
        return unit == application ? null : unit;
    }

    public static boolean isMacOSX() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac os x");
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("linux");
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("windows");
    }

    static {
        topLevelWindows = new LinkedList<Window>();
        _debug = false;
        PAD_BORDER = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    }
}

