/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScalableThreadPool {
    static Logger log = Logger.getLogger(ScalableThreadPool.class.getSimpleName());
    LinkedBlockingQueue<Runnable> _jobs = new LinkedBlockingQueue();
    ScalableThreadpoolWorker[] _workers;
    int poolSize;
    AtomicInteger _active = new AtomicInteger(0);
    String name;
    int acceptableQueuedJobCount = -1;
    boolean useDaemon = false;

    public ScalableThreadPool() {
        this(10);
    }

    public ScalableThreadPool(int poolSize) {
        this.poolSize = poolSize;
    }

    public void start() {
        if (this._workers != null) {
            return;
        }
        this._workers = new ScalableThreadpoolWorker[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            ScalableThreadpoolWorker worker;
            this._workers[i] = worker = new ScalableThreadpoolWorker(this.name + "_" + i);
            worker.start();
        }
    }

    public void stop() {
        if (this._workers == null) {
            return;
        }
        for (ScalableThreadpoolWorker worker : this._workers) {
            worker.stop();
        }
    }

    public void execute(Runnable job) {
        this._jobs.add(job);
    }

    private void incrementActiveCount() {
        this._active.incrementAndGet();
    }

    private void decrementActiveCount() {
        this._active.decrementAndGet();
    }

    public int getActiveCount() {
        return this._active.get();
    }

    public int getQueuedJobCount() {
        return this._jobs.size();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getUseDaemon() {
        return this.useDaemon;
    }

    public void setUseDaemon(boolean daemon) {
        this.useDaemon = daemon;
    }

    public int getAcceptableQueuedJobCount() {
        return this.acceptableQueuedJobCount;
    }

    public void setAcceptableQueuedJobCount(int acceptableQueuedJobCount) {
        this.acceptableQueuedJobCount = acceptableQueuedJobCount;
    }

    public boolean isQueuedJobCountAcceptable() {
        if (this.acceptableQueuedJobCount < 0) {
            return true;
        }
        return this.getQueuedJobCount() <= this.acceptableQueuedJobCount;
    }

    private Runnable getJob() {
        try {
            return this._jobs.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public String generateStats() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(String.format("Threadpool %s: active=%d, max=%d, queue=%d", this.getName(), this.getActiveCount(), this.getPoolSize(), this.getQueuedJobCount()));
        return buffer.toString();
    }

    class ScalableThreadpoolWorker
    implements Runnable {
        Thread thread = new Thread(this);
        boolean running;

        public ScalableThreadpoolWorker(String name) {
            this.thread.setName(name);
            this.running = true;
        }

        public void start() {
            if (ScalableThreadPool.this.getUseDaemon()) {
                this.thread.setDaemon(true);
            }
            this.thread.start();
        }

        public void stop() {
            this.running = false;
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                Runnable job = ScalableThreadPool.this.getJob();
                if (job == null) continue;
                ScalableThreadPool.this.incrementActiveCount();
                try {
                    job.run();
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    ScalableThreadPool.this.decrementActiveCount();
                }
            }
        }
    }
}

