/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import java.text.NumberFormat;

public class NumberReducer {
    int m_maxDigits;
    int m_maxFraction;
    int m_maxInteger;
    String m_pad;
    NumberFormat m_nf;

    public NumberReducer(int maxInteger, int maxFraction, String pad) {
        this.m_maxFraction = maxFraction;
        this.m_maxInteger = maxInteger;
        this.m_maxDigits = this.m_maxInteger + this.m_maxFraction + 2;
        this.m_pad = pad;
        this.m_nf = NumberFormat.getNumberInstance();
        this.m_nf.setMaximumFractionDigits(this.m_maxFraction);
        this.m_nf.setMaximumIntegerDigits(this.m_maxInteger);
    }

    public String format(long number) {
        String str = null;
        for (SizeUnit size : SizeUnit.values()) {
            long scale = size.m_scale;
            if (number >= scale) {
                if (number % scale == 0L) {
                    str = this.m_nf.format(number / scale);
                } else {
                    double dec = (double)number / (double)scale;
                    str = this.m_nf.format(dec);
                }
                str = str + size.name();
            }
            if (str != null) break;
        }
        if (str == null) {
            str = this.m_nf.format(number);
        }
        if (this.m_pad != null) {
            for (int i = str.length(); i < this.m_maxDigits; ++i) {
                str = this.m_pad + str;
            }
        }
        return str;
    }

    static enum SizeUnit {
        G(1000000000L),
        M(1000000L),
        K(1000L);

        long m_scale;

        private SizeUnit(long scale) {
            this.m_scale = scale;
        }
    }
}

