/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.ProgressBar;
import com.edgytech.swingfast.ProgressBarWorker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JProgressBar;

public class MemoryBar
extends ProgressBar
implements MouseListener {
    ProgressBarWorker worker;

    @Override
    protected void updateComponentCustom(JProgressBar comp) {
        super.updateComponentCustom(comp);
        Runtime run = Runtime.getRuntime();
        long total = run.totalMemory();
        long free = run.freeMemory();
        String str = String.format("%dMB Used, %dMB Total. Click to run the garbage collector", (total - free) / 1000000L, total / 1000000L);
        comp.setToolTipText(str);
    }

    @Override
    protected JProgressBar createComponent() {
        JProgressBar comp = super.createComponent();
        comp.addMouseListener(this);
        return comp;
    }

    public void start() {
        if (this.worker == null) {
            this.worker = new ProgressBarWorker(this){

                @Override
                protected Object doInBackground() throws Exception {
                    while (!MemoryBar.this.worker.isCancelled()) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        Runtime run = Runtime.getRuntime();
                        long total = run.totalMemory();
                        long free = run.freeMemory();
                        this.setProgress((int)((total - free) * 100L / total));
                    }
                    return null;
                }

                @Override
                public String getProgressString() {
                    Runtime run = Runtime.getRuntime();
                    long total = run.totalMemory();
                    long free = run.freeMemory();
                    return String.format("%dMB/%dMB", (total - free) / 1000000L, total / 1000000L);
                }
            };
            this.worker.start();
        }
    }

    public void stop() {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.gc();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

