/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.IntFieldInterface;
import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.w3c.dom.Node;

public class ListArea
extends XmlUnitField<XmlUnit, JList>
implements ActionListener,
StringFieldInterface,
IntFieldInterface {
    public static final String ITEM_SEPARATOR = ";";
    @XmlUnit.Serial
    public String[] items;
    @XmlUnit.Serial
    public String iconGroup;
    @XmlUnit.Serial
    public int visibleRowCount = 0;
    @XmlUnit.Serial
    public int fixedCellHeight = 0;
    @XmlUnit.Serial
    public int fixedCellWidth = 0;
    @XmlUnit.SerialStar
    public int value = 0;
    private boolean _restructuring = false;

    public ListArea() {
    }

    public ListArea(String id, String label, String[] items) {
        this();
        this.setId(id);
        this.setLabel(label);
        this.items = items;
        this.markStructured();
    }

    @Override
    protected JList createComponent() {
        JList box = new JList();
        return box;
    }

    @Override
    protected void structureComponentCustom(JList old) {
        String longest = null;
        int maxLen = 0;
        FontMetrics fm = old.getFontMetrics(old.getFont());
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (this.items != null) {
            this._restructuring = true;
            old.removeAll();
            for (String item : this.items) {
                model.addElement(item);
                int len = fm.stringWidth(item);
                if (longest != null && maxLen >= len) continue;
                longest = item;
                maxLen = len;
            }
            this._restructuring = false;
        }
        if (this.visibleRowCount > 0) {
            old.setVisibleRowCount(this.visibleRowCount);
        }
        old.setModel(model);
    }

    @Override
    protected void updateComponentCustom(JList old) {
        if (this.value >= 0 && old.getSelectedIndex() != this.value) {
            old.setSelectedIndex(this.value);
            old.ensureIndexIsVisible(this.value);
        }
    }

    @Override
    protected boolean checkComponentCustom(JList comp) {
        return true;
    }

    @Override
    protected void commitComponentCustom(JList comp) {
        this.value = comp.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JList box = (JList)this.getComponent();
        if (!this._restructuring && this.hasListener()) {
            this.notifyListener(box);
        }
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
    }

    @Override
    public String getStringValue() {
        return this.items[this.value];
    }

    @Override
    public void setStringValue(String value) {
        int i = 0;
        for (String item : this.items) {
            if (item.equals(value)) {
                this.value = i;
                return;
            }
            ++i;
        }
        this.value = -1;
    }

    @Override
    public String getComponentStringValue() {
        return (String)((JList)this.getComponent()).getSelectedValue();
    }

    @Override
    public void setComponentStringValue(String value) {
        ((JList)this.getComponent()).setSelectedValue(this.id, true);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setIntValue(int value) {
        this.value = value;
    }

    @Override
    public int getComponentIntValue() {
        return ((JList)this.getComponent()).getSelectedIndex();
    }

    @Override
    public void setComponentIntValue(int value) {
        ((JList)this.getComponent()).setSelectedIndex(value);
    }
}

