/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.IntBox;
import com.edgytech.swingfast.UByteDocument;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JLabel;

public class IpBox
extends BoxPanel {
    IntBox[] _ipFields = new IntBox[4];

    public IpBox(String ip) {
        super(Common.Axis.X, Common.Align.CENTER, false);
        for (int i = 0; i < this._ipFields.length; ++i) {
            IntBox field;
            this._ipFields[i] = field = new IntBox(0, 0, 255, 0);
            field.setColumns(3);
            field.setDocument(new UByteDocument());
            this.add(field);
            if (i >= this._ipFields.length - 1) continue;
            this.add(new JLabel("."));
        }
        this.setIpValue(ip);
    }

    void setIpValue(String ip) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException ex) {
            return;
        }
        byte[] ipBytes = address.getAddress();
        for (int i = 0; i < this._ipFields.length; ++i) {
            int val = ipBytes[i] & 0xFF;
            this._ipFields[i].setValue(val);
        }
    }

    String getIpValue() {
        String ip = "";
        for (int i = 0; i < this._ipFields.length; ++i) {
            ip = ip + String.valueOf(this._ipFields[i].getValue());
            if (i >= this._ipFields.length - 1) continue;
            ip = ip + ".";
        }
        return ip;
    }
}

