/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.Scroller;
import com.edgytech.swingfast.Text;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.swing.JDialog;
import org.w3c.dom.Element;
import sun.misc.IOUtils;

public class InfoDialog
extends FormDialog {
    @XmlUnit.Serial
    public String text;
    @XmlUnit.Serial
    public String file;
    @XmlUnit.Serial
    public String fileType;
    @XmlUnit.Serial
    public String textId;
    @XmlUnit.Serial
    public boolean scroller;
    Text _infoText;

    public InfoDialog() {
        this.buttons = FormDialog.ButtonConfig.OK;
        this.fileType = "HTML";
        this.scroller = false;
    }

    public InfoDialog(String id, String label, Window owner, String text) {
        this();
        this.setId(id);
        this.setLabel(label);
        this.setOwner(owner);
        this.text = text;
        this.structure(null);
        this.markStructured();
    }

    public InfoDialog(String id, String label, Window owner, String file, String fileType, boolean scroller) {
        this();
        this.setId(id);
        this.setLabel(label);
        this.setOwner(owner);
        this.file = file;
        if (fileType != null) {
            this.fileType = fileType;
        }
        this.scroller = scroller;
        this.structure(null);
        this.markStructured();
    }

    @Override
    protected void structure(Element elmt) {
        if (this.file != null) {
            InputStream in = InfoDialog.class.getResourceAsStream(this.file);
            try {
                byte[] bytes = IOUtils.readFully((InputStream)in, (int)-1, (boolean)true);
                this.text = new String(bytes);
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        this._infoText = new Text(this.textId, null, this.text != null ? this.text : "");
        if (this.scroller) {
            Scroller scroll = new Scroller();
            scroll.addChild(this._infoText);
            this.addChild(scroll);
        } else {
            this.addChild(this._infoText);
        }
        super.structure(elmt);
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        this._infoText.value = this.text;
        super.updateComponentCustom(old);
    }
}

