/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.SwingFast;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class ImageFilePreview
extends BoxPanel
implements PropertyChangeListener {
    private static Logger log = Logger.getLogger(ImageFilePreview.class.getSimpleName());
    ImageIcon thumbnail = null;
    File file = null;
    Job job = null;
    Hashtable<String, ImageIcon> images = new Hashtable();
    int maxWidth;
    int maxHeight;
    String title;
    JLabel _preview;
    JFileChooser _chooser;

    public ImageFilePreview(JFileChooser fc, int maxWidth, int maxHeight, String title) {
        this._chooser = fc;
        SwingFast.setFixedSize(this, new Dimension(maxWidth, maxHeight));
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.title = "Image Preview";
        if (title != null) {
            this.title = title;
        }
        if (this.title.length() > 0) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
        this._preview = new JLabel();
        this.addGlue();
        this.add(this._preview);
        this.addGlue();
        this.updatePreview();
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        this.thumbnail = this.images.get(this.file.getPath());
        if (this.thumbnail == null) {
            this.thumbnail = this.createThumbnail(this.file.getPath());
            if (this.thumbnail != null) {
                this.images.put(this.file.getPath(), this.thumbnail);
            }
        }
    }

    private ImageIcon createThumbnail(String path) {
        BufferedImage img = this.getEXIFPreviewImage(path);
        if (img != null) {
            return new ImageIcon(img);
        }
        long time = System.currentTimeMillis();
        ImageIcon icon = new ImageIcon(path);
        ImageIcon res = null;
        if (icon != null) {
            Insets in = this.getInsets();
            int width = this.maxWidth - in.left - in.right;
            int height = this.maxHeight - in.top - in.bottom;
            float zoom = ImageFilePreview.calculateBestFitZoom(icon, width, height, 5.0f);
            int newWidth = (int)((float)icon.getIconWidth() * zoom / 100.0f);
            int newHeight = (int)((float)icon.getIconHeight() * zoom / 100.0f);
            if (icon.getIconWidth() > newWidth || icon.getIconHeight() > newHeight) {
                res = new ImageIcon(icon.getImage().getScaledInstance(newWidth, newHeight, 4));
            }
            log.info(String.format("preview thumbnail done in %d, w %d, h %d, zoom %f", System.currentTimeMillis() - time, icon.getIconWidth(), icon.getIconHeight(), Float.valueOf(zoom)));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getEXIFPreviewImage(String filename) {
        BufferedImage exifPreview = null;
        ImageInputStream iis = null;
        ImageReader ir = null;
        long time = System.currentTimeMillis();
        try {
            File file = new File(filename);
            iis = new FileImageInputStream(file);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            while (it.hasNext()) {
                ImageReader tmp = it.next();
                if (!tmp.readerSupportsThumbnails()) continue;
                ir = tmp;
                break;
            }
            if (ir == null) {
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            ir.setInput(iis, true, false);
            if (ir.hasThumbnails(0)) {
                exifPreview = ir.readThumbnail(0, 0);
            }
        }
        catch (FileNotFoundException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            if (ir != null) {
                ir.dispose();
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException ex) {}
            }
        }
        return exifPreview;
    }

    public static float calculateBestFitZoom(ImageIcon img, int width, int height, float fudge) {
        float mult = 100.0f - fudge;
        float zoomx = (float)width * mult / (float)img.getIconWidth();
        float zoomy = (float)height * mult / (float)img.getIconHeight();
        if (zoomx <= 0.0f && zoomy <= 0.0f) {
            return 100.0f;
        }
        if (zoomx <= 0.0f) {
            return zoomy;
        }
        if (zoomy <= 0.0f) {
            return zoomx;
        }
        return Math.min(zoomx, zoomy);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            if (this.job != null) {
                this.job.running = false;
                this.job = null;
            }
            this.images.clear();
            File folder = (File)e.getNewValue();
            if (folder != null) {
                this.job = new Job(folder);
                this.job.start();
            }
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            this.loadImage();
            this.updatePreview();
        }
    }

    private void updatePreview() {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            this._preview.setIcon(this.thumbnail);
        } else {
            this._preview.setIcon(null);
        }
        this.invalidate();
        this.validate();
    }

    void start() {
        File folder;
        if (this.job == null && (folder = this._chooser.getCurrentDirectory()) != null) {
            this.job = new Job(folder);
            this.job.start();
        }
    }

    void stop() {
        if (this.job != null) {
            this.job.running = false;
            this.job = null;
        }
        this.images.clear();
    }

    class Job
    extends Thread {
        boolean running = true;
        File folder;

        public Job(File folder) {
            this.folder = folder;
        }

        @Override
        public void run() {
            File[] files;
            for (File file : files = this.folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            })) {
                if (!this.running) break;
                ImageIcon img = ImageFilePreview.this.createThumbnail(file.getPath());
                ImageFilePreview.this.images.put(file.getPath(), img);
            }
        }
    }
}

