/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Directory;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlUnit;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;

public class IconGroup
extends Directory {
    static HashMap<String, IconGroup> _groups;
    HashMap<String, ImageIcon> _icons;

    public static IconGroup getGroup(String name) {
        if (_groups == null) {
            return null;
        }
        return _groups.get(name);
    }

    public static void registerGroup(String name, IconGroup group) {
        if (_groups == null) {
            _groups = new HashMap();
        }
        _groups.put(name, group);
    }

    public IconGroup() {
    }

    public IconGroup(String id, String folder, boolean res) {
        super(id, folder, res);
        if (id != null) {
            IconGroup.registerGroup(id, this);
        }
        this.markStructured();
    }

    public IconGroup(String id, String folder, boolean res, Enum[] icons, String ext) {
        super(id, folder, res, icons, ext);
        if (id != null) {
            IconGroup.registerGroup(id, this);
        }
        this.markStructured();
    }

    public void loadAllIcons() {
        if (this._icons == null) {
            this._icons = new HashMap();
        }
        for (String path : this._paths) {
            this._icons.put(path, SwingFast.createIcon(path));
        }
    }

    public ImageIcon getIcon(Enum icon) {
        String path = this.getPath(icon);
        return this.getIconByPath(path);
    }

    public ImageIcon getIcon(String baseName) {
        String path = this.getPath(baseName);
        return this.getIconByPath(path);
    }

    public ImageIcon getIconByPath(String path) {
        ImageIcon icon;
        if (this._icons == null) {
            this._icons = new HashMap();
        }
        if ((icon = this._icons.get(path)) != null) {
            return icon;
        }
        icon = SwingFast.createIcon(path);
        if (icon == null) {
            return null;
        }
        if (this._icons == null) {
            this._icons = new HashMap();
        }
        this._icons.put(path, icon);
        return icon;
    }

    @Override
    protected void xmlPostLoadCallback(Node unit, XmlUnit.State state) {
        super.xmlPostLoadCallback(unit, state);
        IconGroup.registerGroup(this.id, this);
    }
}

