/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.IconGroup;
import com.edgytech.swingfast.MenuBar;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Container;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.w3c.dom.Node;

public class Frame
extends XmlComponentUnit<XmlUnit, JFrame>
implements Showable {
    @XmlUnit.SerialStar
    public boolean maximized = false;
    @XmlUnit.SerialStar
    public String title;
    @XmlUnit.Serial
    public String menuId;
    @XmlUnit.Serial
    public String icon;
    @XmlUnit.Serial
    public String iconGroup;
    @XmlUnit.Serial
    public boolean masterFrame = false;
    JFrame _frame;

    @Override
    protected JFrame createComponent() {
        JFrame f = new JFrame();
        if (this.icon != null && this.icon.length() > 0) {
            ImageIcon ic = null;
            if (this.iconGroup != null) {
                IconGroup group = IconGroup.getGroup(this.iconGroup);
                if (group == null) {
                    this.logErrorLine("Could not find IconGroup " + this.iconGroup);
                } else {
                    ic = group.getIcon(this.icon);
                }
            } else {
                ic = SwingFast.createIcon(this.icon);
            }
            if (ic != null) {
                f.setIconImage(ic.getImage());
            }
        } else {
            Frame frame = SwingFast.getMasterFrame();
            if (frame != null) {
                f.setIconImages(((JFrame)frame.getComponent()).getIconImages());
            }
        }
        SwingFast.addTopLevelWindow(f);
        return f;
    }

    @Override
    protected void structureComponentCustom(JFrame old) {
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                Object comp;
                if (MenuBar.class.isInstance(child)) {
                    old.setJMenuBar((JMenuBar)((MenuBar)child).getComponent());
                    continue;
                }
                if (!XmlComponentUnit.class.isInstance(child) || !Container.class.isInstance(comp = ((XmlComponentUnit)child).getComponent())) continue;
                old.setContentPane((Container)comp);
            }
        }
    }

    @Override
    protected void updateComponentCustom(JFrame old) {
        String title = this.title != null ? this.title : this.getLabelToDisplay();
        old.setTitle(title);
    }

    @Override
    protected void commitComponentCustom(JFrame comp) {
        this.maximized = comp.getExtendedState() == 6;
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State force) {
        if (this.masterFrame) {
            SwingFast.setMasterFrame(this);
        }
    }

    @Override
    public boolean show() {
        JFrame f = (JFrame)this.getComponent();
        f.validate();
        f.pack();
        if (this.maximized) {
            f.setExtendedState(6);
        } else {
            f.setExtendedState(0);
        }
        f.setVisible(true);
        return false;
    }

    @Override
    public void hide() {
        ((JFrame)this.getComponent()).setVisible(false);
    }
}

