/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Button;
import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.ButtonPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.Div;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FieldChecker;
import com.edgytech.swingfast.FormDialogListener;
import com.edgytech.swingfast.Frame;
import com.edgytech.swingfast.Glue;
import com.edgytech.swingfast.IconGroup;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

public class FormDialog
extends XmlComponentUnit<XmlUnit, JDialog>
implements Showable {
    @XmlUnit.Serial
    public ButtonConfig buttons = ButtonConfig.OK_CANCEL_RESET;
    @XmlUnit.Serial
    public boolean resetOnDisplay = false;
    @XmlUnit.Serial
    public boolean modal = true;
    @XmlUnit.Serial
    public boolean resizable = true;
    @XmlUnit.Serial
    public String icon;
    @XmlUnit.Serial
    public String iconGroup;
    @XmlUnit.Serial
    public String signIcon;
    @XmlUnit.Serial
    public String signIconGroup;
    @XmlUnit.Serial
    public Color signBorderColor;
    @XmlUnit.Serial
    public String okLabel = "Ok";
    @XmlUnit.Serial
    public String cancelLabel = "Cancel";
    @XmlUnit.Serial
    public String resetLabel = "Reset";
    @XmlUnit.Serial
    public String helpLabel = "Help";
    @XmlUnit.Serial
    public String helpFile;
    @XmlUnit.Serial
    public String helpFileType;
    ButtonPanel _buttons;
    FormDialogListener _listener;
    FieldChecker _checker;
    Buttons _lastChoice;
    Window _owner;
    protected ArrayList<XmlUnitField> _fields;

    public FormDialog() {
    }

    public FormDialog(String id, Window owner, ButtonConfig bconf) {
        this();
        this.setId(id);
        this.setOwner(owner);
        this.buttons = bconf;
        this.structure(null);
        this.markStructured();
    }

    public FormDialog(String id, Window owner, ButtonConfig bconf, Enum[] enms) {
        this(id, owner, bconf);
        this.setEnumBinding(enms, null);
    }

    public FormDialog(String id, Window owner, ButtonConfig bconf, Enum[] enms, FormDialogListener listener, FieldChecker checker) {
        this(id, owner, bconf, enms);
        this.setFormDialogListener(listener);
        this.setFieldChecker(checker);
    }

    public void setOwner(Window owner) {
        this._owner = owner;
    }

    public void setFormDialogListener(FormDialogListener listener) {
        this._listener = listener;
    }

    public void setFieldChecker(FieldChecker checker) {
        this._checker = checker;
    }

    @Override
    protected void structure(Element elmt) {
        Button b;
        super.structure(elmt);
        this._fields = new ArrayList();
        this.getChildrenOfClass(XmlUnitField.class, this._fields);
        if (this.buttons == null) {
            this.buttons = ButtonConfig.OK_CANCEL;
        }
        this._buttons = new ButtonPanel(this.id, null, Common.Axis.X, Common.Align.CENTER, true);
        this._buttons.setEnumBinding(Buttons.values(), new ButtonListener());
        if (this.helpFile != null) {
            b = new Button(Buttons.HELP_BUTTON.name(), this.helpLabel);
            b.icon = "help.png";
            b.iconGroup = "edgytechIcons";
            b.key = ButtonBase.Key.H;
            b.keyMod = "shift+cmd";
            b.toolTipText = "Open the help dialog";
            this._buttons.addChild(b);
        }
        if (this.buttons == ButtonConfig.OK_CANCEL_RESET) {
            b = new Button(Buttons.RESET_BUTTON.name(), this.resetLabel);
            b.icon = "refresh.png";
            b.iconGroup = "edgytechIcons";
            b.key = ButtonBase.Key.R;
            b.keyMod = "shift+cmd";
            b.toolTipText = "Reset the dialog to its original values";
            this._buttons.addChild(b);
        }
        this._buttons.addChild(new Glue());
        if (this.buttons != ButtonConfig.CANCEL) {
            b = new Button(Buttons.OK_BUTTON.name(), this.okLabel);
            b.key = ButtonBase.Key.ENTER;
            b.keyMod = "cmd";
            b.toolTipText = "Submit";
            this._buttons.addChild(b);
        }
        if (this.buttons != ButtonConfig.OK) {
            b = new Button(Buttons.CANCEL_BUTTON.name(), this.cancelLabel);
            this._buttons.addChild(b);
        }
        this._buttons.markStructured();
        if (this.resetOnDisplay) {
            this.save = false;
        }
    }

    @Override
    protected JDialog createComponent() {
        JDialog dialog = new JDialog(this._owner, this.getLabelToDisplay());
        dialog.setModal(this.modal);
        dialog.setResizable(this.resizable);
        if (this.icon != null && this.icon.length() > 0) {
            ImageIcon ic = null;
            if (this.iconGroup != null) {
                IconGroup group = IconGroup.getGroup(this.iconGroup);
                if (group == null) {
                    this.logErrorLine("Could not find IconGroup " + this.iconGroup);
                } else {
                    ic = group.getIcon(this.icon);
                }
            } else {
                ic = SwingFast.createIcon(this.icon);
            }
            if (ic != null) {
                dialog.setIconImage(ic.getImage());
            }
        } else {
            Frame frame = SwingFast.getMasterFrame();
            if (frame != null) {
                dialog.setIconImages(((JFrame)frame.getComponent()).getIconImages());
            }
        }
        SwingFast.addTopLevelWindow(dialog);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        dialog.getRootPane().getInputMap(2).put(stroke, "close");
        dialog.getRootPane().getActionMap().put("close", new AbstractAction(this.getLabelToDisplay()){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JDialog)FormDialog.this.getComponent()).setVisible(false);
            }
        });
        return dialog;
    }

    public void addFieldsDivComponent(BoxPanel global) {
        Div content = new Div();
        content.gap = true;
        this.addFields(content);
        content.markStructured();
        global.add(content.getComponent());
    }

    public void addFields(Div content) {
        if (this.hasChildren()) {
            content.addChildren(this.getChildren().toArray(new XmlUnit[this.getChildren().size()]));
        }
    }

    protected BoxPanel createGlobalPanel() {
        return new BoxPanel(Common.Axis.Y, Common.Align.CENTER, true);
    }

    protected BoxPanel createAndAddFormPanel(BoxPanel globalPanel) {
        return globalPanel;
    }

    @Override
    protected void structureComponentCustom(JDialog old) {
        JDialog dialog = old;
        BoxPanel globalPanel = this.createGlobalPanel();
        BoxPanel formPanel = this.createAndAddFormPanel(globalPanel);
        if (this.signIcon != null && this.signIcon.length() > 0) {
            ImageIcon ic = null;
            if (this.signIconGroup != null) {
                IconGroup group = IconGroup.getGroup(this.signIconGroup);
                if (group == null) {
                    this.logErrorLine("Could not find IconGroup " + this.signIconGroup);
                } else {
                    ic = group.getIcon(this.signIcon);
                }
            } else {
                ic = SwingFast.createIcon(this.signIcon);
            }
            if (ic != null) {
                JLabel sign = new JLabel(ic);
                if (this.signBorderColor != null) {
                    sign.setBorder(BorderFactory.createLineBorder(this.signBorderColor));
                }
                globalPanel.add(sign);
            }
        }
        this.addFieldsDivComponent(formPanel);
        dialog.getContentPane().add((Component)globalPanel, "Center");
        if (this._buttons != null) {
            BoxPanel bpanel = new BoxPanel(Common.Axis.X, false);
            bpanel.addGlue();
            bpanel.add(this._buttons.getComponent());
            dialog.getContentPane().add((Component)bpanel, "South");
        }
        dialog.validate();
        dialog.pack();
        if (this._fields != null && this._fields.size() > 1) {
            JLabel label;
            int maxWidth = 0;
            for (XmlUnitField field : this._fields) {
                int w;
                label = field.getFieldLabel();
                if (label == null || (w = label.getPreferredSize().width) <= maxWidth) continue;
                maxWidth = w;
            }
            if (maxWidth > 0) {
                for (XmlUnitField field : this._fields) {
                    label = field.getFieldLabel();
                    if (label == null) continue;
                    Dimension dim = label.getPreferredSize();
                    dim.width = maxWidth;
                    label.setPreferredSize(dim);
                }
            }
        }
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        if (this._buttons != null) {
            this._buttons.updateComponent();
        }
        old.setTitle(this.getLabelToDisplay());
        old.pack();
    }

    @Override
    protected void commitComponentCustom(JDialog comp) {
    }

    @Override
    public boolean show() {
        this._lastChoice = null;
        JDialog dialog = (JDialog)this.getComponent();
        if (!dialog.isVisible()) {
            if (this.resetOnDisplay) {
                this.xmlLoadCheckpoint();
                if (this._listener != null) {
                    this._listener.formResetCbk();
                }
            }
            this.updateComponent();
            if (this._owner != null) {
                dialog.setLocationRelativeTo(this._owner);
            } else {
                Frame f = SwingFast.getMasterFrame();
                if (f != null) {
                    dialog.setLocationRelativeTo((Component)f.getComponent());
                }
            }
            if (this.getOkButton() != null) {
                this.getOkButton().requestFocusInWindow();
            } else {
                this.getCancelButton().requestFocusInWindow();
            }
            dialog.pack();
            dialog.setVisible(true);
        }
        if (this.modal) {
            if (this._lastChoice == null) {
                return false;
            }
            switch (this._lastChoice) {
                case OK_BUTTON: {
                    return true;
                }
                case CANCEL_BUTTON: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void hide() {
        JDialog dialog = (JDialog)this.getComponent();
        if (dialog.isVisible()) {
            dialog.setVisible(false);
        }
    }

    public boolean checkComponent(FieldChecker checker) {
        boolean res = true;
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (!XmlUnitField.class.isInstance(child) || ((XmlUnitField)child).checkComponent(checker)) continue;
                res = false;
            }
        }
        return res;
    }

    public JButton getOkButton() {
        Button button;
        if (this._buttons != null && (button = (Button)this._buttons.getBoundUnit(Buttons.OK_BUTTON)) != null) {
            return (JButton)button.getComponent();
        }
        return null;
    }

    public JButton getCancelButton() {
        Button button;
        if (this._buttons != null && (button = (Button)this._buttons.getBoundUnit(Buttons.CANCEL_BUTTON)) != null) {
            return (JButton)button.getComponent();
        }
        return null;
    }

    public JButton getResetButton() {
        Button button;
        if (this._buttons != null && (button = (Button)this._buttons.getBoundUnit(Buttons.RESET_BUTTON)) != null) {
            return (JButton)button.getComponent();
        }
        return null;
    }

    public void dispose() {
        if (this.hasComponent()) {
            ((JDialog)this.getComponent()).dispose();
        }
    }

    public static enum ButtonConfig {
        NONE,
        OK,
        CANCEL,
        OK_CANCEL,
        OK_CANCEL_RESET;

    }

    public static enum Buttons {
        OK_BUTTON,
        CANCEL_BUTTON,
        RESET_BUTTON,
        HELP_BUTTON;

    }

    class ButtonListener
    implements EnumListener<Buttons> {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(Buttons enm, XmlComponentUnit unit, Object src) {
            JDialog dialog = (JDialog)FormDialog.this.getComponent();
            switch (enm) {
                case OK_BUTTON: {
                    if (FormDialog.this.checkComponent(FormDialog.this._checker)) {
                        FormDialog.this.commitComponent();
                        FormDialog.this._lastChoice = Buttons.OK_BUTTON;
                        FormDialog.this.hide();
                        if (FormDialog.this._listener == null) break;
                        FormDialog.this._listener.formOkCbk();
                        break;
                    }
                    FormDialog.this.updateComponent(false);
                    break;
                }
                case CANCEL_BUTTON: {
                    FormDialog.this._lastChoice = Buttons.CANCEL_BUTTON;
                    FormDialog.this.hide();
                    FormDialog.this.updateComponent();
                    if (FormDialog.this._listener == null) break;
                    FormDialog.this._listener.formCancelCbk();
                    break;
                }
                case RESET_BUTTON: {
                    FormDialog.this._lastChoice = Buttons.RESET_BUTTON;
                    ConfirmDialog dia = new ConfirmDialog(null, "Confirm Reset", (Window)FormDialog.this.getComponent(), "Are you sure that you want to reset this dialog to its original settings?");
                    if (!dia.show()) break;
                    FormDialog.this.xmlLoadCheckpoint();
                    if (FormDialog.this._listener == null) break;
                    FormDialog.this._listener.formResetCbk();
                    break;
                }
                case HELP_BUTTON: {
                    FormDialog.this._lastChoice = Buttons.HELP_BUTTON;
                    InfoDialog help = new InfoDialog(null, "Help", (Window)FormDialog.this.getComponent(), FormDialog.this.helpFile, FormDialog.this.helpFileType, true);
                    help.show();
                }
            }
        }
    }
}

