/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class FloatDoc
extends PlainDocument {
    int _maxDecimals;
    float _min;
    float _max;

    public FloatDoc(float min, float max, int maxDecimals) {
        this._min = min;
        this._max = max;
        this._maxDecimals = maxDecimals;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        float val;
        if (str == null) {
            return;
        }
        String text = str;
        if (this.getLength() > 0) {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.insert(offs, str);
            text = buffer.toString();
        }
        try {
            val = Float.parseFloat(text);
        }
        catch (Exception e) {
            return;
        }
        if (val < this._min || val > this._max) {
            return;
        }
        int dot = text.indexOf(46);
        if (this._maxDecimals > 0 && text.length() - dot - 1 > this._maxDecimals) {
            return;
        }
        super.insertString(offs, str, a);
    }
}

