/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.FloatDoc;
import java.awt.Dimension;
import javax.swing.JTextField;

public class FloatBox
extends JTextField {
    public FloatBox(float value, float min, float max, int maxDecimals, int columns) {
        String tooltip;
        if (columns <= 0) {
            String str = String.valueOf(min);
            int dot = str.indexOf(46);
            int minSize = dot >= 0 ? dot : str.length();
            str = String.valueOf(max);
            dot = str.indexOf(46);
            int maxSize = dot >= 0 ? dot : str.length();
            columns = Math.max(minSize, maxSize);
            columns = maxDecimals > 0 ? (columns += maxDecimals + 1) : (columns += 3);
            this.setColumns(columns);
        } else {
            this.setColumns(columns);
        }
        this.setDocument(new FloatDoc(min, max, maxDecimals));
        this.setText(String.valueOf(value));
        if (maxDecimals > 0) {
            String format = String.format("float value between %%.%df and %%.%df", maxDecimals, maxDecimals);
            tooltip = String.format(format, Float.valueOf(min), Float.valueOf(max));
        } else {
            tooltip = String.format("float value between %f and %f", Float.valueOf(min), Float.valueOf(max));
        }
        this.setToolTipText(tooltip);
        Dimension dim = this.getPreferredSize();
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
    }

    float getValue() {
        String text = this.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    void setValue(float val) {
        this.setText(String.valueOf(val));
    }
}

