/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.FileSelectorDialog;
import com.edgytech.swingfast.StringFieldInterface;
import com.edgytech.swingfast.TextBox;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import org.w3c.dom.Element;

public class FileSelectorField
extends XmlUnitField<XmlUnit, BoxPanel>
implements ActionListener,
StringFieldInterface {
    @XmlUnit.SerialStar
    String path = "";
    @XmlUnit.Serial
    String dialogId;
    @XmlUnit.Serial
    int limit;
    @XmlUnit.Serial
    boolean confirmOverwrite;
    TextBox _field;
    JButton _button;
    FileSelectorDialog _fc;

    public FileSelectorField() {
        String home = System.getProperty("user.home");
        if (home != null) {
            this.path = home;
        }
        this.confirmOverwrite = true;
    }

    public FileSelectorField(String id, String path, int columns) {
        this();
        this.setId(id);
        this.columns = columns;
        if (path != null) {
            this.path = path;
        }
    }

    @Override
    protected void structure(Element elmt) {
        super.structure(elmt);
        this._fc = this.getFirstChildOfClass(FileSelectorDialog.class, this.dialogId);
        if (this._fc == null) {
            this._fc = new FileSelectorDialog(this.dialogId, null, FileSelectorDialog.ChooserType.OPEN, FileSelectorDialog.SelectionMode.FILES_ONLY);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    @Override
    public String getStringValue() {
        return this.getPath();
    }

    @Override
    public void setStringValue(String value) {
        this.setPath(value);
    }

    @Override
    public String getComponentStringValue() {
        return this._field.getText();
    }

    @Override
    public void setComponentStringValue(String value) {
        this._field.setText(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this._fc.show()) {
            return;
        }
        this.setComponentStringValue(this._fc.getPath());
        this.notifyListener(this.getComponent());
    }

    @Override
    protected boolean checkComponentCustom(BoxPanel comp) {
        String path = this.getComponentStringValue();
        if (path.isEmpty()) {
            return true;
        }
        File file = new File(path);
        return this._fc.type != FileSelectorDialog.ChooserType.SAVE || file == null || file.isDirectory() || !file.exists() || !this.confirmOverwrite || new ConfirmDialog(null, "Confirm Overwrite", null, "File already exists, overwrite?").show();
    }

    @Override
    protected BoxPanel createComponent() {
        BoxPanel panel = new BoxPanel(Common.Axis.X, true);
        this._field = new TextBox(this.path, this.columns <= 0 ? 20 : this.columns, this.limit < 0 ? 0 : this.limit);
        panel.add(this._field);
        this._button = new JButton("Browse");
        this._button.addActionListener(this);
        panel.add(this._button);
        return panel;
    }

    @Override
    protected void structureComponentCustom(BoxPanel comp) {
    }

    @Override
    protected void updateComponentCustom(BoxPanel comp) {
        this.setComponentStringValue(this.path);
    }

    @Override
    protected void commitComponentCustom(BoxPanel comp) {
        this.path = this.getComponentStringValue();
    }
}

