/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.io.File;
import javax.swing.JFileChooser;

public class FileSelectorDialog
extends XmlComponentUnit<XmlUnit, JFileChooser>
implements Showable {
    @XmlUnit.Serial
    ChooserType type = ChooserType.OPEN;
    @XmlUnit.Serial
    SelectionMode mode = SelectionMode.FILES_ONLY;
    @XmlUnit.SerialStar
    String path;
    JFileChooser _chooser;

    public FileSelectorDialog() {
    }

    public FileSelectorDialog(String id, String label, ChooserType type, SelectionMode mode) {
        this();
        this.setId(id);
        this.setLabel(label);
        this.type = type;
        this.mode = mode;
        this.markStructured();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    @Override
    protected JFileChooser createComponent() {
        this._chooser = new JFileChooser();
        return this._chooser;
    }

    @Override
    protected void structureComponentCustom(JFileChooser comp) {
    }

    @Override
    protected void updateComponentCustom(JFileChooser old) {
        this._chooser.setDialogType(this.type.value);
        this._chooser.setFileSelectionMode(this.mode.mode);
        if (this.path != null) {
            this._chooser.setSelectedFile(new File(this.path));
        } else {
            this._chooser.setSelectedFile(null);
            this._chooser.setCurrentDirectory(null);
        }
    }

    @Override
    protected void commitComponentCustom(JFileChooser comp) {
        File file = this._chooser.getSelectedFile();
        this.path = file != null ? file.getAbsolutePath() : null;
    }

    @Override
    public boolean show() {
        JFileChooser chooser = (JFileChooser)this.getComponent();
        chooser.rescanCurrentDirectory();
        int res = this.type == ChooserType.OPEN ? chooser.showOpenDialog(null) : chooser.showSaveDialog(null);
        if (res == 0) {
            this.commitComponent();
            return true;
        }
        return false;
    }

    @Override
    public void hide() {
    }

    static enum Param {
        formatChooser;

    }

    static enum SelectionMode {
        FILES_ONLY(0),
        DIRECTORIES_ONLY(1),
        FILES_AND_DIRECTORIES(2);

        int mode;

        private SelectionMode(int mode) {
            this.mode = mode;
        }
    }

    static enum ChooserType {
        OPEN(0),
        SAVE(1);

        int value;

        private ChooserType(int type) {
            this.value = type;
        }
    }
}

