/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.XmlUnit;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.filechooser.FileFilter;

public class FileFormat
extends FormDialog {
    @XmlUnit.Serial
    public String[] extensions;
    FileFilter _filter;

    public String[] getExtensions() {
        if (this.extensions == null) {
            String[] tmp = new String[]{this.getLabelToDisplay().toLowerCase()};
            return tmp;
        }
        return this.extensions;
    }

    public String getDescription() {
        String desc = this.getLabelToDisplay() + " (";
        for (String ext : this.getExtensions()) {
            desc = desc + "*." + ext + ", ";
        }
        return desc.substring(0, desc.length() - 2) + ")";
    }

    public boolean matchExtension(String path) {
        int dot = path.lastIndexOf(46);
        if (dot < path.length() - 1) {
            String ext = path.substring(dot + 1);
            for (String str : this.getExtensions()) {
                if (!str.equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchExtension(File f) {
        try {
            return this.matchExtension(f.getCanonicalPath());
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public FileFilter getFileFilter() {
        if (this._filter == null) {
            this._filter = new CustomFileFilter();
        }
        return this._filter;
    }

    class CustomFileFilter
    extends FileFilter {
        CustomFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return FileFormat.this.matchExtension(f);
        }

        @Override
        public String getDescription() {
            return FileFormat.this.getDescription();
        }
    }
}

