/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.FieldChecker;
import com.edgytech.swingfast.FileFormat;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.ImageFilePreview;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.TextField;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileChooserDialog
extends FormDialog
implements ActionListener {
    @XmlUnit.Serial
    ChooserType type;
    @XmlUnit.Serial
    SelectionMode selectionMode;
    @XmlUnit.SerialStar
    String path;
    @XmlUnit.SerialStar
    String directory;
    @XmlUnit.Serial
    boolean imagePreview;
    @XmlUnit.Serial
    int imagePreviewWidth;
    @XmlUnit.Serial
    int imagePreviewHeight;
    @XmlUnit.Serial
    String imagePreviewTitle;
    JFileChooser _chooser;
    JComboBox _formatCombo;
    ArrayList<FileFormat> _formats;
    ImageFilePreview _imageFilePreview;
    JButton _createFolder;

    private static JList findJList(Component component_) {
        if (component_ instanceof JList) {
            return (JList)component_;
        }
        if (component_ instanceof Container) {
            Component[] components_;
            for (Component comp_ : components_ = ((Container)component_).getComponents()) {
                JList childComponent_ = FileChooserDialog.findJList(comp_);
                if (childComponent_ == null) continue;
                return childComponent_;
            }
        }
        return null;
    }

    public FileChooserDialog() {
        this.buttons = FormDialog.ButtonConfig.OK_CANCEL;
        this.type = ChooserType.OPEN;
        this.selectionMode = SelectionMode.FILES_ONLY;
        this.imagePreview = false;
        this.imagePreviewWidth = 256;
        this.imagePreviewHeight = 256;
        this.imagePreviewTitle = null;
    }

    public FileChooserDialog(String id, ChooserType type, SelectionMode mode) {
        this();
        this.setId(id);
        this.type = type;
        this.selectionMode = mode;
        this.structure(null);
        this.markStructured();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPathOrDirectory() {
        if (this.path != null) {
            return this.getPath();
        }
        if (this.directory != null && this.folderOk()) {
            return this.getDirectory();
        }
        return null;
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
        if (state == XmlUnit.State.STRUCTURE) {
            this._formats = new ArrayList();
            this.getChildrenOfClass(FileFormat.class, this._formats);
        }
        super.xmlPostLoadComponentCallback(unit, state);
    }

    @Override
    public void addFieldsDivComponent(BoxPanel global) {
        BoxPanel group = new BoxPanel(Common.Axis.X, false);
        BoxPanel mainColumn = new BoxPanel(Common.Axis.Y, false);
        BoxPanel sideColumn = new BoxPanel(Common.Axis.Y, false);
        this._chooser = new JFileChooser(this.path);
        if (this.type != null) {
            this._chooser.setDialogType(this.type.value);
        }
        if (this.selectionMode != null) {
            this._chooser.setFileSelectionMode(this.selectionMode.mode);
        }
        this._chooser.setControlButtonsAreShown(false);
        if (this._formats != null && this._formats.size() > 0) {
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    for (FileFormat fmt : FileChooserDialog.this._formats) {
                        if (!fmt.matchExtension(f)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    String desc = "Known Formats (";
                    for (FileFormat fmt : FileChooserDialog.this._formats) {
                        for (String str : fmt.getExtensions()) {
                            desc = desc + "*." + str + ", ";
                        }
                    }
                    return desc.substring(0, desc.length() - 2) + ")";
                }
            };
            this._chooser.addChoosableFileFilter(filter);
            Iterator<FileFormat> i$ = this._formats.iterator();
            while (i$.hasNext()) {
                FileFormat obj;
                FileFormat ext = obj = i$.next();
                this._chooser.addChoosableFileFilter(ext.getFileFilter());
            }
        }
        mainColumn.add(this._chooser);
        if (this._formats != null && this._formats.size() > 0) {
            String str = "Auto;";
            for (FileFormat fmt : this._formats) {
                str = str + fmt.getDescription() + ";";
            }
            str = str.substring(0, str.length() - 1);
            this._formatCombo = new JComboBox<String>(str.split(";"));
            this._formatCombo.addActionListener(this);
            this._formatCombo.setBorder(new TitledBorder("Format"));
            mainColumn.add(this._formatCombo);
        }
        if (SwingFast.isMacOSX() && this.type == ChooserType.SAVE) {
            this._createFolder = new JButton("Create Folder");
            this._createFolder.setAction(new NewFolderAction(this._chooser));
            mainColumn.add(this._createFolder);
        }
        if (this.imagePreview) {
            this._imageFilePreview = new ImageFilePreview(this._chooser, this.imagePreviewWidth, this.imagePreviewHeight, this.imagePreviewTitle);
            sideColumn.add(this._imageFilePreview);
        }
        group.add(mainColumn);
        group.add(sideColumn);
        global.add(group);
        super.addFieldsDivComponent(global);
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        if (this.path != null) {
            this._chooser.setSelectedFile(new File(this.path));
            this.correctFormatFromPath();
        } else if (this.directory != null) {
            this._chooser.setCurrentDirectory(new File(this.directory));
        } else {
            this._chooser.setSelectedFile(null);
            this._chooser.setCurrentDirectory(null);
        }
    }

    @Override
    protected void commitComponentCustom(JDialog comp) {
        File file = this._chooser.getSelectedFile();
        this.path = file != null ? file.getAbsolutePath() : null;
        File folder = this._chooser.getCurrentDirectory();
        this.directory = folder != null ? folder.getPath() : null;
    }

    @Override
    public boolean checkComponent(FieldChecker checker) {
        if (this._chooser.getUI() instanceof BasicFileChooserUI) {
            BasicFileChooserUI ui = (BasicFileChooserUI)this._chooser.getUI();
            ui.getApproveSelectionAction().actionPerformed(null);
        }
        return super.checkComponent(checker);
    }

    @Override
    public boolean show() {
        if (this._chooser != null) {
            this._chooser.rescanCurrentDirectory();
        }
        if (this._imageFilePreview != null) {
            this._imageFilePreview.start();
        }
        boolean res = super.show();
        if (this._imageFilePreview != null) {
            this._imageFilePreview.stop();
        }
        if (res && this.getFormats() != null && this.getFormats().size() > 0) {
            String path = this.getPath();
            try {
                this.correctFormatFromPath();
                FileFormat fmt = this.getSelectedFormat();
                if (fmt != null) {
                    res = fmt.show();
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, null, ex);
            }
        }
        return res;
    }

    private void correctFormatFromPath() {
        int dot = this.path.lastIndexOf(46);
        if (dot > 0 && dot < this.path.length() - 1) {
            String ext = this.path.substring(dot + 1);
            int i = 0;
            if (this._formats != null) {
                for (FileFormat fmt : this._formats) {
                    if (fmt.matchExtension(ext)) {
                        this._formatCombo.setSelectedIndex(i + 1);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void correctPathFromFormat() {
        if (this._formatCombo.getSelectedIndex() > 0) {
            try {
                this._chooser.approveSelection();
                FileFormat fmt = this._formats.get(this._formatCombo.getSelectedIndex() - 1);
                File f = this._chooser.getSelectedFile();
                String p = f.getCanonicalPath();
                int dot = p.lastIndexOf(46);
                if (dot > 0) {
                    p = p.substring(0, dot);
                }
                p = p + "." + fmt.getExtensions()[0];
                this._chooser.setSelectedFile(new File(p));
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.correctPathFromFormat();
    }

    public ArrayList<FileFormat> getFormats() {
        return this._formats;
    }

    public FileFormat getSelectedFormat() {
        return this._formats.get(this._formatCombo.getSelectedIndex());
    }

    private boolean folderOk() {
        return this.selectionMode == SelectionMode.DIRECTORIES_ONLY || this.selectionMode == SelectionMode.FILES_AND_DIRECTORIES;
    }

    class NewFolderAction
    extends AbstractAction {
        JFileChooser chooser;

        public NewFolderAction(JFileChooser chooser) {
            super("Create Folder");
            this.chooser = chooser;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir = this.chooser.getCurrentDirectory();
            if (dir != null) {
                final TextField text = new TextField(null, "Folder Name", "");
                FormDialog dia = new FormDialog("folderCreation", null, FormDialog.ButtonConfig.OK_CANCEL){

                    @Override
                    protected void structure(Element elmt) {
                        super.structure(elmt);
                        this.addChild(text);
                    }
                };
                if (dia.show()) {
                    File newdir = new File(dir, text.getStringValue());
                    newdir.mkdirs();
                }
                this.chooser.rescanCurrentDirectory();
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        JFileChooser chooser;

        public DeleteAction(JFileChooser chooser) {
            super("Delete");
            this.chooser = chooser;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.chooser.getSelectedFile();
            if (file != null) {
                if (new ConfirmDialog(null, "File Deletion", null, "Delete '" + file.getPath() + "' ?").show()) {
                    file.delete();
                }
                this.chooser.rescanCurrentDirectory();
            }
        }
    }

    class ContextMenuFileChooser
    extends JFileChooser {
        public ContextMenuFileChooser(String path) {
            super(path);
            JList list = FileChooserDialog.findJList(this);
            JPopupMenu pop = list.getComponentPopupMenu();
            pop.add(new DeleteAction(this));
            pop.add(new NewFolderAction(this));
            list.setComponentPopupMenu(pop);
        }
    }

    static enum Param {
        formatChooser;

    }

    static enum SelectionMode {
        FILES_ONLY(0),
        DIRECTORIES_ONLY(1),
        FILES_AND_DIRECTORIES(2);

        int mode;

        private SelectionMode(int mode) {
            this.mode = mode;
        }
    }

    static enum ChooserType {
        OPEN(0),
        SAVE(1),
        CUSTOM(2);

        int value;

        private ChooserType(int type) {
            this.value = type;
        }
    }
}

