/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.FileFormat;
import com.edgytech.swingfast.ImageFileView;
import com.edgytech.swingfast.Showable;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;

public class FileChooser
extends XmlJComponentUnit<XmlUnit, JFileChooser>
implements Showable,
ActionListener {
    @XmlUnit.Serial
    ChooserType type = ChooserType.OPEN;
    @XmlUnit.Serial
    SelectionMode selectionMode = SelectionMode.FILES_ONLY;
    @XmlUnit.Serial
    String okLabel = "Ok";
    @XmlUnit.Serial
    boolean imagePreview = false;
    @XmlUnit.SerialStar
    String path;
    JComboBox _formatCombo;
    ArrayList<FileFormat> _formats;
    Component _owner;

    public FileChooser() {
    }

    public FileChooser(String id, Component owner, ChooserType type, SelectionMode mode) {
        this();
        this.setId(id);
        this._owner = owner;
        this.type = type;
        this.selectionMode = mode;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    @Override
    protected JFileChooser createComponent() {
        JFileChooser fc = new JFileChooser();
        if (this.selectionMode != null) {
            fc.setFileSelectionMode(this.selectionMode.mode);
        }
        return fc;
    }

    @Override
    protected void structureComponentCustom(JFileChooser old) {
        BoxPanel accessory = new BoxPanel(Common.Axis.Y, false);
        if (this._formats != null && this._formats.size() > 0) {
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    for (FileFormat fmt : FileChooser.this._formats) {
                        if (!fmt.matchExtension(f)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    String desc = "Known Formats (";
                    for (FileFormat fmt : FileChooser.this._formats) {
                        for (String str : fmt.getExtensions()) {
                            desc = desc + "*." + str + ", ";
                        }
                    }
                    return desc.substring(0, desc.length() - 2) + ")";
                }
            };
            old.addChoosableFileFilter(filter);
            Iterator<FileFormat> i$ = this._formats.iterator();
            while (i$.hasNext()) {
                FileFormat obj;
                FileFormat ext = obj = i$.next();
                old.addChoosableFileFilter(ext.getFileFilter());
            }
        }
        old.setFileFilter(old.getAcceptAllFileFilter());
        if (this._formats != null && this._formats.size() > 0) {
            String str = "Auto;";
            for (FileFormat fmt : this._formats) {
                str = str + fmt.getDescription() + ";";
            }
            str = str.substring(0, str.length() - 1);
            this._formatCombo = new JComboBox<String>(str.split(";"));
            this._formatCombo.addActionListener(this);
            this._formatCombo.setBorder(new TitledBorder("Format"));
            this._formatCombo.setMinimumSize(this._formatCombo.getPreferredSize());
            this._formatCombo.setMaximumSize(this._formatCombo.getPreferredSize());
            accessory.add(this._formatCombo);
        }
        if (accessory.getComponentCount() > 0) {
            accessory.addGlue();
            old.setAccessory(accessory);
        }
        old.setFileView(new ImageFileView());
    }

    @Override
    protected void updateComponentCustom(JFileChooser old) {
        if (this.path != null) {
            old.setSelectedFile(new File(this.path));
            this.correctFormatFromPath();
        }
    }

    @Override
    protected void commitComponentCustom(JFileChooser comp) {
        File file = comp.getSelectedFile();
        this.path = file != null ? file.getAbsolutePath() : null;
    }

    @Override
    protected void xmlPostLoadComponentCallback(Node unit, XmlUnit.State state) {
        if (state == XmlUnit.State.STRUCTURE) {
            this._formats = new ArrayList();
            this.getChildrenOfClass(FileFormat.class, this._formats);
        }
        super.xmlPostLoadComponentCallback(unit, state);
    }

    @Override
    public boolean show() {
        JFileChooser chooser = (JFileChooser)this.getComponent();
        Component owner = this._owner;
        if (owner == null) {
            owner = SwingFast.getMasterFrame().getComponent();
        }
        chooser.rescanCurrentDirectory();
        int res = 0;
        res = this.type == ChooserType.OPEN ? chooser.showOpenDialog(owner) : (this.type == ChooserType.SAVE ? chooser.showOpenDialog(owner) : chooser.showDialog(owner, this.okLabel));
        if (res == 0) {
            this.commitComponent();
            return true;
        }
        return false;
    }

    @Override
    public void hide() {
    }

    private void correctFormatFromPath() {
        int dot;
        if (this.path != null && (dot = this.path.lastIndexOf(46)) > 0 && dot < this.path.length() - 1) {
            String ext = this.path.substring(dot + 1);
            int i = 0;
            for (FileFormat fmt : this._formats) {
                if (fmt.matchExtension(ext)) {
                    this._formatCombo.setSelectedIndex(i + 1);
                    break;
                }
                ++i;
            }
        }
    }

    private void correctPathFromFormat() {
        JFileChooser fc = (JFileChooser)this.getComponent();
        if (this._formatCombo.getSelectedIndex() > 0) {
            try {
                FileFormat fmt = this._formats.get(this._formatCombo.getSelectedIndex() - 1);
                File f = fc.getSelectedFile();
                if (f != null) {
                    String p = f.getCanonicalPath();
                    int dot = p.lastIndexOf(46);
                    if (dot > 0) {
                        p = p.substring(0, dot);
                    }
                    p = p + "." + fmt.getExtensions()[0];
                    fc.setSelectedFile(new File(p));
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.correctPathFromFormat();
    }

    public ArrayList<FileFormat> getFormats() {
        return this._formats;
    }

    static enum SelectionMode {
        FILES_ONLY(0),
        DIRECTORIES_ONLY(1),
        FILES_AND_DIRECTORIES(2);

        int mode;

        private SelectionMode(int mode) {
            this.mode = mode;
        }
    }

    static enum ChooserType {
        OPEN(0),
        SAVE(1),
        CUSTOM(2);

        int value;

        private ChooserType(int type) {
            this.value = type;
        }
    }
}

