/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.FieldChecker;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class FieldBase
extends XmlJComponentUnit<XmlUnit, JComponent> {
    @XmlUnit.Serial
    int size = 0;
    JLabel _jlabel;
    JLabel _error;
    static final Color C_NORMAL = Color.DARK_GRAY;
    static final Color C_ERROR = Color.RED;

    protected abstract void loadRealValue();

    public void resetDisplay() {
        this.loadRealValue();
        this.setDisplayNormal();
    }

    public abstract void commitTempValue();

    protected abstract boolean checkTempFieldValue();

    public boolean checkTempValue(FieldChecker checker) {
        Enum enm;
        boolean res = this.checkTempFieldValue();
        if (checker == null || (enm = this.getBoundEnum()) != null) {
            // empty if block
        }
        return res;
    }

    @Override
    protected JComponent createComponent() {
        BoxPanel comp = new BoxPanel(Common.Axis.X, Common.Align.CENTER, false);
        return comp;
    }

    @Override
    protected void structureComponentCustom(JComponent old) {
        BoxPanel comp = (BoxPanel)old;
        comp.removeAll();
        BoxPanel content = new BoxPanel(Common.Axis.Y, Common.Align.CENTER, false);
        comp.add(content);
        BoxPanel body = new BoxPanel(Common.Axis.X, Common.Align.CENTER, false);
        content.add(body);
        this._jlabel = new JLabel(this.getLabelToDisplay() + " : ", 4);
        body.add(this._jlabel);
        this.addValuePanel(body);
        this._error = new JLabel();
        this._error.setForeground(C_ERROR);
        this._error.setVisible(false);
        content.add(this._error);
    }

    @Override
    protected void updateComponentCustom(JComponent old) {
        this.loadRealValue();
    }

    protected abstract void addValuePanel(BoxPanel var1);

    public void setDisplayNormal() {
        if (this._jlabel != null) {
            this._jlabel.setForeground(C_NORMAL);
        }
        if (this._error != null) {
            this._error.setVisible(false);
        }
    }

    public void setDisplayError(String error) {
        if (this._jlabel != null) {
            this._jlabel.setForeground(C_ERROR);
        }
        if (this._error != null) {
            this._error.setText(error);
            this._error.setVisible(true);
        }
    }

    public JLabel getLabelField() {
        return this._jlabel;
    }
}

