/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.XmlUnit;
import java.util.HashMap;
import java.util.logging.Logger;

public class EnumBinding {
    private HashMap<Enum, XmlUnit> unitMap;
    private HashMap<String, Enum> enmMap;
    private EnumListener listener;
    private Enum[] _enms;
    static final Logger LOGGER = Logger.getLogger(EnumBinding.class.getSimpleName());

    public EnumBinding(Enum[] enms, EnumListener listener) {
        this._enms = enms;
        this.enmMap = new HashMap();
        for (Enum enm : enms) {
            this.enmMap.put(enm.name(), enm);
        }
        this.unitMap = new HashMap();
        this.listener = listener;
    }

    public Enum[] getBindings() {
        return this._enms;
    }

    public void registerUnit(XmlUnit unit) {
        Enum enm = this.enmMap.get(unit.getId());
        if (enm != null) {
            if (this.unitMap.containsKey(enm)) {
                LOGGER.warning("Enum '" + enm.name() + "' is already associated with another unit");
            }
            this.unitMap.put(enm, unit);
        }
        unit.setBoundEnum(enm);
    }

    public void clearUnits() {
        this.unitMap.clear();
    }

    XmlUnit getUnit(Enum enm) {
        return this.unitMap.get(enm);
    }

    XmlUnit getUnit(String name) {
        Enum enm = this.enmMap.get(name);
        if (enm != null) {
            return this.unitMap.get(enm);
        }
        return null;
    }

    EnumListener getListener() {
        return this.listener;
    }
}

