/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.swingfast;

import com.edgytech.swingfast.BoxPanel;
import com.edgytech.swingfast.Common;
import com.edgytech.swingfast.Glue;
import com.edgytech.swingfast.SwingFast;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.swingfast.XmlUnitField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JLabel;

public class Div<T extends XmlUnit, C extends BoxPanel>
extends XmlUnitField<T, C> {
    @XmlUnit.Serial
    public boolean titled = false;
    @XmlUnit.Serial
    public Common.Axis axis = Common.Axis.Y;
    @XmlUnit.Serial
    public Common.Align align = Common.Align.CENTER;
    @XmlUnit.Serial
    public boolean gap = false;
    @XmlUnit.Serial
    public int gapSize = -1;
    @XmlUnit.Serial
    public boolean evenWidth = false;
    @XmlUnit.Serial
    public boolean evenHeight = false;

    public Div() {
        this.field = false;
        this.fill = false;
        this.opaque = false;
    }

    public Div(String id, String title, Common.Axis axis, Common.Align align) {
        this();
        this.setId(id);
        if (title != null) {
            this.setLabel(title);
            this.titled = true;
        }
        this.setAxis(axis);
        this.setAlign(align);
        this.markStructured();
    }

    public Common.Align getAlign() {
        return this.align;
    }

    public void setAlign(Common.Align align) {
        this.align = align;
    }

    public Common.Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Common.Axis axis) {
        this.axis = axis;
    }

    public boolean getGap() {
        return this.gap;
    }

    public void setGap(boolean gap) {
        this.gap = gap;
    }

    public boolean getTitled() {
        return this.titled;
    }

    public void setTitled(boolean b) {
        this.titled = b;
    }

    @Override
    protected C createComponent() {
        BoxPanel panel = new BoxPanel(this.getAxis(), this.getAlign(), this.getGap(), this.gapSize);
        if (this.getTitled()) {
            panel.setBorderTitle(this.getLabelToDisplay());
        }
        return (C)panel;
    }

    @Override
    protected void structureComponentCustom(C old) {
        Object comp;
        ((BoxPanel)old).removeAll();
        if (this.hasChildren()) {
            for (XmlUnit child : this.getChildren()) {
                if (XmlComponentUnit.class.isInstance(child)) {
                    Component comp2 = ((XmlComponentUnit)child).getDisplayComponent();
                    if (Window.class.isInstance(comp2)) continue;
                    ((BoxPanel)old).add(comp2);
                    continue;
                }
                if (!Glue.class.isInstance(child)) continue;
                if (((Glue)child).size != null) {
                    ((BoxPanel)old).addRigidArea(((Glue)child).size);
                    continue;
                }
                if (this.axis == Common.Axis.X) {
                    ((BoxPanel)old).addXGlue();
                    continue;
                }
                ((BoxPanel)old).addYGlue();
            }
        }
        if (this.hasChildren()) {
            JLabel label;
            int max = 0;
            for (XmlUnit field : this.getChildren()) {
                int w;
                if (!XmlUnitField.class.isInstance(field) || (label = ((XmlUnitField)field).getFieldLabel()) == null || (w = label.getPreferredSize().width) <= max) continue;
                max = w;
            }
            if (max > 0) {
                for (XmlUnit field : this.getChildren()) {
                    if (!XmlUnitField.class.isInstance(field) || (label = ((XmlUnitField)field).getFieldLabel()) == null) continue;
                    Dimension dim = label.getPreferredSize();
                    dim.width = max;
                    label.setPreferredSize(dim);
                }
            }
        }
        if (this.evenWidth) {
            int max = 0;
            for (XmlUnit unit : this.getChildren()) {
                int w;
                if (!XmlComponentUnit.class.isInstance(unit) || (comp = ((XmlComponentUnit)unit).getComponent()) == null || (w = ((Component)comp).getPreferredSize().width) <= max) continue;
                max = w;
            }
            if (max > 0) {
                for (XmlUnit unit : this.getChildren()) {
                    if (!XmlComponentUnit.class.isInstance(unit) || (comp = ((XmlComponentUnit)unit).getComponent()) == null) continue;
                    Dimension dim = ((Component)comp).getPreferredSize();
                    dim.width = max;
                    SwingFast.setFixedSize(comp, dim);
                }
            }
        }
        if (this.evenHeight) {
            int max = 0;
            for (XmlUnit unit : this.getChildren()) {
                int h;
                if (!XmlComponentUnit.class.isInstance(unit) || (comp = ((XmlComponentUnit)unit).getComponent()) == null || (h = ((Component)comp).getPreferredSize().height) <= max) continue;
                max = h;
            }
            if (max > 0) {
                for (XmlUnit unit : this.getChildren()) {
                    if (!XmlComponentUnit.class.isInstance(unit) || (comp = ((XmlComponentUnit)unit).getComponent()) == null) continue;
                    Dimension dim = ((Component)comp).getPreferredSize();
                    dim.width = max;
                    ((Component)comp).setPreferredSize(dim);
                }
            }
        }
    }

    @Override
    protected void updateComponentCustom(C old) {
    }

    @Override
    protected boolean checkComponentCustom(C comp) {
        return true;
    }

    @Override
    protected void commitComponentCustom(C comp) {
    }
}

